/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.common.iterator.EmptyIterator;
import org.eclipse.rdf4j.common.iterator.UnionIterator;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.BindingSetHashKey;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;

public class HashJoinIteration
extends LookAheadIteration<BindingSet, QueryEvaluationException> {
    protected final String[] joinAttributes;
    private final CloseableIteration<BindingSet, QueryEvaluationException> leftIter;
    private final CloseableIteration<BindingSet, QueryEvaluationException> rightIter;
    private final boolean leftJoin;
    private Iterator<BindingSet> scanList;
    private CloseableIteration<BindingSet, QueryEvaluationException> restIter;
    private Map<BindingSetHashKey, List<BindingSet>> hashTable;
    private BindingSet currentScanElem;
    private Iterator<BindingSet> hashTableValues;

    public HashJoinIteration(EvaluationStrategy strategy, Join join, BindingSet bindings) throws QueryEvaluationException {
        this(strategy, join.getLeftArg(), join.getRightArg(), bindings, false);
        join.setAlgorithm((Iteration)this);
    }

    public HashJoinIteration(EvaluationStrategy strategy, LeftJoin join, BindingSet bindings) throws QueryEvaluationException {
        this(strategy, join.getLeftArg(), join.getRightArg(), bindings, true);
        join.setAlgorithm((Iteration)this);
    }

    public HashJoinIteration(EvaluationStrategy strategy, TupleExpr left, TupleExpr right, BindingSet bindings, boolean leftJoin) throws QueryEvaluationException {
        this(strategy, strategy.evaluate(left, bindings), left.getBindingNames(), strategy.evaluate(right, bindings), right.getBindingNames(), leftJoin);
    }

    public HashJoinIteration(EvaluationStrategy strategy, CloseableIteration<BindingSet, QueryEvaluationException> leftIter, Set<String> leftBindingNames, CloseableIteration<BindingSet, QueryEvaluationException> rightIter, Set<String> rightBindingNames, boolean leftJoin) throws QueryEvaluationException {
        this.leftIter = leftIter;
        this.rightIter = rightIter;
        Set<String> joinAttributeNames = leftBindingNames;
        joinAttributeNames.retainAll(rightBindingNames);
        this.joinAttributes = joinAttributeNames.toArray(new String[joinAttributeNames.size()]);
        this.leftJoin = leftJoin;
    }

    protected BindingSet getNextElement() throws QueryEvaluationException {
        Map<BindingSetHashKey, List<BindingSet>> nextHashTable = this.hashTable;
        if (nextHashTable == null) {
            nextHashTable = this.hashTable = this.setupHashTable();
        }
        Object nextHashTableValues = this.hashTableValues;
        while (this.currentScanElem == null) {
            if (this.scanList.hasNext()) {
                this.currentScanElem = this.nextFromCache(this.scanList);
            } else {
                this.disposeCache(this.scanList);
                if (this.restIter.hasNext()) {
                    this.currentScanElem = (BindingSet)this.restIter.next();
                } else {
                    return null;
                }
            }
            if (this.currentScanElem == null) continue;
            if (this.currentScanElem instanceof EmptyBindingSet) {
                Collection<List<BindingSet>> values = nextHashTable.values();
                boolean empty = values.isEmpty() || values.size() == 1 && values.contains(null);
                this.hashTableValues = empty ? new EmptyIterator() : new UnionIterator(values);
                nextHashTableValues = this.hashTableValues;
                if (nextHashTableValues.hasNext()) continue;
                this.currentScanElem = null;
                this.closeHashValue((Iterator)nextHashTableValues);
                this.hashTableValues = null;
                nextHashTableValues = null;
                continue;
            }
            BindingSetHashKey key = BindingSetHashKey.create(this.joinAttributes, this.currentScanElem);
            List<BindingSet> hashValue = nextHashTable.get(key);
            if (hashValue != null && !hashValue.isEmpty()) {
                this.hashTableValues = hashValue.iterator();
                nextHashTableValues = this.hashTableValues;
                continue;
            }
            if (this.leftJoin) {
                this.hashTableValues = Collections.singletonList(EmptyBindingSet.getInstance()).iterator();
                nextHashTableValues = this.hashTableValues;
                continue;
            }
            this.currentScanElem = null;
            this.closeHashValue((Iterator)nextHashTableValues);
            this.hashTableValues = null;
            nextHashTableValues = null;
        }
        if (nextHashTableValues != null) {
            BindingSet nextHashTableValue = nextHashTableValues.next();
            QueryBindingSet result = new QueryBindingSet(this.currentScanElem);
            for (String name : nextHashTableValue.getBindingNames()) {
                Value v;
                if (result.hasBinding(name) || (v = nextHashTableValue.getValue(name)) == null) continue;
                result.addBinding(name, v);
            }
            if (!nextHashTableValues.hasNext()) {
                this.currentScanElem = null;
                this.closeHashValue((Iterator)nextHashTableValues);
                this.hashTableValues = null;
                nextHashTableValues = null;
            }
            return result;
        }
        return EmptyBindingSet.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleClose() throws QueryEvaluationException {
        try {
            super.handleClose();
        }
        finally {
            try {
                if (this.leftIter != null) {
                    this.leftIter.close();
                }
            }
            finally {
                try {
                    if (this.rightIter != null) {
                        this.rightIter.close();
                    }
                }
                finally {
                    try {
                        Iterator<BindingSet> toCloseHashTableValues = this.hashTableValues;
                        this.hashTableValues = null;
                        if (toCloseHashTableValues != null) {
                            this.closeHashValue(toCloseHashTableValues);
                        }
                    }
                    finally {
                        try {
                            Iterator<BindingSet> toCloseScanList = this.scanList;
                            this.scanList = null;
                            if (toCloseScanList != null) {
                                this.disposeCache(toCloseScanList);
                            }
                        }
                        finally {
                            Map<BindingSetHashKey, List<BindingSet>> toCloseHashTable = this.hashTable;
                            this.hashTable = null;
                            if (toCloseHashTable != null) {
                                this.disposeHashTable(toCloseHashTable);
                            }
                        }
                    }
                }
            }
        }
    }

    private Map<BindingSetHashKey, List<BindingSet>> setupHashTable() throws QueryEvaluationException {
        Collection<Object> leftArgResults;
        Collection<BindingSet> rightArgResults = this.makeIterationCache(this.rightIter);
        if (!this.leftJoin) {
            leftArgResults = this.makeIterationCache(this.leftIter);
            while (this.leftIter.hasNext() && this.rightIter.hasNext()) {
                this.add(leftArgResults, (BindingSet)this.leftIter.next());
                this.add(rightArgResults, (BindingSet)this.rightIter.next());
            }
        } else {
            leftArgResults = Collections.emptyList();
            while (this.rightIter.hasNext()) {
                this.add(rightArgResults, (BindingSet)this.rightIter.next());
            }
        }
        Collection<Object> smallestResult = null;
        if (this.leftJoin || this.leftIter.hasNext()) {
            smallestResult = rightArgResults;
            this.scanList = leftArgResults.iterator();
            this.restIter = this.leftIter;
        } else {
            smallestResult = leftArgResults;
            this.scanList = rightArgResults.iterator();
            this.restIter = this.rightIter;
        }
        leftArgResults = null;
        rightArgResults = null;
        Map<BindingSetHashKey, List<BindingSet>> resultHashTable = this.makeHashTable(smallestResult.size());
        int maxListSize = 1;
        for (BindingSet bindingSet : smallestResult) {
            boolean newEntry;
            BindingSetHashKey hashKey = BindingSetHashKey.create(this.joinAttributes, bindingSet);
            List<BindingSet> hashValue = resultHashTable.get(hashKey);
            boolean bl = newEntry = hashValue == null;
            if (newEntry) {
                hashValue = this.makeHashValue(maxListSize);
            }
            this.add(hashValue, bindingSet);
            this.putHashTableEntry(resultHashTable, hashKey, hashValue, newEntry);
            maxListSize = Math.max(maxListSize, hashValue.size());
        }
        return resultHashTable;
    }

    protected void putHashTableEntry(Map<BindingSetHashKey, List<BindingSet>> nextHashTable, BindingSetHashKey hashKey, List<BindingSet> hashValue, boolean newEntry) throws QueryEvaluationException {
        if (newEntry) {
            nextHashTable.put(hashKey, hashValue);
        }
    }

    protected Collection<BindingSet> makeIterationCache(CloseableIteration<BindingSet, QueryEvaluationException> iter) {
        return new ArrayList<BindingSet>();
    }

    protected Map<BindingSetHashKey, List<BindingSet>> makeHashTable(int initialSize) {
        Map<BindingSetHashKey, List<Object>> nextHashTable;
        if (this.joinAttributes.length > 0) {
            nextHashTable = new HashMap<BindingSetHashKey, List<BindingSet>>(initialSize);
        } else {
            ArrayList l = initialSize > 0 ? new ArrayList(initialSize) : null;
            nextHashTable = Collections.singletonMap(BindingSetHashKey.EMPTY, l);
        }
        return nextHashTable;
    }

    protected List<BindingSet> makeHashValue(int currentMaxListSize) {
        return new ArrayList<BindingSet>(currentMaxListSize / 2 + 1);
    }

    protected void disposeCache(Iterator<BindingSet> iter) {
    }

    protected void disposeHashTable(Map<BindingSetHashKey, List<BindingSet>> map) {
    }

    protected <E> void closeHashValue(Iterator<E> iter) {
    }

    protected <E> E nextFromCache(Iterator<E> iter) {
        return iter.next();
    }

    protected <E> void add(Collection<E> col, E value) throws QueryEvaluationException {
        col.add(value);
    }

    protected <E> void addAll(Collection<E> col, List<E> values) throws QueryEvaluationException {
        col.addAll(values);
    }
}

