/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl;

import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.sail.NotifyingSail;
import org.eclipse.rdf4j.sail.helpers.NotifyingSailWrapper;
import org.eclipse.rdf4j.sail.inferencer.fc.SchemaCachingRDFSInferencer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ShaclSailBaseConfiguration
extends NotifyingSailWrapper {
    private static final Logger logger = LoggerFactory.getLogger(ShaclSailBaseConfiguration.class);
    final boolean sparqlValidation = !"false".equalsIgnoreCase(System.getProperty("org.eclipse.rdf4j.sail.shacl.sparqlValidation"));
    private boolean parallelValidation = true;
    private boolean logValidationPlans = false;
    private boolean logValidationViolations = false;
    private boolean validationEnabled = true;
    private boolean cacheSelectNodes = true;
    private boolean rdfsSubClassReasoning = true;
    private boolean serializableValidation = true;
    private boolean performanceLogging = false;
    private boolean eclipseRdf4jShaclExtensions = false;
    private boolean dashDataShapes = false;
    private long validationResultsLimitTotal = 1000000L;
    private long validationResultsLimitPerConstraint = 1000L;
    private long transactionalValidationLimit = 500000L;
    private boolean logValidationExecution = false;

    public ShaclSailBaseConfiguration(NotifyingSail baseSail) {
        super(baseSail);
    }

    public ShaclSailBaseConfiguration() {
    }

    public boolean isGlobalLogValidationExecution() {
        return this.logValidationExecution;
    }

    public void setGlobalLogValidationExecution(boolean loggingEnabled) {
        this.logValidationExecution = loggingEnabled;
    }

    public boolean isLogValidationViolations() {
        return this.logValidationViolations;
    }

    public void setLogValidationViolations(boolean logValidationViolations) {
        this.logValidationViolations = logValidationViolations;
    }

    public boolean isParallelValidation() {
        return this.parallelValidation;
    }

    public void setParallelValidation(boolean parallelValidation) {
        this.parallelValidation = parallelValidation;
    }

    public boolean isCacheSelectNodes() {
        return this.cacheSelectNodes;
    }

    public void setCacheSelectNodes(boolean cacheSelectNodes) {
        this.cacheSelectNodes = cacheSelectNodes;
    }

    public boolean isRdfsSubClassReasoning() {
        return this.rdfsSubClassReasoning;
    }

    public void setRdfsSubClassReasoning(boolean rdfsSubClassReasoning) {
        this.rdfsSubClassReasoning = rdfsSubClassReasoning;
    }

    public void disableValidation() {
        this.validationEnabled = false;
    }

    public void enableValidation() {
        this.validationEnabled = true;
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    public boolean isLogValidationPlans() {
        return this.logValidationPlans;
    }

    public void setLogValidationPlans(boolean logValidationPlans) {
        this.logValidationPlans = logValidationPlans;
    }

    public boolean isPerformanceLogging() {
        return this.performanceLogging;
    }

    public void setPerformanceLogging(boolean performanceLogging) {
        this.performanceLogging = performanceLogging;
    }

    public boolean isSerializableValidation() {
        if (this.getBaseSail() instanceof SchemaCachingRDFSInferencer) {
            if (this.serializableValidation) {
                logger.warn("SchemaCachingRDFSInferencer is not supported when using serializable validation!");
            }
            return false;
        }
        return this.serializableValidation;
    }

    public void setSerializableValidation(boolean serializableValidation) {
        this.serializableValidation = serializableValidation;
    }

    @Experimental
    public boolean isEclipseRdf4jShaclExtensions() {
        return this.eclipseRdf4jShaclExtensions;
    }

    @Experimental
    public void setEclipseRdf4jShaclExtensions(boolean eclipseRdf4jShaclExtensions) {
        this.eclipseRdf4jShaclExtensions = eclipseRdf4jShaclExtensions;
    }

    @Experimental
    public boolean isDashDataShapes() {
        return this.dashDataShapes;
    }

    @Experimental
    public void setDashDataShapes(boolean dashDataShapes) {
        this.dashDataShapes = dashDataShapes;
    }

    public long getValidationResultsLimitPerConstraint() {
        return this.validationResultsLimitPerConstraint;
    }

    public void setValidationResultsLimitPerConstraint(long validationResultsLimitPerConstraint) {
        this.validationResultsLimitPerConstraint = validationResultsLimitPerConstraint;
    }

    public long getEffectiveValidationResultsLimitPerConstraint() {
        if (this.validationResultsLimitPerConstraint < 0L) {
            return this.validationResultsLimitTotal;
        }
        if (this.validationResultsLimitTotal >= 0L) {
            return Math.min(this.validationResultsLimitTotal, this.validationResultsLimitPerConstraint);
        }
        return this.validationResultsLimitPerConstraint;
    }

    public long getValidationResultsLimitTotal() {
        return this.validationResultsLimitTotal;
    }

    public void setValidationResultsLimitTotal(long validationResultsLimitTotal) {
        this.validationResultsLimitTotal = validationResultsLimitTotal;
    }

    public IsolationLevel getDefaultIsolationLevel() {
        return super.getDefaultIsolationLevel();
    }

    public long getTransactionalValidationLimit() {
        return this.transactionalValidationLimit;
    }

    public void setTransactionalValidationLimit(long transactionalValidationLimit) {
        this.transactionalValidationLimit = transactionalValidationLimit;
    }
}

