/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.rio.RioConfig;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;

public class ParserConfig
extends RioConfig
implements Serializable {
    private static final long serialVersionUID = 270L;
    private Set<RioSetting<?>> nonFatalErrors = new HashSet();

    public ParserConfig setNonFatalErrors(Set<RioSetting<?>> nonFatalErrors) {
        this.nonFatalErrors = new HashSet(nonFatalErrors);
        return this;
    }

    public ParserConfig addNonFatalError(RioSetting<?> nextNonFatalError) {
        this.nonFatalErrors.add(nextNonFatalError);
        return this;
    }

    public boolean isNonFatalError(RioSetting<?> errorToCheck) {
        return this.nonFatalErrors.contains(errorToCheck);
    }

    public Set<RioSetting<?>> getNonFatalErrors() {
        return Collections.unmodifiableSet(this.nonFatalErrors);
    }

    public boolean isPreserveBNodeIDs() {
        return this.get(BasicParserSettings.PRESERVE_BNODE_IDS);
    }

    @Override
    public ParserConfig useDefaults() {
        super.useDefaults();
        this.nonFatalErrors.clear();
        return this;
    }

    @Override
    public <T> ParserConfig set(RioSetting<T> setting, T value) {
        super.set(setting, value);
        return this;
    }
}

