/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryValueEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryEvaluationContext;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.ZeroLengthPathIteration;

public final class ZeroLengthPathEvaluationStep
implements QueryEvaluationStep {
    private final Var subjectVar;
    private final Var objVar;
    private final Var contextVar;
    private final QueryValueEvaluationStep subPrep;
    private final QueryValueEvaluationStep objPrep;
    private final EvaluationStrategy strategy;
    private final QueryEvaluationContext context;

    public ZeroLengthPathEvaluationStep(Var subjectVar, Var objVar, Var contextVar, QueryValueEvaluationStep subPrep, QueryValueEvaluationStep objPrep, EvaluationStrategy strategy, QueryEvaluationContext context) {
        this.subjectVar = subjectVar;
        this.objVar = objVar;
        this.contextVar = contextVar;
        this.subPrep = subPrep;
        this.objPrep = objPrep;
        this.strategy = strategy;
        this.context = context;
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bindings) {
        Value subj = null;
        try {
            subj = this.subPrep.evaluate(bindings);
        }
        catch (QueryEvaluationException queryEvaluationException) {
            // empty catch block
        }
        Value obj = null;
        try {
            obj = this.objPrep.evaluate(bindings);
        }
        catch (QueryEvaluationException queryEvaluationException) {
            // empty catch block
        }
        if (subj != null && obj != null && !subj.equals(obj)) {
            return new EmptyIteration();
        }
        return this.getZeroLengthPathIterator(bindings, this.subjectVar, this.objVar, this.contextVar, subj, obj, this.context);
    }

    protected ZeroLengthPathIteration getZeroLengthPathIterator(BindingSet bindings, Var subjectVar, Var objVar, Var contextVar, Value subj, Value obj, QueryEvaluationContext context) {
        return new ZeroLengthPathIteration(this.strategy, subjectVar, objVar, subj, obj, contextVar, bindings, context);
    }
}

