/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ValidationSettings;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationApproach;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationQuery;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.AbstractConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.AbstractBulkJoinPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.BulkedExternalInnerJoin;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.BulkedExternalLeftOuterJoin;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EmptyNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.GroupByCountFilter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ShiftToPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.TrimToTarget;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.ast.targets.EffectiveTarget;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;

public class MaxCountConstraintComponent
extends AbstractConstraintComponent {
    private final long maxCount;

    public MaxCountConstraintComponent(long maxCount) {
        this.maxCount = maxCount;
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, SHACL.MAX_COUNT, (Value)Values.literal((BigInteger)BigInteger.valueOf(this.maxCount)), new Resource[0]);
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.MaxCountConstraintComponent;
    }

    @Override
    public PlanNode generateTransactionalValidationPlan(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings, PlanNodeProvider overrideTargetNode, ConstraintComponent.Scope scope) {
        PlanNode mergeNode;
        StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider = new StatementMatcher.StableRandomVariableProvider();
        EffectiveTarget effectiveTarget = this.getTargetChain().getEffectiveTarget(scope, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider);
        Optional<Path> path = this.getTargetChain().getPath();
        if (overrideTargetNode != null) {
            mergeNode = effectiveTarget.extend(overrideTargetNode.getPlanNode(), connectionsGroup, validationSettings.getDataGraph(), scope, EffectiveTarget.Extend.right, false, null);
        } else {
            PlanNode addedTargets = effectiveTarget.getPlanNode(connectionsGroup, validationSettings.getDataGraph(), scope, false, null);
            PlanNode addedByPath = path.get().getAdded(connectionsGroup, validationSettings.getDataGraph(), null);
            addedByPath = effectiveTarget.getTargetFilter(connectionsGroup, validationSettings.getDataGraph(), Unique.getInstance(new TrimToTarget(addedByPath), false));
            addedByPath = effectiveTarget.extend(addedByPath, connectionsGroup, validationSettings.getDataGraph(), scope, EffectiveTarget.Extend.left, false, null);
            mergeNode = UnionNode.getInstance(addedTargets, addedByPath);
        }
        mergeNode = Unique.getInstance(new TrimToTarget(mergeNode), false);
        AbstractBulkJoinPlanNode relevantTargetsWithPath = this.maxCount >= 0L ? new BulkedExternalInnerJoin(mergeNode, connectionsGroup.getBaseConnection(), validationSettings.getDataGraph(), this.getTargetChain().getPath().get().getTargetQueryFragment(new StatementMatcher.Variable("a"), new StatementMatcher.Variable("c"), connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider), false, null, b -> new ValidationTuple(b.getValue("a"), b.getValue("c"), scope, true, validationSettings.getDataGraph())) : new BulkedExternalLeftOuterJoin(mergeNode, connectionsGroup.getBaseConnection(), validationSettings.getDataGraph(), this.getTargetChain().getPath().get().getTargetQueryFragment(new StatementMatcher.Variable("a"), new StatementMatcher.Variable("c"), connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider), false, null, b -> new ValidationTuple(b.getValue("a"), b.getValue("c"), scope, true, validationSettings.getDataGraph()));
        GroupByCountFilter groupByCount = new GroupByCountFilter(relevantTargetsWithPath, count -> count > this.maxCount);
        return Unique.getInstance(new TrimToTarget(groupByCount), false);
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, Resource[] dataGraph, ConstraintComponent.Scope scope, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        if (scope == ConstraintComponent.Scope.propertyShape) {
            PlanNode allTargetsPlan = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).getPlanNode(connectionsGroup, dataGraph, ConstraintComponent.Scope.nodeShape, true, null);
            return Unique.getInstance(new ShiftToPropertyShape(allTargetsPlan), true);
        }
        return EmptyNode.getInstance();
    }

    @Override
    public ConstraintComponent deepClone() {
        return new MaxCountConstraintComponent(this.maxCount);
    }

    @Override
    public ValidationQuery generateSparqlValidationQuery(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings, boolean negatePlan, boolean negateChildren, ConstraintComponent.Scope scope) {
        StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider = new StatementMatcher.StableRandomVariableProvider();
        EffectiveTarget effectiveTarget = this.getTargetChain().getEffectiveTarget(scope, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider);
        Object query = effectiveTarget.getQuery(false);
        if (this.maxCount == 0L) {
            StatementMatcher.Variable value = StatementMatcher.Variable.VALUE;
            String pathQuery = this.getTargetChain().getPath().map(p -> p.getTargetQueryFragment(effectiveTarget.getTargetVar(), value, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider)).orElseThrow(IllegalStateException::new);
            query = (String)query + pathQuery;
        } else if (this.maxCount > 0L) {
            StringBuilder paths = new StringBuilder();
            ArrayList<StatementMatcher.Variable> valueVariables = new ArrayList<StatementMatcher.Variable>();
            int i = 0;
            while ((long)i < this.maxCount + 1L) {
                StatementMatcher.Variable value = stableRandomVariableProvider.next();
                valueVariables.add(value);
                String pathQuery = this.getTargetChain().getPath().map(p -> p.getTargetQueryFragment(effectiveTarget.getTargetVar(), value, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider)).orElseThrow(IllegalStateException::new);
                paths.append(pathQuery).append("\n");
                ++i;
            }
            HashSet<CallSite> notEquals = new HashSet<CallSite>();
            for (int i2 = 0; i2 < valueVariables.size(); ++i2) {
                for (int j = 0; j < valueVariables.size(); ++j) {
                    if (i2 == j) continue;
                    if (i2 > j) {
                        notEquals.add((CallSite)((Object)(((StatementMatcher.Variable)valueVariables.get(i2)).asSparqlVariable() + " != " + ((StatementMatcher.Variable)valueVariables.get(j)).asSparqlVariable())));
                        continue;
                    }
                    notEquals.add((CallSite)((Object)(((StatementMatcher.Variable)valueVariables.get(j)).asSparqlVariable() + " != " + ((StatementMatcher.Variable)valueVariables.get(i2)).asSparqlVariable())));
                }
            }
            String innerCondition = String.join((CharSequence)" && ", notEquals);
            query = (String)query + paths + "FILTER(" + innerCondition + ")\n";
        }
        List<StatementMatcher.Variable> allTargetVariables = effectiveTarget.getAllTargetVariables();
        return new ValidationQuery((String)query, allTargetVariables, null, scope, this.getConstraintComponent(), null, null);
    }

    @Override
    public ValidationApproach getOptimalBulkValidationApproach() {
        if (this.maxCount > 5L) {
            return ValidationApproach.Transactional;
        }
        return ValidationApproach.SPARQL;
    }
}

