/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.TransactionSetting;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.UnknownTransactionStateException;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;

public interface RepositoryConnection
extends AutoCloseable {
    public Repository getRepository();

    public void setParserConfig(ParserConfig var1);

    public ParserConfig getParserConfig();

    public ValueFactory getValueFactory();

    public boolean isOpen() throws RepositoryException;

    @Override
    default public void close() throws RepositoryException {
        if (this.isOpen() && this.isActive()) {
            this.rollback();
        }
    }

    default public Query prepareQuery(String query) throws RepositoryException, MalformedQueryException {
        return this.prepareQuery(QueryLanguage.SPARQL, query);
    }

    public Query prepareQuery(QueryLanguage var1, String var2) throws RepositoryException, MalformedQueryException;

    public Query prepareQuery(QueryLanguage var1, String var2, String var3) throws RepositoryException, MalformedQueryException;

    default public TupleQuery prepareTupleQuery(String query) throws RepositoryException, MalformedQueryException {
        return this.prepareTupleQuery(QueryLanguage.SPARQL, query);
    }

    public TupleQuery prepareTupleQuery(QueryLanguage var1, String var2) throws RepositoryException, MalformedQueryException;

    public TupleQuery prepareTupleQuery(QueryLanguage var1, String var2, String var3) throws RepositoryException, MalformedQueryException;

    default public GraphQuery prepareGraphQuery(String query) throws RepositoryException, MalformedQueryException {
        return this.prepareGraphQuery(QueryLanguage.SPARQL, query);
    }

    public GraphQuery prepareGraphQuery(QueryLanguage var1, String var2) throws RepositoryException, MalformedQueryException;

    public GraphQuery prepareGraphQuery(QueryLanguage var1, String var2, String var3) throws RepositoryException, MalformedQueryException;

    default public BooleanQuery prepareBooleanQuery(String query) throws RepositoryException, MalformedQueryException {
        return this.prepareBooleanQuery(QueryLanguage.SPARQL, query);
    }

    public BooleanQuery prepareBooleanQuery(QueryLanguage var1, String var2) throws RepositoryException, MalformedQueryException;

    public BooleanQuery prepareBooleanQuery(QueryLanguage var1, String var2, String var3) throws RepositoryException, MalformedQueryException;

    default public Update prepareUpdate(String update) throws RepositoryException, MalformedQueryException {
        return this.prepareUpdate(QueryLanguage.SPARQL, update);
    }

    public Update prepareUpdate(QueryLanguage var1, String var2) throws RepositoryException, MalformedQueryException;

    public Update prepareUpdate(QueryLanguage var1, String var2, String var3) throws RepositoryException, MalformedQueryException;

    public RepositoryResult<Resource> getContextIDs() throws RepositoryException;

    default public RepositoryResult<Statement> getStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws RepositoryException {
        return this.getStatements(subj, pred, obj, true, contexts);
    }

    public RepositoryResult<Statement> getStatements(Resource var1, IRI var2, Value var3, boolean var4, Resource ... var5) throws RepositoryException;

    public boolean hasStatement(Resource var1, IRI var2, Value var3, boolean var4, Resource ... var5) throws RepositoryException;

    public boolean hasStatement(Statement var1, boolean var2, Resource ... var3) throws RepositoryException;

    public void exportStatements(Resource var1, IRI var2, Value var3, boolean var4, RDFHandler var5, Resource ... var6) throws RepositoryException, RDFHandlerException;

    public void export(RDFHandler var1, Resource ... var2) throws RepositoryException, RDFHandlerException;

    public long size(Resource ... var1) throws RepositoryException;

    public boolean isEmpty() throws RepositoryException;

    @Deprecated
    public void setAutoCommit(boolean var1) throws RepositoryException;

    @Deprecated
    public boolean isAutoCommit() throws RepositoryException;

    public boolean isActive() throws UnknownTransactionStateException, RepositoryException;

    public void setIsolationLevel(IsolationLevel var1) throws IllegalStateException;

    public IsolationLevel getIsolationLevel();

    public void begin() throws RepositoryException;

    public void begin(IsolationLevel var1) throws RepositoryException;

    default public void begin(TransactionSetting ... settings) {
        for (TransactionSetting setting : settings) {
            if (!(setting instanceof IsolationLevel)) continue;
            this.begin((IsolationLevel)setting);
            return;
        }
        this.begin();
    }

    default public void prepare() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void commit() throws RepositoryException;

    public void rollback() throws RepositoryException;

    default public void add(InputStream in, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        this.add(in, null, dataFormat, contexts);
    }

    public void add(InputStream var1, String var2, RDFFormat var3, Resource ... var4) throws IOException, RDFParseException, RepositoryException;

    default public void add(Reader reader, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        this.add(reader, null, dataFormat, contexts);
    }

    public void add(Reader var1, String var2, RDFFormat var3, Resource ... var4) throws IOException, RDFParseException, RepositoryException;

    default public void add(URL url, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        this.add(url, (String)null, (RDFFormat)null, contexts);
    }

    default public void add(URL url, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        this.add(url, null, dataFormat, contexts);
    }

    public void add(URL var1, String var2, RDFFormat var3, Resource ... var4) throws IOException, RDFParseException, RepositoryException;

    default public void add(File file, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        this.add(file, (String)null, (RDFFormat)null, contexts);
    }

    default public void add(File file, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        this.add(file, null, dataFormat, contexts);
    }

    public void add(File var1, String var2, RDFFormat var3, Resource ... var4) throws IOException, RDFParseException, RepositoryException;

    public void add(Resource var1, IRI var2, Value var3, Resource ... var4) throws RepositoryException;

    public void add(Statement var1, Resource ... var2) throws RepositoryException;

    public void add(Iterable<? extends Statement> var1, Resource ... var2) throws RepositoryException;

    public <E extends Exception> void add(Iteration<? extends Statement, E> var1, Resource ... var2) throws RepositoryException, E;

    default public void add(RepositoryResult<Statement> statements, Resource ... contexts) throws RepositoryException {
        this.add((Iteration)statements, contexts);
    }

    public void remove(Resource var1, IRI var2, Value var3, Resource ... var4) throws RepositoryException;

    public void remove(Statement var1, Resource ... var2) throws RepositoryException;

    public void remove(Iterable<? extends Statement> var1, Resource ... var2) throws RepositoryException;

    public <E extends Exception> void remove(Iteration<? extends Statement, E> var1, Resource ... var2) throws RepositoryException, E;

    default public void remove(RepositoryResult<Statement> statements, Resource ... contexts) throws RepositoryException {
        this.remove((Iteration)statements, contexts);
    }

    public void clear(Resource ... var1) throws RepositoryException;

    public RepositoryResult<Namespace> getNamespaces() throws RepositoryException;

    public String getNamespace(String var1) throws RepositoryException;

    public void setNamespace(String var1, String var2) throws RepositoryException;

    public void removeNamespace(String var1) throws RepositoryException;

    public void clearNamespaces() throws RepositoryException;
}

