/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryValueEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryEvaluationContext;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtility;

public class LeftJoinIterator
extends LookAheadIteration<BindingSet, QueryEvaluationException> {
    private final Set<String> scopeBindingNames;
    private final CloseableIteration<BindingSet, QueryEvaluationException> leftIter;
    private CloseableIteration<BindingSet, QueryEvaluationException> rightIter;
    private final QueryEvaluationStep prepareRightArg;
    private final QueryValueEvaluationStep joinCondition;

    public LeftJoinIterator(EvaluationStrategy strategy, LeftJoin join, BindingSet bindings, QueryEvaluationContext context) throws QueryEvaluationException {
        this.scopeBindingNames = join.getBindingNames();
        this.leftIter = strategy.evaluate(join.getLeftArg(), bindings);
        this.rightIter = new EmptyIteration();
        this.prepareRightArg = strategy.precompile(join.getRightArg(), context);
        join.setAlgorithm((CloseableIteration)this);
        ValueExpr condition = join.getCondition();
        this.joinCondition = condition == null ? null : strategy.precompile(condition, context);
    }

    public LeftJoinIterator(QueryEvaluationStep left, QueryEvaluationStep right, QueryValueEvaluationStep joinCondition, BindingSet bindings, Set<String> scopeBindingNamse) throws QueryEvaluationException {
        this.scopeBindingNames = scopeBindingNamse;
        this.leftIter = left.evaluate(bindings);
        this.rightIter = new EmptyIteration();
        this.prepareRightArg = right;
        this.joinCondition = joinCondition;
    }

    protected BindingSet getNextElement() throws QueryEvaluationException {
        try {
            CloseableIteration<BindingSet, QueryEvaluationException> nextRightIter = this.rightIter;
            while (nextRightIter.hasNext() || this.leftIter.hasNext()) {
                BindingSet leftBindings = null;
                if (!nextRightIter.hasNext()) {
                    leftBindings = (BindingSet)this.leftIter.next();
                    nextRightIter.close();
                    nextRightIter = this.rightIter = this.prepareRightArg.evaluate(leftBindings);
                }
                while (nextRightIter.hasNext()) {
                    BindingSet rightBindings = (BindingSet)nextRightIter.next();
                    try {
                        if (this.joinCondition == null) {
                            return rightBindings;
                        }
                        QueryBindingSet scopeBindings = new QueryBindingSet(rightBindings);
                        scopeBindings.retainAll(this.scopeBindingNames);
                        if (!this.isTrue(this.joinCondition, scopeBindings)) continue;
                        return rightBindings;
                    }
                    catch (ValueExprEvaluationException valueExprEvaluationException) {
                    }
                }
                if (leftBindings == null) continue;
                return leftBindings;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return null;
    }

    private boolean isTrue(QueryValueEvaluationStep expr, QueryBindingSet bindings) {
        Value value = expr.evaluate((BindingSet)bindings);
        return QueryEvaluationUtility.getEffectiveBooleanValue(value).orElse(false);
    }

    protected void handleClose() throws QueryEvaluationException {
        try {
            super.handleClose();
        }
        finally {
            try {
                this.leftIter.close();
            }
            finally {
                this.rightIter.close();
            }
        }
    }
}

