/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rdf4j.http.server.repository.QueryResultView;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.resultio.BasicQueryWriterSettings;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriter;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriterFactory;
import org.eclipse.rdf4j.rio.RioSetting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TupleQueryResultView
extends QueryResultView {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String DEFAULT_JSONP_CALLBACK_PARAMETER = "callback";
    protected static final Pattern JSONP_VALIDATOR = Pattern.compile("^[A-Za-z]\\w+$");
    private static final TupleQueryResultView INSTANCE = new TupleQueryResultView();

    public static TupleQueryResultView getInstance() {
        return INSTANCE;
    }

    private TupleQueryResultView() {
    }

    public String getContentType() {
        return null;
    }

    @Override
    protected void renderInternal(Map model, HttpServletRequest request, HttpServletResponse response) throws IOException {
        TupleQueryResultWriterFactory qrWriterFactory = (TupleQueryResultWriterFactory)model.get("factory");
        TupleQueryResultFormat qrFormat = qrWriterFactory.getTupleQueryResultFormat();
        response.setStatus(200);
        this.setContentType(response, qrFormat);
        this.setContentDisposition(model, response, qrFormat);
        Boolean headersOnly = (Boolean)model.get("headersOnly");
        if (headersOnly == null || !headersOnly.booleanValue()) {
            try (ServletOutputStream out = response.getOutputStream();){
                String parameter;
                TupleQueryResultWriter qrWriter = qrWriterFactory.getWriter((OutputStream)out);
                TupleQueryResult tupleQueryResult = (TupleQueryResult)model.get("queryResult");
                if (qrWriter.getSupportedSettings().contains(BasicQueryWriterSettings.JSONP_CALLBACK) && (parameter = request.getParameter(DEFAULT_JSONP_CALLBACK_PARAMETER)) != null) {
                    if ((parameter = parameter.trim()).isEmpty()) {
                        parameter = BasicQueryWriterSettings.JSONP_CALLBACK.getDefaultValue();
                    }
                    if (!JSONP_VALIDATOR.matcher(parameter).matches()) {
                        throw new IOException("Callback function name was invalid");
                    }
                    qrWriter.getWriterConfig().set((RioSetting)BasicQueryWriterSettings.JSONP_CALLBACK, parameter);
                }
                QueryResults.report(tupleQueryResult, qrWriter);
            }
            catch (QueryInterruptedException e) {
                this.logger.error("Query interrupted", (Throwable)e);
                response.sendError(503, "Query evaluation took too long");
            }
            catch (QueryEvaluationException e) {
                this.logger.error("Query evaluation error", (Throwable)e);
                response.sendError(500, "Query evaluation error: " + e.getMessage());
            }
            catch (TupleQueryResultHandlerException e) {
                this.logger.error("Serialization error", (Throwable)e);
                response.sendError(500, "Serialization error: " + e.getMessage());
            }
        }
        this.logEndOfRequest(request);
    }
}

