/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclUnsupportedException;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedSplitter
implements PlanNodeProvider {
    private static final AtomicLong idCounter = new AtomicLong();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final PlanNode parent;
    private final boolean cached;
    private volatile List<ValidationTuple> tuplesBuffer;
    private long id = -1L;

    public BufferedSplitter(PlanNode parent, boolean cached) {
        this.parent = parent;
        this.cached = cached;
    }

    public BufferedSplitter(PlanNode parent, boolean cached, boolean createId) {
        this.parent = parent;
        this.cached = cached;
        this.id = idCounter.incrementAndGet();
    }

    public BufferedSplitter(PlanNode parent) {
        this(parent, true);
    }

    private synchronized void init() {
        if (this.tuplesBuffer == null) {
            this.tuplesBuffer = new ArrayList<ValidationTuple>();
            try (CloseableIteration<? extends ValidationTuple, SailException> iterator = this.parent.iterator();){
                while (iterator.hasNext()) {
                    ValidationTuple next = (ValidationTuple)iterator.next();
                    this.tuplesBuffer.add(next);
                }
            }
        }
    }

    public String getId() {
        int length = ("" + idCounter.get()).length();
        return String.format("%0" + length + "d", this.id);
    }

    @Override
    public PlanNode getPlanNode() {
        return new BufferedSplitterPlaneNode(this, this.cached);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BufferedSplitter that = (BufferedSplitter)o;
        return this.parent.equals(that.parent);
    }

    public int hashCode() {
        return Objects.hash(this.parent);
    }

    public static class BufferedSplitterPlaneNode
    implements PlanNode {
        private final BufferedSplitter bufferedSplitter;
        public final boolean cached;
        private boolean printed = false;
        private ValidationExecutionLogger validationExecutionLogger;

        public BufferedSplitterPlaneNode(BufferedSplitter bufferedSplitter, boolean cached) {
            this.bufferedSplitter = bufferedSplitter;
            this.cached = cached;
        }

        @Override
        public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
            return new CloseableIteration<ValidationTuple, SailException>(){
                Iterator<ValidationTuple> iterator;

                private void init() {
                    if (this.iterator == null) {
                        bufferedSplitter.init();
                        this.iterator = bufferedSplitter.tuplesBuffer.iterator();
                    }
                }

                @Override
                public void close() throws SailException {
                }

                @Override
                public boolean hasNext() throws SailException {
                    this.init();
                    return this.iterator.hasNext();
                }

                @Override
                public ValidationTuple next() throws SailException {
                    this.init();
                    ValidationTuple tuple = this.iterator.next();
                    if (validationExecutionLogger.isEnabled()) {
                        validationExecutionLogger.log(this.depth(), bufferedSplitter.parent.getClass().getSimpleName() + ":BufferedSplitter.next()", tuple, bufferedSplitter.parent, this.getId(), null);
                    }
                    return tuple;
                }

                @Override
                public void remove() throws SailException {
                    throw new ShaclUnsupportedException();
                }
            };
        }

        @Override
        public int depth() {
            return this.bufferedSplitter.parent.depth() + 1;
        }

        @Override
        public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
            if (this.printed) {
                return;
            }
            this.printed = true;
            stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
            stringBuilder.append(this.bufferedSplitter.parent.getId() + " -> " + this.getId()).append("\n");
            this.bufferedSplitter.parent.getPlanAsGraphvizDot(stringBuilder);
        }

        @Override
        public String getId() {
            return "" + System.identityHashCode(this.bufferedSplitter);
        }

        public String toString() {
            return "BufferedSplitter";
        }

        @Override
        public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
            this.validationExecutionLogger = validationExecutionLogger;
            this.bufferedSplitter.parent.receiveLogger(validationExecutionLogger);
        }

        @Override
        public boolean producesSorted() {
            return this.bufferedSplitter.parent.producesSorted();
        }

        @Override
        public boolean requiresSorted() {
            return this.bufferedSplitter.parent.requiresSorted();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BufferedSplitterPlaneNode that = (BufferedSplitterPlaneNode)o;
            return this.bufferedSplitter.equals(that.bufferedSplitter);
        }

        public int hashCode() {
            return Objects.hash(this.bufferedSplitter);
        }
    }
}

