/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory;

import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.SailReadOnlyException;
import org.eclipse.rdf4j.sail.base.SailSourceConnection;
import org.eclipse.rdf4j.sail.features.ThreadSafetyAware;
import org.eclipse.rdf4j.sail.helpers.AbstractSail;
import org.eclipse.rdf4j.sail.helpers.DefaultSailChangedEvent;
import org.eclipse.rdf4j.sail.memory.MemoryStore;

public class MemoryStoreConnection
extends SailSourceConnection
implements ThreadSafetyAware {
    protected final MemoryStore sail;
    private volatile DefaultSailChangedEvent sailChangedEvent;

    protected MemoryStoreConnection(MemoryStore sail) {
        super((AbstractSail)sail, sail.getSailStore(), sail.getEvaluationStrategyFactory());
        this.sail = sail;
        this.sailChangedEvent = new DefaultSailChangedEvent(sail);
        this.useConnectionLock = false;
    }

    @Override
    protected void startTransactionInternal() throws SailException {
        if (!this.sail.isWritable()) {
            throw new SailReadOnlyException("Unable to start transaction: data file is locked or read-only");
        }
        super.startTransactionInternal();
        this.sail.cancelSyncTask();
    }

    @Override
    protected void commitInternal() throws SailException {
        super.commitInternal();
        this.sail.notifySailChanged(this.sailChangedEvent);
        this.sail.scheduleSyncTask();
        this.sailChangedEvent = new DefaultSailChangedEvent(this.sail);
    }

    @Override
    protected void rollbackInternal() throws SailException {
        super.rollbackInternal();
        this.sailChangedEvent = new DefaultSailChangedEvent(this.sail);
    }

    @Override
    protected void addStatementInternal(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        this.sailChangedEvent.setStatementsAdded(true);
    }

    @Override
    public boolean addInferredStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        boolean ret = super.addInferredStatement(subj, pred, obj, contexts);
        this.sailChangedEvent.setStatementsAdded(true);
        return ret;
    }

    @Override
    protected void removeStatementsInternal(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        this.sailChangedEvent.setStatementsRemoved(true);
    }

    @Override
    public boolean removeInferredStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        boolean ret = super.removeInferredStatement(subj, pred, obj, contexts);
        this.sailChangedEvent.setStatementsRemoved(true);
        return ret;
    }

    @Override
    protected void clearInternal(Resource ... contexts) throws SailException {
        super.clearInternal(contexts);
        this.sailChangedEvent.setStatementsRemoved(true);
    }

    @Override
    public void clearInferred(Resource ... contexts) throws SailException {
        super.clearInferred(contexts);
        this.sailChangedEvent.setStatementsRemoved(true);
    }

    public MemoryStore getSail() {
        return this.sail;
    }

    @Override
    public boolean supportsConcurrentReads() {
        return this.getTransactionIsolation() != null && this.getTransactionIsolation() != IsolationLevels.SERIALIZABLE;
    }
}

