/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

public class FilterByPredicateObject
implements PlanNode {
    private final SailConnection connection;
    private final boolean includeInferred;
    private final Set<Resource> filterOnObject;
    private final IRI filterOnPredicate;
    private final FilterOn filterOn;
    private final PlanNode parent;
    private final boolean returnMatching;
    private StackTraceElement[] stackTrace;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;
    private final Resource[] dataGraph;

    public FilterByPredicateObject(SailConnection connection, Resource[] dataGraph, IRI filterOnPredicate, Set<Resource> filterOnObject, PlanNode parent, boolean returnMatching, FilterOn filterOn, boolean includeInferred) {
        this.dataGraph = dataGraph;
        this.parent = PlanNodeHelper.handleSorting(this, parent);
        this.connection = connection;
        assert (this.connection != null);
        this.includeInferred = includeInferred;
        this.filterOnPredicate = filterOnPredicate;
        this.filterOnObject = filterOnObject;
        this.filterOn = filterOn;
        this.returnMatching = returnMatching;
    }

    @Override
    public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            ValidationTuple next;
            final CloseableIteration<? extends ValidationTuple, SailException> parentIterator;
            Resource[] filterOnObject;
            IRI filterOnPredicate;
            {
                this.next = null;
                this.parentIterator = FilterByPredicateObject.this.parent.iterator();
                this.filterOnObject = null;
                this.filterOnPredicate = null;
            }

            void calculateNext() {
                if (!this.parentIterator.hasNext()) {
                    return;
                }
                this.internResources();
                if (FilterByPredicateObject.this.returnMatching && (this.filterOnPredicate == null || this.filterOnObject.length == 0)) {
                    return;
                }
                while (this.next == null && this.parentIterator.hasNext()) {
                    Value value;
                    ValidationTuple temp = (ValidationTuple)this.parentIterator.next();
                    switch (FilterByPredicateObject.this.filterOn) {
                        case value: {
                            value = temp.getValue();
                            break;
                        }
                        case activeTarget: {
                            value = temp.getActiveTarget();
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown filterOn: " + FilterByPredicateObject.this.filterOn);
                        }
                    }
                    boolean matches = FilterByPredicateObject.this.matches(value, this.filterOnPredicate, this.filterOnObject);
                    if (FilterByPredicateObject.this.returnMatching) {
                        if (matches) {
                            this.next = temp;
                            continue;
                        }
                        if (!FilterByPredicateObject.this.validationExecutionLogger.isEnabled()) continue;
                        FilterByPredicateObject.this.validationExecutionLogger.log(FilterByPredicateObject.this.depth(), FilterByPredicateObject.this.getClass().getSimpleName() + ":IgnoredAsNotMatching", temp, FilterByPredicateObject.this, FilterByPredicateObject.this.getId(), null);
                        continue;
                    }
                    if (!matches) {
                        this.next = temp;
                        continue;
                    }
                    if (!FilterByPredicateObject.this.validationExecutionLogger.isEnabled()) continue;
                    FilterByPredicateObject.this.validationExecutionLogger.log(FilterByPredicateObject.this.depth(), FilterByPredicateObject.this.getClass().getSimpleName() + ":IgnoredAsMatching", temp, FilterByPredicateObject.this, FilterByPredicateObject.this.getId(), null);
                }
                assert (this.next != null || !this.parentIterator.hasNext()) : this.parentIterator.toString();
            }

            private void internResources() {
                if (this.filterOnObject == null) {
                    try (Stream<? extends Statement> stream = FilterByPredicateObject.this.connection.getStatements(null, FilterByPredicateObject.this.filterOnPredicate, null, FilterByPredicateObject.this.includeInferred, FilterByPredicateObject.this.dataGraph).stream();){
                        this.filterOnPredicate = stream.map(Statement::getPredicate).findAny().orElse(null);
                    }
                    this.filterOnObject = this.filterOnPredicate == null ? new Resource[0] : (Resource[])FilterByPredicateObject.this.filterOnObject.stream().map(object -> {
                        try (Stream<? extends Statement> stream = FilterByPredicateObject.this.connection.getStatements(null, this.filterOnPredicate, (Value)object, FilterByPredicateObject.this.includeInferred, FilterByPredicateObject.this.dataGraph).stream();){
                            Resource resource = stream.map(Statement::getObject).map(o -> (Resource)o).findAny().orElse(null);
                            return resource;
                        }
                    }).filter(Objects::nonNull).toArray(Resource[]::new);
                }
            }

            @Override
            public void localClose() throws SailException {
                this.parentIterator.close();
            }

            @Override
            protected boolean localHasNext() throws SailException {
                this.calculateNext();
                return this.next != null;
            }

            @Override
            protected ValidationTuple loggingNext() throws SailException {
                this.calculateNext();
                ValidationTuple temp = this.next;
                this.next = null;
                return temp;
            }
        };
    }

    private boolean matches(Value subject, IRI filterOnPredicate, Resource[] filterOnObject) {
        if (filterOnPredicate == null || filterOnObject.length == 0) {
            return false;
        }
        if (subject.isResource()) {
            for (Resource object : filterOnObject) {
                if (!this.connection.hasStatement((Resource)subject, filterOnPredicate, object, this.includeInferred, this.dataGraph)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.parent.getId() + " -> " + this.getId()).append("\n");
        if (this.connection instanceof MemoryStoreConnection) {
            stringBuilder.append(System.identityHashCode(((MemoryStoreConnection)this.connection).getSail()) + " -> " + this.getId() + " [label=\"filter source\"]").append("\n");
        } else {
            stringBuilder.append(System.identityHashCode(this.connection) + " -> " + this.getId() + " [label=\"filter source\"]").append("\n");
        }
        this.parent.getPlanAsGraphvizDot(stringBuilder);
    }

    @Override
    public String getId() {
        return "" + System.identityHashCode(this);
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.parent.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean producesSorted() {
        return this.parent.producesSorted();
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterByPredicateObject that = (FilterByPredicateObject)o;
        if (this.connection instanceof MemoryStoreConnection && that.connection instanceof MemoryStoreConnection) {
            return this.returnMatching == that.returnMatching && ((MemoryStoreConnection)this.connection).getSail().equals(((MemoryStoreConnection)that.connection).getSail()) && this.filterOnObject.equals(that.filterOnObject) && this.filterOnPredicate.equals(that.filterOnPredicate) && this.filterOn == that.filterOn && Arrays.equals(this.dataGraph, that.dataGraph) && this.parent.equals(that.parent);
        }
        return this.returnMatching == that.returnMatching && Objects.equals(this.connection, that.connection) && this.filterOnObject.equals(that.filterOnObject) && this.filterOnPredicate.equals(that.filterOnPredicate) && this.filterOn == that.filterOn && Arrays.equals(this.dataGraph, that.dataGraph) && this.parent.equals(that.parent);
    }

    public int hashCode() {
        if (this.connection instanceof MemoryStoreConnection) {
            return Objects.hash(new Object[]{((MemoryStoreConnection)this.connection).getSail(), this.filterOnObject, this.filterOnPredicate, this.filterOn, this.parent, this.returnMatching, Arrays.hashCode(this.dataGraph)});
        }
        return Objects.hash(new Object[]{this.connection, this.filterOnObject, this.filterOnPredicate, this.filterOn, this.parent, this.returnMatching, Arrays.hashCode(this.dataGraph)});
    }

    public String toString() {
        return "ExternalPredicateObjectFilter{filterOnObject=" + this.filterOnObject + ", filterOnPredicate=" + this.filterOnPredicate + ", filterOn=" + this.filterOn + ", parent=" + this.parent + ", returnMatching=" + this.returnMatching + "}";
    }

    public static enum FilterOn {
        activeTarget,
        value;

    }
}

