/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.Objects;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.Tessellator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;

public final class ShapeField {
    static final int BYTES = 4;
    protected static final FieldType TYPE = new FieldType();
    private static final int MINY_MINX_MAXY_MAXX_Y_X = 0;
    private static final int MINY_MINX_Y_X_MAXY_MAXX = 1;
    private static final int MAXY_MINX_Y_X_MINY_MAXX = 2;
    private static final int MAXY_MINX_MINY_MAXX_Y_X = 3;
    private static final int Y_MINX_MINY_X_MAXY_MAXX = 4;
    private static final int Y_MINX_MINY_MAXX_MAXY_X = 5;
    private static final int MAXY_MINX_MINY_X_Y_MAXX = 6;
    private static final int MINY_MINX_Y_MAXX_MAXY_X = 7;

    private ShapeField() {
    }

    public static void encodeTriangle(byte[] bytes, int aLat, int aLon, boolean abFromShape, int bLat, int bLon, boolean bcFromShape, int cLat, int cLon, boolean caFromShape) {
        int bits;
        int x;
        int y;
        boolean tempBool;
        int tempY;
        int tempX;
        boolean ca;
        boolean bc;
        boolean ab;
        int cY;
        int bY;
        int aY;
        int cX;
        int bX;
        int aX;
        assert (bytes.length == 28);
        if (GeoUtils.orient(aLon, aLat, bLon, bLat, cLon, cLat) == -1) {
            aX = cLon;
            bX = bLon;
            cX = aLon;
            aY = cLat;
            bY = bLat;
            cY = aLat;
            ab = bcFromShape;
            bc = abFromShape;
            ca = caFromShape;
        } else {
            aX = aLon;
            bX = bLon;
            cX = cLon;
            aY = aLat;
            bY = bLat;
            cY = cLat;
            ab = abFromShape;
            bc = bcFromShape;
            ca = caFromShape;
        }
        if (bX < aX || cX < aX) {
            if (bX < cX) {
                tempX = aX;
                tempY = aY;
                tempBool = ab;
                aX = bX;
                aY = bY;
                ab = bc;
                bX = cX;
                bY = cY;
                bc = ca;
                cX = tempX;
                cY = tempY;
                ca = tempBool;
            } else if (cX < aX) {
                tempX = aX;
                tempY = aY;
                tempBool = ab;
                aX = cX;
                aY = cY;
                ab = ca;
                cX = bX;
                cY = bY;
                ca = bc;
                bX = tempX;
                bY = tempY;
                bc = tempBool;
            }
        } else if (aX == bX && aX == cX && (bY < aY || cY < aY)) {
            if (bY < cY) {
                tempX = aX;
                tempY = aY;
                tempBool = ab;
                aX = bX;
                aY = bY;
                ab = bc;
                bX = cX;
                bY = cY;
                bc = ca;
                cX = tempX;
                cY = tempY;
                ca = tempBool;
            } else if (cY < aY) {
                tempX = aX;
                tempY = aY;
                tempBool = ab;
                aX = cX;
                aY = cY;
                ab = ca;
                cX = bX;
                cY = bY;
                ca = bc;
                bX = tempX;
                bY = tempY;
                bc = tempBool;
            }
        }
        int minX = aX;
        int minY = StrictMath.min(aY, StrictMath.min(bY, cY));
        int maxX = StrictMath.max(aX, StrictMath.max(bX, cX));
        int maxY = StrictMath.max(aY, StrictMath.max(bY, cY));
        if (minY == aY) {
            if (maxY == bY && maxX == bX) {
                y = cY;
                x = cX;
                bits = 0;
            } else if (maxY == cY && maxX == cX) {
                y = bY;
                x = bX;
                bits = 1;
            } else {
                y = bY;
                x = cX;
                bits = 7;
            }
        } else if (maxY == aY) {
            if (minY == bY && maxX == bX) {
                y = cY;
                x = cX;
                bits = 3;
            } else if (minY == cY && maxX == cX) {
                y = bY;
                x = bX;
                bits = 2;
            } else {
                y = cY;
                x = bX;
                bits = 6;
            }
        } else if (maxX == bX && minY == bY) {
            y = aY;
            x = cX;
            bits = 5;
        } else if (maxX == cX && maxY == cY) {
            y = aY;
            x = bX;
            bits = 4;
        } else {
            throw new IllegalArgumentException("Could not encode the provided triangle");
        }
        bits |= ab ? 8 : 0;
        bits |= bc ? 16 : 0;
        bits |= ca ? 32 : 0;
        NumericUtils.intToSortableBytes(minY, bytes, 0);
        NumericUtils.intToSortableBytes(minX, bytes, 4);
        NumericUtils.intToSortableBytes(maxY, bytes, 8);
        NumericUtils.intToSortableBytes(maxX, bytes, 12);
        NumericUtils.intToSortableBytes(y, bytes, 16);
        NumericUtils.intToSortableBytes(x, bytes, 20);
        NumericUtils.intToSortableBytes(bits, bytes, 24);
    }

    public static void decodeTriangle(byte[] t, DecodedTriangle triangle) {
        int cX;
        int cY;
        int bX;
        int bY;
        int aX;
        int aY;
        int bits = NumericUtils.sortableBytesToInt(t, 24);
        int tCode = 7 & bits >> 0;
        switch (tCode) {
            case 0: {
                aY = NumericUtils.sortableBytesToInt(t, 0);
                aX = NumericUtils.sortableBytesToInt(t, 4);
                bY = NumericUtils.sortableBytesToInt(t, 8);
                bX = NumericUtils.sortableBytesToInt(t, 12);
                cY = NumericUtils.sortableBytesToInt(t, 16);
                cX = NumericUtils.sortableBytesToInt(t, 20);
                break;
            }
            case 1: {
                aY = NumericUtils.sortableBytesToInt(t, 0);
                aX = NumericUtils.sortableBytesToInt(t, 4);
                bY = NumericUtils.sortableBytesToInt(t, 16);
                bX = NumericUtils.sortableBytesToInt(t, 20);
                cY = NumericUtils.sortableBytesToInt(t, 8);
                cX = NumericUtils.sortableBytesToInt(t, 12);
                break;
            }
            case 2: {
                aY = NumericUtils.sortableBytesToInt(t, 8);
                aX = NumericUtils.sortableBytesToInt(t, 4);
                bY = NumericUtils.sortableBytesToInt(t, 16);
                bX = NumericUtils.sortableBytesToInt(t, 20);
                cY = NumericUtils.sortableBytesToInt(t, 0);
                cX = NumericUtils.sortableBytesToInt(t, 12);
                break;
            }
            case 3: {
                aY = NumericUtils.sortableBytesToInt(t, 8);
                aX = NumericUtils.sortableBytesToInt(t, 4);
                bY = NumericUtils.sortableBytesToInt(t, 0);
                bX = NumericUtils.sortableBytesToInt(t, 12);
                cY = NumericUtils.sortableBytesToInt(t, 16);
                cX = NumericUtils.sortableBytesToInt(t, 20);
                break;
            }
            case 4: {
                aY = NumericUtils.sortableBytesToInt(t, 16);
                aX = NumericUtils.sortableBytesToInt(t, 4);
                bY = NumericUtils.sortableBytesToInt(t, 0);
                bX = NumericUtils.sortableBytesToInt(t, 20);
                cY = NumericUtils.sortableBytesToInt(t, 8);
                cX = NumericUtils.sortableBytesToInt(t, 12);
                break;
            }
            case 5: {
                aY = NumericUtils.sortableBytesToInt(t, 16);
                aX = NumericUtils.sortableBytesToInt(t, 4);
                bY = NumericUtils.sortableBytesToInt(t, 0);
                bX = NumericUtils.sortableBytesToInt(t, 12);
                cY = NumericUtils.sortableBytesToInt(t, 8);
                cX = NumericUtils.sortableBytesToInt(t, 20);
                break;
            }
            case 6: {
                aY = NumericUtils.sortableBytesToInt(t, 8);
                aX = NumericUtils.sortableBytesToInt(t, 4);
                bY = NumericUtils.sortableBytesToInt(t, 0);
                bX = NumericUtils.sortableBytesToInt(t, 20);
                cY = NumericUtils.sortableBytesToInt(t, 16);
                cX = NumericUtils.sortableBytesToInt(t, 12);
                break;
            }
            case 7: {
                aY = NumericUtils.sortableBytesToInt(t, 0);
                aX = NumericUtils.sortableBytesToInt(t, 4);
                bY = NumericUtils.sortableBytesToInt(t, 16);
                bX = NumericUtils.sortableBytesToInt(t, 12);
                cY = NumericUtils.sortableBytesToInt(t, 8);
                cX = NumericUtils.sortableBytesToInt(t, 20);
                break;
            }
            default: {
                throw new IllegalArgumentException("Could not decode the provided triangle");
            }
        }
        assert (GeoUtils.orient(aX, aY, bX, bY, cX, cY) >= 0);
        boolean ab = (bits & 8) == 8;
        boolean bc = (bits & 0x10) == 16;
        boolean ca = (bits & 0x20) == 32;
        triangle.setValues(aX, aY, ab, bX, bY, bc, cX, cY, ca);
    }

    static {
        TYPE.setDimensions(7, 4, 4);
        TYPE.freeze();
    }

    public static class DecodedTriangle {
        public int aX;
        public int aY;
        public int bX;
        public int bY;
        public int cX;
        public int cY;
        public boolean ab;
        public boolean bc;
        public boolean ca;

        private void setValues(int aX, int aY, boolean ab, int bX, int bY, boolean bc, int cX, int cY, boolean ca) {
            this.aX = aX;
            this.aY = aY;
            this.ab = ab;
            this.bX = bX;
            this.bY = bY;
            this.bc = bc;
            this.cX = cX;
            this.cY = cY;
            this.ca = ca;
        }

        public int hashCode() {
            return Objects.hash(this.aX, this.aY, this.bX, this.bY, this.cX, this.cY, this.ab, this.bc, this.ca);
        }

        public boolean equals(Object o) {
            DecodedTriangle other = (DecodedTriangle)o;
            return this.aX == other.aX && this.bX == other.bX && this.cX == other.cX && this.aY == other.aY && this.bY == other.bY && this.cY == other.cY && this.ab == other.ab && this.bc == other.bc && this.ca == other.ca;
        }

        public String toString() {
            String result = this.aX + ", " + this.aY + " " + this.bX + ", " + this.bY + " " + this.cX + ", " + this.cY + " [" + this.ab + "," + this.bc + "," + this.ca + "]";
            return result;
        }
    }

    public static enum QueryRelation {
        INTERSECTS,
        WITHIN,
        DISJOINT,
        CONTAINS;

    }

    public static class Triangle
    extends Field {
        Triangle(String name, int aXencoded, int aYencoded, int bXencoded, int bYencoded, int cXencoded, int cYencoded) {
            super(name, TYPE);
            this.setTriangleValue(aXencoded, aYencoded, true, bXencoded, bYencoded, true, cXencoded, cYencoded, true);
        }

        Triangle(String name, Tessellator.Triangle t) {
            super(name, TYPE);
            this.setTriangleValue(t.getEncodedX(0), t.getEncodedY(0), t.isEdgefromPolygon(0), t.getEncodedX(1), t.getEncodedY(1), t.isEdgefromPolygon(1), t.getEncodedX(2), t.getEncodedY(2), t.isEdgefromPolygon(2));
        }

        protected void setTriangleValue(int aX, int aY, boolean abFromShape, int bX, int bY, boolean bcFromShape, int cX, int cY, boolean caFromShape) {
            byte[] bytes;
            if (this.fieldsData == null) {
                bytes = new byte[28];
                this.fieldsData = new BytesRef(bytes);
            } else {
                bytes = ((BytesRef)this.fieldsData).bytes;
            }
            ShapeField.encodeTriangle(bytes, aY, aX, abFromShape, bY, bX, bcFromShape, cY, cX, caFromShape);
        }
    }
}

