/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.algebra;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.federated.algebra.ExclusiveTupleExpr;
import org.eclipse.rdf4j.federated.algebra.FedXStatementPattern;
import org.eclipse.rdf4j.federated.algebra.StatementSource;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.evaluation.TripleSource;
import org.eclipse.rdf4j.federated.evaluation.iterator.InsertBindingsIteration;
import org.eclipse.rdf4j.federated.evaluation.iterator.SingleBindingSetIteration;
import org.eclipse.rdf4j.federated.exception.IllegalQueryException;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.federated.util.QueryStringUtil;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.repository.RepositoryException;

public class ExclusiveStatement
extends FedXStatementPattern
implements ExclusiveTupleExpr {
    private static final long serialVersionUID = -6963394279179263763L;

    public ExclusiveStatement(StatementPattern node, StatementSource owner, QueryInfo queryInfo) {
        super(node, queryInfo);
        this.statementSources.add(owner);
    }

    @Override
    public StatementSource getOwner() {
        return this.getStatementSources().get(0);
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bindings) throws QueryEvaluationException {
        try {
            Object res;
            Endpoint ownedEndpoint = this.queryInfo.getFederationContext().getEndpointManager().getEndpoint(this.getOwner().getEndpointID());
            TripleSource t = ownedEndpoint.getTripleSource();
            if (t.usePreparedQuery(this, this.queryInfo)) {
                String preparedQuery;
                AtomicBoolean isEvaluated = new AtomicBoolean(false);
                try {
                    preparedQuery = QueryStringUtil.selectQueryString(this, bindings, this.filterExpr, isEvaluated, this.queryInfo.getDataset());
                }
                catch (IllegalQueryException e1) {
                    if (t.hasStatements(this, bindings, this.queryInfo, this.queryInfo.getDataset())) {
                        Object res2 = new SingleBindingSetIteration(bindings);
                        if (this.boundFilters != null) {
                            res2 = new InsertBindingsIteration((CloseableIteration<BindingSet, QueryEvaluationException>)res2, (BindingSet)this.boundFilters);
                        }
                        return res2;
                    }
                    return new EmptyIteration();
                }
                res = t.getStatements(preparedQuery, bindings, isEvaluated.get() ? null : this.filterExpr, this.queryInfo);
            } else {
                res = t.getStatements(this, bindings, this.filterExpr, this.queryInfo);
            }
            if (this.boundFilters != null) {
                res = new InsertBindingsIteration((CloseableIteration<BindingSet, QueryEvaluationException>)res, (BindingSet)this.boundFilters);
            }
            return res;
        }
        catch (MalformedQueryException | RepositoryException e) {
            throw new QueryEvaluationException(e);
        }
    }
}

