/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Locale;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveBooleanEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class LessThanEvaluator
extends RecursiveBooleanEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public LessThanEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (this.containedEvaluators.size() < 2) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting at least two values but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    protected RecursiveBooleanEvaluator.Checker constructChecker(Object fromValue) throws IOException {
        if (null == fromValue) {
            throw new IOException(String.format(Locale.ROOT, "Unable to check %s(...) because a null value was found", this.constructingFactory.getFunctionName(this.getClass())));
        }
        if (fromValue instanceof Number) {
            return new RecursiveBooleanEvaluator.NumberChecker(){

                @Override
                public boolean test(Object left, Object right) {
                    return new BigDecimal(left.toString()).compareTo(new BigDecimal(right.toString())) < 0;
                }
            };
        }
        if (fromValue instanceof String) {
            return new RecursiveBooleanEvaluator.StringChecker(){

                @Override
                public boolean test(Object left, Object right) {
                    return ((String)left).compareToIgnoreCase((String)right) < 0;
                }
            };
        }
        throw new IOException(String.format(Locale.ROOT, "Unable to check %s(...) for values of type '%s'", this.constructingFactory.getFunctionName(this.getClass()), fromValue.getClass().getSimpleName()));
    }
}

