/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.util;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Models;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InternalUseOnly
public class Configurations {
    private static final boolean USE_CONFIG = "true".equalsIgnoreCase(System.getProperty("org.eclipse.rdf4j.model.vocabulary.experimental.enableConfig"));
    private static final Logger logger = LoggerFactory.getLogger(Configurations.class);

    @InternalUseOnly
    public static Optional<Resource> getResourceValue(Model model, Resource subject, IRI property, IRI legacyProperty) {
        Optional<Resource> result;
        if (!USE_CONFIG && (result = Models.objectResource(model.getStatements(subject, legacyProperty, null, new Resource[0]))).isPresent()) {
            return result;
        }
        return Models.objectResource(model.getStatements(subject, property, null, new Resource[0]));
    }

    @InternalUseOnly
    public static Optional<Literal> getLiteralValue(Model model, Resource subject, IRI property, IRI legacyProperty) {
        Optional<Literal> result;
        if (!USE_CONFIG && (result = Models.objectLiteral(model.getStatements(subject, legacyProperty, null, new Resource[0]))).isPresent()) {
            return result;
        }
        return Models.objectLiteral(model.getStatements(subject, property, null, new Resource[0]));
    }

    @InternalUseOnly
    public static Set<Value> getPropertyValues(Model model, Resource subject, IRI property, IRI legacyProperty) {
        Set objects = model.filter(subject, property, null, new Resource[0]).objects();
        Set legacyObjects = model.filter(subject, legacyProperty, null, new Resource[0]).objects();
        if (USE_CONFIG) {
            legacyObjects = objects;
        } else if (objects.isEmpty()) {
            return legacyObjects;
        }
        if (!objects.equals(legacyObjects)) {
            logger.warn("Discrepancy between use of the old and new config vocabulary.");
            if (objects.containsAll(legacyObjects)) {
                return objects;
            }
            if (legacyObjects.containsAll(objects)) {
                return legacyObjects;
            }
            HashSet<Value> results = new HashSet<Value>(objects);
            results.addAll(legacyObjects);
            return results;
        }
        return legacyObjects;
    }

    @InternalUseOnly
    public static Optional<IRI> getIRIValue(Model model, Resource subject, IRI property, IRI legacyProperty) {
        Optional<IRI> result;
        if (!USE_CONFIG && (result = Models.objectIRI(model.getStatements(subject, legacyProperty, null, new Resource[0]))).isPresent()) {
            return result;
        }
        return Models.objectIRI(model.getStatements(subject, property, null, new Resource[0]));
    }
}

