/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.explanation;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.query.explanation.Explanation;
import org.eclipse.rdf4j.query.explanation.GenericPlanNode;

@Experimental
public class ExplanationImpl
implements Explanation {
    private final GenericPlanNode genericPlanNode;
    ObjectMapper objectMapper = new ObjectMapper();

    public ExplanationImpl(GenericPlanNode genericPlanNode, boolean timedOut) {
        this.genericPlanNode = genericPlanNode;
        if (timedOut) {
            genericPlanNode.setTimedOut(timedOut);
        }
    }

    @Override
    public GenericPlanNode toGenericPlanNode() {
        return this.genericPlanNode;
    }

    @Override
    public String toJson() {
        try {
            return this.objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.PUBLIC_ONLY).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.NONE).setSerializationInclusion(JsonInclude.Include.NON_NULL).writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.toGenericPlanNode());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.toGenericPlanNode().toString();
    }

    @Override
    public String toDot() {
        String sep = System.lineSeparator();
        return "digraph Explanation {" + sep + this.genericPlanNode.toDot() + sep + "}" + sep;
    }
}

