/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.hash;

import java.security.NoSuchAlgorithmException;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.hash.HashFunction;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtility;

public class SHA512
extends HashFunction {
    @Override
    public String getURI() {
        return "SHA512";
    }

    @Override
    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException("SHA512 requires exactly 1 argument, got " + args.length);
        }
        if (args[0] instanceof Literal) {
            Literal literal = (Literal)args[0];
            if (QueryEvaluationUtility.isSimpleLiteral(literal) || XSD.STRING.equals((Object)literal.getDatatype())) {
                String lexValue = literal.getLabel();
                try {
                    return valueFactory.createLiteral(this.hash(lexValue, "SHA-512"));
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
            }
            throw new ValueExprEvaluationException("Invalid argument for SHA512: " + literal);
        }
        throw new ValueExprEvaluationException("Invalid argument for SHA512: " + args[0]);
    }
}

