/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.optimizer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayDeque;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InternalUseOnly
public class ParentReferenceChecker
implements QueryOptimizer {
    private static final Logger logger = LoggerFactory.getLogger(ParentReferenceChecker.class);
    private final QueryOptimizer previousOptimizerInPipeline;

    public ParentReferenceChecker(QueryOptimizer previousOptimizerInPipeline) {
        this.previousOptimizerInPipeline = previousOptimizerInPipeline;
    }

    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        this.verifySerializable((QueryModelNode)tupleExpr);
        tupleExpr.visit((QueryModelVisitor)new ParentCheckingVisitor());
    }

    private void verifySerializable(QueryModelNode tupleExpr) {
        byte[] bytes = this.objectToBytes((Serializable)tupleExpr);
        QueryModelNode parsed = (QueryModelNode)this.bytesToObject(bytes);
        assert (tupleExpr.equals((Object)parsed));
    }

    private byte[] objectToBytes(Serializable object) {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
                objectOutputStream.writeObject(object);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        byteArrayOutputStream.close();
        return byArray;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Object bytesToObject(byte[] str) {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(str);){
            Object object;
            try (ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);){
                object = objectInputStream.readObject();
            }
            return object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private class ParentCheckingVisitor
    extends AbstractQueryModelVisitor<RuntimeException> {
        private final ArrayDeque<QueryModelNode> ancestors = new ArrayDeque();

        private ParentCheckingVisitor() {
        }

        protected void meetNode(QueryModelNode node) throws RuntimeException {
            QueryModelNode expectedParent = this.ancestors.peekLast();
            if (node.getParentNode() != expectedParent) {
                String previousOptimizer = ParentReferenceChecker.this.previousOptimizerInPipeline != null ? ParentReferenceChecker.this.previousOptimizerInPipeline.getClass().getSimpleName() : "query parsing";
                String message = "After " + previousOptimizer + " there was an unexpected parent for node " + node + ": " + node.getParentNode() + " (expected " + expectedParent + ")";
                assert (node.getParentNode() == expectedParent) : message;
            }
            this.ancestors.addLast(node);
            super.meetNode(node);
            this.ancestors.pollLast();
        }
    }
}

