/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Quadrant;
import org.locationtech.jts.geomgraph.DirectedEdge;
import org.locationtech.jts.geomgraph.DirectedEdgeStar;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.EdgeEnd;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.geomgraph.Node;
import org.locationtech.jts.geomgraph.NodeFactory;
import org.locationtech.jts.geomgraph.NodeMap;

public class PlanarGraph {
    protected List edges = new ArrayList();
    protected NodeMap nodes;
    protected List edgeEndList = new ArrayList();

    public static void linkResultDirectedEdges(Collection nodes) {
        for (Node node : nodes) {
            ((DirectedEdgeStar)node.getEdges()).linkResultDirectedEdges();
        }
    }

    public PlanarGraph(NodeFactory nodeFact) {
        this.nodes = new NodeMap(nodeFact);
    }

    public PlanarGraph() {
        this.nodes = new NodeMap(new NodeFactory());
    }

    public Iterator getEdgeIterator() {
        return this.edges.iterator();
    }

    public Collection getEdgeEnds() {
        return this.edgeEndList;
    }

    public boolean isBoundaryNode(int geomIndex, Coordinate coord) {
        Node node = this.nodes.find(coord);
        if (node == null) {
            return false;
        }
        Label label = node.getLabel();
        return label != null && label.getLocation(geomIndex) == 1;
    }

    protected void insertEdge(Edge e) {
        this.edges.add(e);
    }

    public void add(EdgeEnd e) {
        this.nodes.add(e);
        this.edgeEndList.add(e);
    }

    public Iterator getNodeIterator() {
        return this.nodes.iterator();
    }

    public Collection getNodes() {
        return this.nodes.values();
    }

    public Node addNode(Node node) {
        return this.nodes.addNode(node);
    }

    public Node addNode(Coordinate coord) {
        return this.nodes.addNode(coord);
    }

    public Node find(Coordinate coord) {
        return this.nodes.find(coord);
    }

    public void addEdges(List edgesToAdd) {
        for (Edge e : edgesToAdd) {
            this.edges.add(e);
            DirectedEdge de1 = new DirectedEdge(e, true);
            DirectedEdge de2 = new DirectedEdge(e, false);
            de1.setSym(de2);
            de2.setSym(de1);
            this.add(de1);
            this.add(de2);
        }
    }

    public void linkResultDirectedEdges() {
        Iterator nodeit = this.nodes.iterator();
        while (nodeit.hasNext()) {
            Node node = (Node)nodeit.next();
            ((DirectedEdgeStar)node.getEdges()).linkResultDirectedEdges();
        }
    }

    public void linkAllDirectedEdges() {
        Iterator nodeit = this.nodes.iterator();
        while (nodeit.hasNext()) {
            Node node = (Node)nodeit.next();
            ((DirectedEdgeStar)node.getEdges()).linkAllDirectedEdges();
        }
    }

    public EdgeEnd findEdgeEnd(Edge e) {
        for (EdgeEnd ee : this.getEdgeEnds()) {
            if (ee.getEdge() != e) continue;
            return ee;
        }
        return null;
    }

    public Edge findEdge(Coordinate p0, Coordinate p1) {
        for (int i = 0; i < this.edges.size(); ++i) {
            Edge e = (Edge)this.edges.get(i);
            Coordinate[] eCoord = e.getCoordinates();
            if (!p0.equals(eCoord[0]) || !p1.equals(eCoord[1])) continue;
            return e;
        }
        return null;
    }

    public Edge findEdgeInSameDirection(Coordinate p0, Coordinate p1) {
        for (int i = 0; i < this.edges.size(); ++i) {
            Edge e = (Edge)this.edges.get(i);
            Coordinate[] eCoord = e.getCoordinates();
            if (this.matchInSameDirection(p0, p1, eCoord[0], eCoord[1])) {
                return e;
            }
            if (!this.matchInSameDirection(p0, p1, eCoord[eCoord.length - 1], eCoord[eCoord.length - 2])) continue;
            return e;
        }
        return null;
    }

    private boolean matchInSameDirection(Coordinate p0, Coordinate p1, Coordinate ep0, Coordinate ep1) {
        if (!p0.equals(ep0)) {
            return false;
        }
        return Orientation.index(p0, p1, ep1) == 0 && Quadrant.quadrant(p0, p1) == Quadrant.quadrant(ep0, ep1);
    }

    public void printEdges(PrintStream out) {
        out.println("Edges:");
        for (int i = 0; i < this.edges.size(); ++i) {
            out.println("edge " + i + ":");
            Edge e = (Edge)this.edges.get(i);
            e.print(out);
            e.eiList.print(out);
        }
    }

    void debugPrint(Object o) {
        System.out.print(o);
    }

    void debugPrintln(Object o) {
        System.out.println(o);
    }
}

