/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.base;

import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.DistinctIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.RDFStarTripleSource;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.TripleSourceIterationWrapper;
import org.eclipse.rdf4j.sail.base.SailDataset;

@InternalUseOnly
public class SailDatasetTripleSource
implements RDFStarTripleSource {
    private final ValueFactory vf;
    private final SailDataset dataset;

    public SailDatasetTripleSource(ValueFactory vf, SailDataset dataset) {
        this.vf = vf;
        this.dataset = dataset;
    }

    public String toString() {
        return this.dataset.toString();
    }

    public CloseableIteration<? extends Statement> getStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws QueryEvaluationException {
        CloseableIteration<? extends Statement> statements = null;
        try {
            statements = this.dataset.getStatements(subj, pred, obj, contexts);
            return new TripleSourceIterationWrapper<Statement>(statements);
        }
        catch (Throwable t) {
            if (statements != null) {
                statements.close();
            }
            if (t instanceof SailException) {
                throw new QueryEvaluationException(t);
            }
            throw t;
        }
    }

    public ValueFactory getValueFactory() {
        return this.vf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableIteration<? extends Triple> getRdfStarTriples(Resource subj, IRI pred, Value obj) throws QueryEvaluationException {
        CloseableIteration<? extends Triple> triples = null;
        TripleSourceIterationWrapper<? extends Triple> iterationWrapper = null;
        try {
            triples = this.dataset.getTriples(subj, pred, obj);
            iterationWrapper = new TripleSourceIterationWrapper<Triple>(triples);
            return new DistinctIteration(iterationWrapper);
        }
        catch (Throwable t) {
            try {
                if (triples != null) {
                    triples.close();
                }
            }
            finally {
                if (iterationWrapper != null) {
                    iterationWrapper.close();
                }
            }
            if (t instanceof SailException) {
                throw new QueryEvaluationException(t);
            }
            throw t;
        }
    }
}

