/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.util.Arrays;
import java.util.List;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.MultiProjection;
import org.eclipse.rdf4j.query.algebra.ProjectionElemList;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.ProjectionIterator;

public class MultiProjectionIterator
extends LookAheadIteration<BindingSet> {
    private final List<ProjectionElemList> projections;
    private final CloseableIteration<BindingSet> iter;
    private final BindingSet parentBindings;
    private final BindingSet[] previousBindings;
    private BindingSet currentBindings;
    private int nextProjectionIdx;

    public MultiProjectionIterator(MultiProjection multiProjection, CloseableIteration<BindingSet> iter, BindingSet bindings) {
        this.projections = multiProjection.getProjections();
        this.iter = iter;
        this.parentBindings = bindings;
        this.previousBindings = new BindingSet[this.projections.size()];
        this.nextProjectionIdx = -1;
    }

    @Override
    protected BindingSet getNextElement() throws QueryEvaluationException {
        while (true) {
            int projIdx;
            if (this.isClosed()) {
                return null;
            }
            if ((projIdx = this.nextProjectionIdx++) >= 0 && projIdx < this.projections.size()) {
                ProjectionElemList projection = this.projections.get(projIdx);
                BindingSet result = ProjectionIterator.project(projection, this.currentBindings, this.parentBindings);
                if (result.equals(this.previousBindings[projIdx])) continue;
                this.previousBindings[projIdx] = result;
                return result;
            }
            if (!this.iter.hasNext()) break;
            this.currentBindings = (BindingSet)this.iter.next();
            this.nextProjectionIdx = 0;
        }
        return null;
    }

    @Override
    protected void handleClose() throws QueryEvaluationException {
        try {
            super.handleClose();
        }
        finally {
            try {
                this.iter.close();
            }
            finally {
                this.nextProjectionIdx = -1;
                Arrays.fill(this.previousBindings, null);
            }
        }
    }
}

