/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.query.algebra.evaluation.util.ValueComparator;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShaclProperties {
    private static final Logger logger = LoggerFactory.getLogger(ShaclProperties.class);
    private Resource id;
    private IRI type;
    private final List<IRI> clazz = new ArrayList<IRI>();
    private final List<Resource> or = new ArrayList<Resource>();
    private final List<Resource> xone = new ArrayList<Resource>();
    private final List<Resource> and = new ArrayList<Resource>();
    private final List<Resource> not = new ArrayList<Resource>();
    private final List<Resource> node = new ArrayList<Resource>();
    private final List<Resource> property = new ArrayList<Resource>();
    private final List<IRI> equals = new ArrayList<IRI>();
    private final List<IRI> disjoint = new ArrayList<IRI>();
    private final List<IRI> lessThan = new ArrayList<IRI>();
    private final List<IRI> lessThanOrEquals = new ArrayList<IRI>();
    private Long minCount;
    private Long maxCount;
    private IRI datatype;
    private Resource in;
    private final List<Value> hasValue = new ArrayList<Value>();
    private final List<Resource> hasValueIn = new ArrayList<Resource>();
    private Long minLength;
    private Long maxLength;
    private Resource languageIn;
    private Resource nodeKind;
    private Resource path;
    private Literal minExclusive;
    private Literal maxExclusive;
    private Literal minInclusive;
    private Literal maxInclusive;
    private final List<String> pattern = new ArrayList<String>();
    private String flags = null;
    private final Set<Resource> targetClass = new HashSet<Resource>();
    private final TreeSet<Value> targetNode = new TreeSet<Value>(new ValueComparator());
    private final Set<IRI> targetSubjectsOf = new HashSet<IRI>();
    private final Set<IRI> targetObjectsOf = new HashSet<IRI>();
    private final List<Resource> targetShape = new ArrayList<Resource>();
    private Resource qualifiedValueShape;
    private Long qualifiedMinCount;
    private Long qualifiedMaxCount;
    private Boolean qualifiedValueShapesDisjoint;
    private final List<Resource> target = new ArrayList<Resource>();
    private boolean deactivated = false;
    private boolean uniqueLang = false;
    boolean closed = false;
    private Resource ignoredProperties;
    private final List<Literal> message = new ArrayList<Literal>();
    private IRI severity;
    private final List<Resource> sparql = new ArrayList<Resource>();

    public ShaclProperties() {
    }

    public ShaclProperties(Resource id, ShapeSource connection) {
        this.id = id;
        try (Stream<Statement> stream = connection.getAllStatements(id);){
            stream.forEach(statement -> {
                String predicate = statement.getPredicate().toString();
                Value object = statement.getObject();
                switch (predicate) {
                    case "http://www.w3.org/1999/02/22-rdf-syntax-ns#type": {
                        if (object.equals(SHACL.NODE_SHAPE)) {
                            if (this.type != null && !this.type.equals(SHACL.NODE_SHAPE)) {
                                throw new IllegalStateException("Shape " + id + " with multiple types: <" + this.type + ">, <" + SHACL.NODE_SHAPE + ">");
                            }
                            this.type = SHACL.NODE_SHAPE;
                            break;
                        }
                        if (!object.equals(SHACL.PROPERTY_SHAPE)) break;
                        if (this.type != null && !this.type.equals(SHACL.PROPERTY_SHAPE)) {
                            throw new IllegalStateException("Shape " + id + " with multiple types: <" + this.type + ">, <" + SHACL.PROPERTY_SHAPE + ">");
                        }
                        this.type = SHACL.PROPERTY_SHAPE;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#or": {
                        this.or.add((Resource)object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#xone": {
                        this.xone.add((Resource)object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#and": {
                        this.and.add((Resource)object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#not": {
                        this.not.add((Resource)object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#property": {
                        this.property.add((Resource)object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#node": {
                        this.node.add((Resource)object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#message": {
                        this.message.add((Literal)object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#severity": {
                        if (this.severity != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.severity = (IRI)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#languageIn": {
                        if (this.languageIn != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.languageIn = (Resource)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#nodeKind": {
                        if (this.nodeKind != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.nodeKind = (Resource)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#datatype": {
                        if (this.datatype != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.datatype = (IRI)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#minCount": {
                        if (this.minCount != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.minCount = ((Literal)object).longValue();
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#maxCount": {
                        if (this.maxCount != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.maxCount = ((Literal)object).longValue();
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#minLength": {
                        if (this.minLength != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.minLength = ((Literal)object).longValue();
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#maxLength": {
                        if (this.maxLength != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.maxLength = ((Literal)object).longValue();
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#minExclusive": {
                        if (this.minExclusive != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.minExclusive = (Literal)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#maxExclusive": {
                        if (this.maxExclusive != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.maxExclusive = (Literal)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#minInclusive": {
                        if (this.minInclusive != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.minInclusive = (Literal)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#maxInclusive": {
                        if (this.maxInclusive != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.maxInclusive = (Literal)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#pattern": {
                        this.pattern.add(object.stringValue());
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#class": {
                        this.clazz.add((IRI)object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#targetNode": {
                        this.targetNode.add(object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#targetClass": {
                        this.targetClass.add((Resource)object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#targetSubjectsOf": {
                        this.targetSubjectsOf.add((IRI)object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#targetObjectsOf": {
                        this.targetObjectsOf.add((IRI)object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#deactivated": {
                        this.deactivated = ((Literal)object).booleanValue();
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#uniqueLang": {
                        this.uniqueLang = ((Literal)object).booleanValue();
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#closed": {
                        this.closed = ((Literal)object).booleanValue();
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#ignoredProperties": {
                        if (this.ignoredProperties != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.ignoredProperties = (Resource)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#flags": {
                        if (this.flags != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.flags = object.stringValue();
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#path": {
                        if (this.path != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        if (this.type == null) {
                            this.type = SHACL.PROPERTY_SHAPE;
                        } else if (!this.type.equals(SHACL.PROPERTY_SHAPE)) {
                            throw new IllegalStateException("Shape " + id + " has sh:path and must be of type sh:PropertyShape but is type " + this.type);
                        }
                        this.path = (Resource)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#in": {
                        if (this.in != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.in = (Resource)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#equals": {
                        this.equals.add((IRI)object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#disjoint": {
                        this.disjoint.add((IRI)object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#lessThan": {
                        this.lessThan.add((IRI)object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#lessThanOrEquals": {
                        this.lessThanOrEquals.add((IRI)object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#target": {
                        this.target.add((Resource)object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#hasValue": {
                        this.hasValue.add(object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#qualifiedValueShape": {
                        if (this.qualifiedValueShape != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.qualifiedValueShape = (Resource)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#qualifiedValueShapesDisjoint": {
                        if (this.qualifiedValueShapesDisjoint != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.qualifiedValueShapesDisjoint = ((Literal)object).booleanValue();
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#qualifiedMinCount": {
                        if (this.qualifiedMinCount != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.qualifiedMinCount = ((Literal)object).longValue();
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#qualifiedMaxCount": {
                        if (this.qualifiedMaxCount != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.qualifiedMaxCount = ((Literal)object).longValue();
                        break;
                    }
                    case "http://datashapes.org/dash#hasValueIn": {
                        this.hasValueIn.add((Resource)object);
                        break;
                    }
                    case "http://rdf4j.org/shacl-extensions#targetShape": {
                        this.targetShape.add((Resource)object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#sparql": {
                        if (!object.isResource()) {
                            throw new IllegalStateException("Object is not a resource: " + statement);
                        }
                        this.sparql.add((Resource)object);
                        break;
                    }
                    default: {
                        if (!predicate.startsWith("http://www.w3.org/ns/shacl#")) break;
                        logger.warn("Unsupported SHACL feature detected {} in statement {}", (Object)predicate.replace("http://www.w3.org/ns/shacl#", "sh:"), statement);
                    }
                }
            });
        }
        if (this.type == null) {
            this.type = this.path == null ? SHACL.NODE_SHAPE : SHACL.PROPERTY_SHAPE;
        }
    }

    public List<IRI> getClazz() {
        return this.clazz;
    }

    public List<Resource> getOr() {
        return this.or;
    }

    public List<Resource> getAnd() {
        return this.and;
    }

    public List<Resource> getNot() {
        return this.not;
    }

    public Long getMinCount() {
        return this.minCount;
    }

    public Long getMaxCount() {
        return this.maxCount;
    }

    public IRI getDatatype() {
        return this.datatype;
    }

    public Resource getIn() {
        return this.in;
    }

    public Long getMinLength() {
        return this.minLength;
    }

    public Long getMaxLength() {
        return this.maxLength;
    }

    public Resource getLanguageIn() {
        return this.languageIn;
    }

    public Resource getNodeKind() {
        return this.nodeKind;
    }

    public Resource getPath() {
        return this.path;
    }

    public Literal getMinExclusive() {
        return this.minExclusive;
    }

    public Literal getMaxExclusive() {
        return this.maxExclusive;
    }

    public Literal getMinInclusive() {
        return this.minInclusive;
    }

    public Literal getMaxInclusive() {
        return this.maxInclusive;
    }

    public List<String> getPattern() {
        return this.pattern;
    }

    public String getFlags() {
        return this.flags;
    }

    public Set<Resource> getTargetClass() {
        return this.targetClass;
    }

    public TreeSet<Value> getTargetNode() {
        return this.targetNode;
    }

    public Set<IRI> getTargetSubjectsOf() {
        return this.targetSubjectsOf;
    }

    public Set<IRI> getTargetObjectsOf() {
        return this.targetObjectsOf;
    }

    public boolean isDeactivated() {
        return this.deactivated;
    }

    public boolean isUniqueLang() {
        return this.uniqueLang;
    }

    public Resource getId() {
        return this.id;
    }

    public IRI getType() {
        return this.type;
    }

    public List<Literal> getMessage() {
        return this.message;
    }

    public IRI getSeverity() {
        return this.severity;
    }

    public List<Resource> getProperty() {
        return this.property;
    }

    public List<Resource> getNode() {
        return this.node;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Resource getIgnoredProperties() {
        return this.ignoredProperties;
    }

    public List<Resource> getXone() {
        return this.xone;
    }

    public List<Value> getHasValue() {
        return this.hasValue;
    }

    public List<IRI> getEquals() {
        return this.equals;
    }

    public List<IRI> getDisjoint() {
        return this.disjoint;
    }

    public List<IRI> getLessThan() {
        return this.lessThan;
    }

    public List<IRI> getLessThanOrEquals() {
        return this.lessThanOrEquals;
    }

    public List<Resource> getTarget() {
        return this.target;
    }

    public List<Resource> getTargetShape() {
        return this.targetShape;
    }

    public List<Resource> getHasValueIn() {
        return this.hasValueIn;
    }

    public Resource getQualifiedValueShape() {
        return this.qualifiedValueShape;
    }

    public Long getQualifiedMinCount() {
        return this.qualifiedMinCount;
    }

    public Long getQualifiedMaxCount() {
        return this.qualifiedMaxCount;
    }

    public Boolean getQualifiedValueShapesDisjoint() {
        return this.qualifiedValueShapesDisjoint;
    }

    public List<Resource> getSparql() {
        return this.sparql;
    }
}

