/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps;

import java.util.function.Function;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.ServiceJoinIterator;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryEvaluationContext;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.HashJoinIteration;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.JoinIterator;
import org.eclipse.rdf4j.query.algebra.helpers.TupleExprs;

public class JoinQueryEvaluationStep
implements QueryEvaluationStep {
    private final Function<BindingSet, CloseableIteration<BindingSet>> eval;

    public JoinQueryEvaluationStep(EvaluationStrategy strategy, Join join, QueryEvaluationContext context) {
        QueryEvaluationStep leftPrepared = strategy.precompile(join.getLeftArg(), context);
        QueryEvaluationStep rightPrepared = strategy.precompile(join.getRightArg(), context);
        if (join.getRightArg() instanceof Service) {
            this.eval = bindings -> new ServiceJoinIterator(leftPrepared.evaluate((BindingSet)bindings), (Service)join.getRightArg(), (BindingSet)bindings, strategy);
            join.setAlgorithm(ServiceJoinIterator.class.getSimpleName());
        } else if (JoinQueryEvaluationStep.isOutOfScopeForLeftArgBindings(join.getRightArg())) {
            String[] joinAttributes = HashJoinIteration.hashJoinAttributeNames(join);
            this.eval = bindings -> new HashJoinIteration(leftPrepared, rightPrepared, (BindingSet)bindings, false, joinAttributes, context);
            join.setAlgorithm(HashJoinIteration.class.getSimpleName());
        } else {
            this.eval = bindings -> JoinIterator.getInstance(leftPrepared, rightPrepared, bindings);
            join.setAlgorithm(JoinIterator.class.getSimpleName());
        }
    }

    @Override
    public CloseableIteration<BindingSet> evaluate(BindingSet bindings) {
        return this.eval.apply(bindings);
    }

    private static boolean isOutOfScopeForLeftArgBindings(TupleExpr expr) {
        return TupleExprs.isVariableScopeChange(expr) || TupleExprs.containsSubquery(expr);
    }
}

