/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.AbstractBindingSet;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MutableBindingSet;
import org.eclipse.rdf4j.query.impl.SimpleBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InternalUseOnly
public class ArrayBindingSet
extends AbstractBindingSet
implements MutableBindingSet {
    private static final long serialVersionUID = -1L;
    private static final Logger logger = LoggerFactory.getLogger(ArrayBindingSet.class);
    private final String[] bindingNames;
    private Set<String> bindingNamesSetCache;
    private boolean empty;
    private final boolean[] whichBindingsHaveBeenSet;
    private final Value[] values;
    List<String> sortedBindingNames = null;

    public ArrayBindingSet(String ... names) {
        this.bindingNames = names;
        this.values = new Value[names.length];
        this.whichBindingsHaveBeenSet = new boolean[names.length];
        this.empty = true;
    }

    public ArrayBindingSet(BindingSet toCopy, Set<String> names, String[] namesArray) {
        assert (!(toCopy instanceof ArrayBindingSet));
        this.bindingNames = namesArray;
        this.whichBindingsHaveBeenSet = new boolean[this.bindingNames.length];
        this.values = new Value[this.bindingNames.length];
        for (int i = 0; i < this.bindingNames.length; ++i) {
            Binding binding = toCopy.getBinding(this.bindingNames[i]);
            if (binding == null) continue;
            this.values[i] = binding.getValue();
            this.whichBindingsHaveBeenSet[i] = true;
        }
        this.empty = toCopy.isEmpty();
    }

    public ArrayBindingSet(ArrayBindingSet toCopy, String ... names) {
        this.bindingNames = names;
        this.values = Arrays.copyOf(toCopy.values, toCopy.values.length);
        this.whichBindingsHaveBeenSet = Arrays.copyOf(toCopy.whichBindingsHaveBeenSet, toCopy.whichBindingsHaveBeenSet.length);
        this.empty = toCopy.empty;
    }

    public BiConsumer<Value, ArrayBindingSet> getDirectSetBinding(String bindingName) {
        int index = this.getIndex(bindingName);
        if (index == -1) {
            logger.error("Variable not known to ArrayBindingSet : " + bindingName);
            assert (false) : "Variable not known to ArrayBindingSet : " + bindingName;
            return null;
        }
        return (v, a) -> {
            a.values[index] = v;
            a.whichBindingsHaveBeenSet[index] = true;
            a.empty = false;
            a.clearCache();
        };
    }

    public BiConsumer<Value, ArrayBindingSet> getDirectAddBinding(String bindingName) {
        int index = this.getIndex(bindingName);
        if (index == -1) {
            logger.error("Variable not known to ArrayBindingSet : " + bindingName);
            assert (false) : "Variable not known to ArrayBindingSet : " + bindingName;
            return null;
        }
        return (v, a) -> {
            assert (!a.whichBindingsHaveBeenSet[index]) : "variable already bound: " + bindingName;
            a.values[index] = v;
            a.whichBindingsHaveBeenSet[index] = true;
            a.empty = false;
            a.clearCache();
        };
    }

    public Function<ArrayBindingSet, Binding> getDirectGetBinding(String bindingName) {
        int index = this.getIndex(bindingName);
        if (index == -1) {
            return null;
        }
        return a -> {
            Value value = a.values[index];
            if (value != null) {
                return new SimpleBinding(bindingName, value);
            }
            return null;
        };
    }

    public Function<ArrayBindingSet, Value> getDirectGetValue(String bindingName) {
        int index = this.getIndex(bindingName);
        if (index == -1) {
            return null;
        }
        return a -> a.values[index];
    }

    public Function<ArrayBindingSet, Boolean> getDirectHasBinding(String bindingName) {
        int index = this.getIndex(bindingName);
        if (index == -1) {
            return null;
        }
        return a -> a.whichBindingsHaveBeenSet[index];
    }

    private int getIndex(String bindingName) {
        int i;
        for (i = 0; i < this.bindingNames.length; ++i) {
            if (this.bindingNames[i] != bindingName) continue;
            return i;
        }
        for (i = 0; i < this.bindingNames.length; ++i) {
            if (!this.bindingNames[i].equals(bindingName)) continue;
            return i;
        }
        return -1;
    }

    public Set<String> getBindingNames() {
        if (this.bindingNamesSetCache == null) {
            int size = this.size();
            if (size == 0) {
                this.bindingNamesSetCache = Collections.emptySet();
            } else if (size == 1) {
                for (int i = 0; i < this.bindingNames.length; ++i) {
                    if (!this.whichBindingsHaveBeenSet[i]) continue;
                    this.bindingNamesSetCache = Collections.singleton(this.bindingNames[i]);
                    break;
                }
                assert (this.bindingNamesSetCache != null);
            } else {
                LinkedHashSet<String> bindingNamesSetCache = new LinkedHashSet<String>(size * 2);
                for (int i = 0; i < this.bindingNames.length; ++i) {
                    if (!this.whichBindingsHaveBeenSet[i]) continue;
                    bindingNamesSetCache.add(this.bindingNames[i]);
                }
                this.bindingNamesSetCache = Collections.unmodifiableSet(bindingNamesSetCache);
            }
        }
        return this.bindingNamesSetCache;
    }

    public Value getValue(String bindingName) {
        int i;
        for (i = 0; i < this.bindingNames.length; ++i) {
            if (this.bindingNames[i] != bindingName || !this.whichBindingsHaveBeenSet[i]) continue;
            return this.values[i];
        }
        for (i = 0; i < this.bindingNames.length; ++i) {
            if (!this.bindingNames[i].equals(bindingName) || !this.whichBindingsHaveBeenSet[i]) continue;
            return this.values[i];
        }
        return null;
    }

    public Binding getBinding(String bindingName) {
        Value value = this.getValue(bindingName);
        if (value != null) {
            return new SimpleBinding(bindingName, value);
        }
        return null;
    }

    public boolean hasBinding(String bindingName) {
        int index = this.getIndex(bindingName);
        if (index == -1) {
            return false;
        }
        return this.whichBindingsHaveBeenSet[index];
    }

    public Iterator<Binding> iterator() {
        return new ArrayBindingSetIterator();
    }

    public int size() {
        if (this.empty) {
            return 0;
        }
        int size = 0;
        for (boolean value : this.whichBindingsHaveBeenSet) {
            if (!value) continue;
            ++size;
        }
        return size;
    }

    public List<String> getSortedBindingNames() {
        if (this.sortedBindingNames == null) {
            int size = this.size();
            if (size == 1) {
                for (int i = 0; i < this.bindingNames.length; ++i) {
                    if (!this.whichBindingsHaveBeenSet[i]) continue;
                    this.sortedBindingNames = Collections.singletonList(this.bindingNames[i]);
                }
            } else {
                ArrayList<String> names = new ArrayList<String>(size);
                for (int i = 0; i < this.bindingNames.length; ++i) {
                    if (!this.whichBindingsHaveBeenSet[i]) continue;
                    names.add(this.bindingNames[i]);
                }
                names.sort(String::compareTo);
                this.sortedBindingNames = names;
            }
        }
        return this.sortedBindingNames;
    }

    public void addBinding(Binding binding) {
        int index = this.getIndex(binding.getName());
        if (index == -1) {
            logger.error("We don't actually support adding a binding. " + binding.getName() + " : " + binding.getValue());
            assert (false) : "We don't actually support adding a binding. " + binding.getName() + " : " + binding.getValue();
            return;
        }
        assert (!this.whichBindingsHaveBeenSet[index]);
        this.values[index] = binding.getValue();
        this.whichBindingsHaveBeenSet[index] = true;
        this.clearCache();
    }

    public void setBinding(Binding binding) {
        int index = this.getIndex(binding.getName());
        if (index == -1) {
            return;
        }
        this.values[index] = binding.getValue();
        this.whichBindingsHaveBeenSet[index] = true;
        this.clearCache();
    }

    public void setBinding(String name, Value value) {
        int index = this.getIndex(name);
        if (index == -1) {
            return;
        }
        this.values[index] = value;
        boolean bl = this.whichBindingsHaveBeenSet[index] = value != null;
        if (value == null) {
            this.empty = true;
            for (boolean b : this.whichBindingsHaveBeenSet) {
                if (!b) continue;
                this.empty = false;
                break;
            }
        }
        this.clearCache();
    }

    public boolean isEmpty() {
        return this.empty;
    }

    private void clearCache() {
        this.bindingNamesSetCache = null;
    }

    private class ArrayBindingSetIterator
    implements Iterator<Binding> {
        private int index = 0;

        @Override
        public boolean hasNext() {
            while (this.index < ArrayBindingSet.this.values.length) {
                if (ArrayBindingSet.this.whichBindingsHaveBeenSet[this.index] && ArrayBindingSet.this.values[this.index] != null) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        @Override
        public Binding next() {
            Value value;
            while (!(this.index >= ArrayBindingSet.this.values.length || ArrayBindingSet.this.whichBindingsHaveBeenSet[this.index] && ArrayBindingSet.this.values[this.index] != null)) {
                ++this.index;
            }
            String name = ArrayBindingSet.this.bindingNames[this.index];
            if ((value = ArrayBindingSet.this.values[this.index++]) != null) {
                return new SimpleBinding(name, value);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

