/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.evaluation;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.TripleSourceIterationWrapper;

public class SailTripleSource
implements TripleSource {
    private final SailConnection conn;
    private final boolean includeInferred;
    private final ValueFactory vf;

    public SailTripleSource(SailConnection conn, boolean includeInferred, ValueFactory valueFactory) {
        this.conn = conn;
        this.includeInferred = includeInferred;
        this.vf = valueFactory;
    }

    public CloseableIteration<? extends Statement> getStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws QueryEvaluationException {
        CloseableIteration iter = null;
        try {
            iter = this.conn.getStatements(subj, pred, obj, this.includeInferred, contexts);
            if (iter instanceof EmptyIteration) {
                return iter;
            }
            return new TripleSourceIterationWrapper(iter);
        }
        catch (Throwable t) {
            if (iter != null) {
                iter.close();
            }
            if (t instanceof SailException) {
                throw new QueryEvaluationException(t);
            }
            throw t;
        }
    }

    public ValueFactory getValueFactory() {
        return this.vf;
    }
}

