/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.base;

import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.sail.SailException;

public class DistinctModelReducingUnionIteration
extends LookAheadIteration<Statement> {
    private final CloseableIteration<? extends Statement> iterator;
    private final Consumer<Statement> approvedRemover;
    private final Supplier<Iterable<Statement>> approvedSupplier;
    private Iterator<? extends Statement> filteredStatementsIterator;

    DistinctModelReducingUnionIteration(CloseableIteration<? extends Statement> iterator, Consumer<Statement> approvedRemover, Supplier<Iterable<Statement>> approvedSupplier) {
        this.iterator = iterator;
        this.approvedRemover = approvedRemover;
        this.approvedSupplier = approvedSupplier;
    }

    @Override
    protected Statement getNextElement() throws SailException {
        Statement next = null;
        if (this.iterator.hasNext()) {
            next = (Statement)this.iterator.next();
            this.approvedRemover.accept(next);
        } else {
            if (this.filteredStatementsIterator == null) {
                this.filteredStatementsIterator = this.approvedSupplier.get().iterator();
            }
            if (this.filteredStatementsIterator.hasNext()) {
                next = this.filteredStatementsIterator.next();
            }
        }
        return next;
    }

    @Override
    protected void handleClose() throws SailException {
        this.iterator.close();
    }
}

