/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.helpers;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.common.text.ASCIIUtil;
import org.eclipse.rdf4j.common.text.StringUtil;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.rio.helpers.NTriplesWriterSettings;

public class NTriplesUtil {
    private static final String PN_CHARS_BASE = "[A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd\ud800\udc00-\udb7f\udfff]";
    private static final String PN_CHARS_U = "(?:[A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd\ud800\udc00-\udb7f\udfff]|_)";
    private static final String PN_CHARS = "(?:(?:[A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd\ud800\udc00-\udb7f\udfff]|_)|[0-9\u0300-\u036f\u203f-\u2040\u00b7-])";
    private static final String BNODE_ID = "(?:(?:[A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd\ud800\udc00-\udb7f\udfff]|_)|[0-9])(?:(?:(?:(?:[A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd\ud800\udc00-\udb7f\udfff]|_)|[0-9\u0300-\u036f\u203f-\u2040\u00b7-])|\\.)*(?:(?:[A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd\ud800\udc00-\udb7f\udfff]|_)|[0-9\u0300-\u036f\u203f-\u2040\u00b7-]))?";
    private static final String BNODE = "_:(?:(?:[A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd\ud800\udc00-\udb7f\udfff]|_)|[0-9])(?:(?:(?:(?:[A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd\ud800\udc00-\udb7f\udfff]|_)|[0-9\u0300-\u036f\u203f-\u2040\u00b7-])|\\.)*(?:(?:[A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd\ud800\udc00-\udb7f\udfff]|_)|[0-9\u0300-\u036f\u203f-\u2040\u00b7-]))?";
    private static final String HEX = "[0-9A-Fa-f]";
    private static final String UCHAR = "(?:\\\\u[0-9A-Fa-f]{4}|\\\\U[0-9A-Fa-f]{8})";
    private static final String IRI = "<(?:[^\u0000- <>\"{}|^`\\\\]|(?:\\\\u[0-9A-Fa-f]{4}|\\\\U[0-9A-Fa-f]{8}))*>";
    private static final String ECHAR = "\\\\[tbnrf\"'\\\\]";
    private static final String STRING_LITERAL_QUOTE = "\"(?:[^\"\\\\\n\r]|\\\\[tbnrf\"'\\\\]|(?:\\\\u[0-9A-Fa-f]{4}|\\\\U[0-9A-Fa-f]{8}))*+\"";
    private static final String LANGTAG = "@[a-zA-Z]+(?:-[a-zA-Z0-9]+)*";
    private static final String LITERAL = "\"(?:[^\"\\\\\n\r]|\\\\[tbnrf\"'\\\\]|(?:\\\\u[0-9A-Fa-f]{4}|\\\\U[0-9A-Fa-f]{8}))*+\"(?:\\^\\^<(?:[^\u0000- <>\"{}|^`\\\\]|(?:\\\\u[0-9A-Fa-f]{4}|\\\\U[0-9A-Fa-f]{8}))*>|@[a-zA-Z]+(?:-[a-zA-Z0-9]+)*)?";
    private static final Pattern BNODE_ID_PATTERN = Pattern.compile("(?:(?:[A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd\ud800\udc00-\udb7f\udfff]|_)|[0-9])(?:(?:(?:(?:[A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd\ud800\udc00-\udb7f\udfff]|_)|[0-9\u0300-\u036f\u203f-\u2040\u00b7-])|\\.)*(?:(?:[A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd\ud800\udc00-\udb7f\udfff]|_)|[0-9\u0300-\u036f\u203f-\u2040\u00b7-]))?");
    private static final Pattern BNODE_PATTERN = Pattern.compile("_:(?:(?:[A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd\ud800\udc00-\udb7f\udfff]|_)|[0-9])(?:(?:(?:(?:[A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd\ud800\udc00-\udb7f\udfff]|_)|[0-9\u0300-\u036f\u203f-\u2040\u00b7-])|\\.)*(?:(?:[A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd\ud800\udc00-\udb7f\udfff]|_)|[0-9\u0300-\u036f\u203f-\u2040\u00b7-]))?");
    private static final Pattern IRI_PATTERN = Pattern.compile("<(?:[^\u0000- <>\"{}|^`\\\\]|(?:\\\\u[0-9A-Fa-f]{4}|\\\\U[0-9A-Fa-f]{8}))*>");
    private static final Pattern LITERAL_PATTERN = Pattern.compile("\"(?:[^\"\\\\\n\r]|\\\\[tbnrf\"'\\\\]|(?:\\\\u[0-9A-Fa-f]{4}|\\\\U[0-9A-Fa-f]{8}))*+\"(?:\\^\\^<(?:[^\u0000- <>\"{}|^`\\\\]|(?:\\\\u[0-9A-Fa-f]{4}|\\\\U[0-9A-Fa-f]{8}))*>|@[a-zA-Z]+(?:-[a-zA-Z0-9]+)*)?");

    public static Value parseValue(String nTriplesValue, ValueFactory valueFactory) throws IllegalArgumentException {
        if (nTriplesValue.startsWith("<<")) {
            return NTriplesUtil.parseTriple(nTriplesValue, valueFactory);
        }
        if (nTriplesValue.startsWith("<")) {
            return NTriplesUtil.parseURI(nTriplesValue, valueFactory);
        }
        if (nTriplesValue.startsWith("_:")) {
            return NTriplesUtil.parseBNode(nTriplesValue, valueFactory);
        }
        if (nTriplesValue.startsWith("\"")) {
            return NTriplesUtil.parseLiteral(nTriplesValue, valueFactory);
        }
        throw new IllegalArgumentException("Not a legal N-Triples value: " + nTriplesValue);
    }

    public static Resource parseResource(String nTriplesResource, ValueFactory valueFactory) throws IllegalArgumentException {
        if (nTriplesResource.startsWith("<<")) {
            return NTriplesUtil.parseTriple(nTriplesResource, valueFactory);
        }
        if (nTriplesResource.startsWith("<")) {
            return NTriplesUtil.parseURI(nTriplesResource, valueFactory);
        }
        if (nTriplesResource.startsWith("_:")) {
            return NTriplesUtil.parseBNode(nTriplesResource, valueFactory);
        }
        throw new IllegalArgumentException("Not a legal N-Triples resource: " + nTriplesResource);
    }

    public static IRI parseURI(String nTriplesURI, ValueFactory valueFactory) throws IllegalArgumentException {
        String uri;
        if (nTriplesURI.startsWith("<") && nTriplesURI.endsWith(">") && !(uri = nTriplesURI.substring(1, nTriplesURI.length() - 1)).startsWith("<")) {
            uri = NTriplesUtil.unescapeString(uri);
            return valueFactory.createIRI(uri);
        }
        throw new IllegalArgumentException("Not a legal N-Triples URI: " + nTriplesURI);
    }

    public static BNode parseBNode(String nTriplesBNode, ValueFactory valueFactory) throws IllegalArgumentException {
        if (nTriplesBNode.startsWith("_:")) {
            return valueFactory.createBNode(nTriplesBNode.substring(2));
        }
        throw new IllegalArgumentException("Not a legal N-Triples Blank Node: " + nTriplesBNode);
    }

    public static Literal parseLiteral(String nTriplesLiteral, ValueFactory valueFactory) throws IllegalArgumentException {
        int endLabelIdx;
        if (nTriplesLiteral.startsWith("\"") && (endLabelIdx = NTriplesUtil.findEndOfLabel(nTriplesLiteral)) != -1) {
            int startLangIdx = nTriplesLiteral.indexOf(64, endLabelIdx);
            int startDtIdx = nTriplesLiteral.indexOf("^^", endLabelIdx);
            if (startLangIdx != -1 && startDtIdx != -1) {
                throw new IllegalArgumentException("Literals can not have both a language and a datatype");
            }
            String label = nTriplesLiteral.substring(1, endLabelIdx);
            label = NTriplesUtil.unescapeString(label);
            if (startLangIdx != -1) {
                String language = nTriplesLiteral.substring(startLangIdx + 1);
                return valueFactory.createLiteral(label, language);
            }
            if (startDtIdx != -1) {
                String datatype = nTriplesLiteral.substring(startDtIdx + 2);
                IRI dtURI = NTriplesUtil.parseURI(datatype, valueFactory);
                return valueFactory.createLiteral(label, dtURI);
            }
            return valueFactory.createLiteral(label);
        }
        throw new IllegalArgumentException("Not a legal N-Triples literal: " + nTriplesLiteral);
    }

    public static Triple parseTriple(String nTriplesTriple, ValueFactory valueFactory) {
        TripleMatch tm = NTriplesUtil.parseTripleInternal(nTriplesTriple, valueFactory);
        if (tm.length != nTriplesTriple.length()) {
            throw new IllegalArgumentException("Not a valid N-Triples triple: " + nTriplesTriple);
        }
        return tm.triple;
    }

    private static TripleMatch parseTripleInternal(String nTriplesTriple, ValueFactory valueFactory) {
        if (nTriplesTriple.startsWith("<<")) {
            String triple = nTriplesTriple.substring(2);
            int offset = 2;
            while (!triple.isEmpty() && Character.isWhitespace(triple.charAt(0))) {
                triple = triple.substring(1);
                ++offset;
            }
            Resource subject = null;
            IRI predicate = null;
            BNode object = null;
            for (int i = 0; i < 3; ++i) {
                Matcher literalMatcher;
                String value;
                Value v = null;
                if (triple.startsWith("_:")) {
                    Matcher bNodeMatcher = BNODE_PATTERN.matcher(triple);
                    if (bNodeMatcher.find() && bNodeMatcher.start() == 0) {
                        value = bNodeMatcher.group();
                        v = NTriplesUtil.parseBNode(value, valueFactory);
                        triple = triple.substring(bNodeMatcher.end());
                        offset += bNodeMatcher.end();
                    }
                } else if (triple.startsWith("<<")) {
                    TripleMatch tm = NTriplesUtil.parseTripleInternal(triple, valueFactory);
                    triple = triple.substring(tm.length);
                    offset += tm.length;
                    v = tm.triple;
                } else if (triple.startsWith("<")) {
                    Matcher iriMatcher = IRI_PATTERN.matcher(triple);
                    if (iriMatcher.find() && iriMatcher.start() == 0) {
                        value = iriMatcher.group();
                        v = NTriplesUtil.parseURI(value, valueFactory);
                        triple = triple.substring(iriMatcher.end());
                        offset += iriMatcher.end();
                    }
                } else if (triple.startsWith("\"") && (literalMatcher = LITERAL_PATTERN.matcher(triple)).find() && literalMatcher.start() == 0) {
                    value = literalMatcher.group();
                    v = NTriplesUtil.parseLiteral(value, valueFactory);
                    triple = triple.substring(literalMatcher.end());
                    offset += literalMatcher.end();
                }
                if (i == 0) {
                    if (!(v instanceof Resource)) {
                        throw new IllegalArgumentException("Not a valid N-Triples triple: " + nTriplesTriple);
                    }
                    subject = v;
                } else if (i == 1) {
                    if (!(v instanceof IRI)) {
                        throw new IllegalArgumentException("Not a valid N-Triples triple: " + nTriplesTriple);
                    }
                    predicate = (IRI)v;
                } else if (i == 2) {
                    if (v == null) {
                        throw new IllegalArgumentException("Not a valid N-Triples triple: " + nTriplesTriple);
                    }
                    object = v;
                }
                while (!triple.isEmpty() && Character.isWhitespace(triple.charAt(0))) {
                    triple = triple.substring(1);
                    ++offset;
                }
            }
            if (triple.endsWith(">>")) {
                return new TripleMatch(valueFactory.createTriple(subject, predicate, object), offset += 2);
            }
        }
        throw new IllegalArgumentException("Not a valid N-Triples triple: " + nTriplesTriple);
    }

    private static int findEndOfLabel(String nTriplesLiteral) {
        boolean previousWasBackslash = false;
        for (int i = 1; i < nTriplesLiteral.length(); ++i) {
            char c = nTriplesLiteral.charAt(i);
            if (c == '\"' && !previousWasBackslash) {
                return i;
            }
            if (c == '\\' && !previousWasBackslash) {
                previousWasBackslash = true;
                continue;
            }
            if (!previousWasBackslash) continue;
            previousWasBackslash = false;
        }
        return -1;
    }

    public static String toNTriplesString(Value value) {
        return NTriplesUtil.toNTriplesString(value, (boolean)BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL.getDefaultValue());
    }

    public static String toNTriplesString(Value value, boolean xsdStringToPlainLiteral) {
        if (value instanceof Resource) {
            return NTriplesUtil.toNTriplesString((Resource)value);
        }
        if (value instanceof Literal) {
            return NTriplesUtil.toNTriplesString((Literal)value, xsdStringToPlainLiteral);
        }
        throw new IllegalArgumentException("Unknown value type: " + value.getClass());
    }

    public static void append(Value value, Appendable appendable) throws IOException {
        NTriplesUtil.append(value, appendable, (boolean)BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL.getDefaultValue(), (boolean)NTriplesWriterSettings.ESCAPE_UNICODE.getDefaultValue());
    }

    public static void append(Value value, Appendable appendable, boolean xsdStringToPlainLiteral, boolean escapeUnicode) throws IOException {
        if (value instanceof Resource) {
            NTriplesUtil.append((Resource)value, appendable);
        } else if (value instanceof Literal) {
            NTriplesUtil.append((Literal)value, appendable, xsdStringToPlainLiteral, escapeUnicode);
        } else {
            throw new IllegalArgumentException("Unknown value type: " + value.getClass());
        }
    }

    public static String toNTriplesString(Resource resource) {
        if (resource instanceof IRI) {
            return NTriplesUtil.toNTriplesString((IRI)resource);
        }
        if (resource instanceof BNode) {
            return NTriplesUtil.toNTriplesString((BNode)resource);
        }
        if (resource instanceof Triple) {
            return NTriplesUtil.toNTriplesString((Triple)resource);
        }
        throw new IllegalArgumentException("Unknown resource type: " + resource.getClass());
    }

    public static void append(Resource resource, Appendable appendable) throws IOException {
        if (resource instanceof IRI) {
            NTriplesUtil.append((IRI)resource, appendable);
        } else if (resource instanceof BNode) {
            NTriplesUtil.append((BNode)resource, appendable);
        } else if (resource instanceof Triple) {
            NTriplesUtil.append((Triple)resource, appendable);
        } else {
            throw new IllegalArgumentException("Unknown resource type: " + resource.getClass());
        }
    }

    public static String toNTriplesString(IRI uri) {
        return "<" + NTriplesUtil.escapeString(uri.toString()) + ">";
    }

    public static void append(IRI uri, Appendable appendable) throws IOException {
        NTriplesUtil.append(uri, appendable, true);
    }

    public static void append(IRI uri, Appendable appendable, boolean escapeUnicode) throws IOException {
        appendable.append('<');
        StringUtil.simpleEscapeIRI(uri.toString(), appendable, escapeUnicode);
        appendable.append('>');
    }

    public static String toNTriplesString(BNode bNode) {
        try {
            StringBuilder result = new StringBuilder(bNode.getID().length() + 1);
            NTriplesUtil.append(bNode, (Appendable)result);
            return result.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Should not receive IOException with StringBuilder", e);
        }
    }

    public static void append(BNode bNode, Appendable appendable) throws IOException {
        String nextId = bNode.getID();
        appendable.append("_:");
        if (nextId.isEmpty() || !BNODE_ID_PATTERN.matcher(nextId).matches()) {
            appendable.append("genid");
            appendable.append(Integer.toHexString(bNode.hashCode()));
        } else {
            appendable.append(nextId);
        }
    }

    public static String toNTriplesString(Literal lit) {
        return NTriplesUtil.toNTriplesString(lit, (boolean)BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL.getDefaultValue());
    }

    public static String toNTriplesString(Literal lit, boolean xsdStringToPlainLiteral) {
        try {
            StringBuilder sb = new StringBuilder();
            NTriplesUtil.append(lit, (Appendable)sb, xsdStringToPlainLiteral, (boolean)NTriplesWriterSettings.ESCAPE_UNICODE.getDefaultValue());
            return sb.toString();
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    public static void append(Literal lit, Appendable appendable) throws IOException {
        NTriplesUtil.append(lit, appendable, (boolean)BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL.getDefaultValue(), (boolean)NTriplesWriterSettings.ESCAPE_UNICODE.getDefaultValue());
    }

    public static void append(Literal lit, Appendable appendable, boolean xsdStringToPlainLiteral, boolean escapeUnicode) throws IOException {
        appendable.append("\"");
        NTriplesUtil.escapeString(lit.getLabel(), appendable, escapeUnicode);
        appendable.append("\"");
        if (Literals.isLanguageLiteral(lit)) {
            appendable.append("@");
            appendable.append(lit.getLanguage().get());
        } else {
            boolean ignoreDatatype;
            IRI datatype = lit.getDatatype();
            boolean bl = ignoreDatatype = datatype.equals(XSD.STRING) && xsdStringToPlainLiteral;
            if (!ignoreDatatype) {
                appendable.append("^^");
                NTriplesUtil.append(lit.getDatatype(), appendable);
            }
        }
    }

    public static String toNTriplesString(Triple triple) {
        return "<<" + NTriplesUtil.toNTriplesString(triple.getSubject()) + " " + NTriplesUtil.toNTriplesString(triple.getPredicate()) + " " + NTriplesUtil.toNTriplesString(triple.getObject()) + ">>";
    }

    public static void append(Triple triple, Appendable appendable) throws IOException {
        appendable.append("<<");
        NTriplesUtil.append(triple.getSubject(), appendable);
        appendable.append(' ');
        NTriplesUtil.append(triple.getPredicate(), appendable);
        appendable.append(' ');
        NTriplesUtil.append(triple.getObject(), appendable);
        appendable.append(">>");
    }

    @Deprecated
    public static boolean isLetterOrNumber(int c) {
        return ASCIIUtil.isLetterOrNumber(c);
    }

    @Deprecated
    public static boolean isLetter(int c) {
        return ASCIIUtil.isLetter(c);
    }

    @Deprecated
    public static boolean isNumber(int c) {
        return ASCIIUtil.isNumber(c);
    }

    public static boolean isValidCharacterForBNodeLabel(int c) {
        return ASCIIUtil.isLetterOrNumber(c) || NTriplesUtil.isLiberalCharactersButNotDot(c) || NTriplesUtil.isDot(c);
    }

    public static boolean isLiberalCharactersButNotDot(int c) {
        return NTriplesUtil.isUnderscore(c) || c == 45 || c == 183 || c >= 768 && c <= 879 || c == 8255 || c == 8256;
    }

    public static boolean isUnderscore(int c) {
        return c == 95;
    }

    public static boolean isDot(int c) {
        return c == 46;
    }

    public static String escapeString(String label) {
        try {
            StringBuilder sb = new StringBuilder(2 * label.length());
            NTriplesUtil.escapeString(label, sb);
            return sb.toString();
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    public static void escapeString(String label, Appendable appendable) throws IOException {
        NTriplesUtil.escapeString(label, appendable, true);
    }

    public static void escapeString(String label, Appendable appendable, boolean escapeUnicode) throws IOException {
        int labelLength = label.length();
        for (int i = 0; i < labelLength; ++i) {
            char c;
            char cInt = c = label.charAt(i);
            if (c == '\\') {
                appendable.append("\\\\");
                continue;
            }
            if (c == '\"') {
                appendable.append("\\\"");
                continue;
            }
            if (c == '\n') {
                appendable.append("\\n");
                continue;
            }
            if (c == '\r') {
                appendable.append("\\r");
                continue;
            }
            if (c == '\t') {
                appendable.append("\\t");
                continue;
            }
            if (cInt >= '\u0000' && cInt <= '\b' || cInt == '\u000b' || cInt == '\f' || cInt >= '\u000e' && cInt <= '\u001f' || cInt >= '\u007f' && cInt <= '\uffff') {
                if (escapeUnicode) {
                    appendable.append("\\u");
                    appendable.append(NTriplesUtil.toHexString(cInt, 4));
                    continue;
                }
                appendable.append(c);
                continue;
            }
            if (cInt >= '\u10000' && cInt <= '\u10ffff') {
                if (escapeUnicode) {
                    appendable.append("\\U");
                    appendable.append(NTriplesUtil.toHexString(cInt, 8));
                    continue;
                }
                appendable.append(c);
                continue;
            }
            appendable.append(c);
        }
    }

    public static String unescapeString(String s) {
        int backSlashIdx = s.indexOf(92);
        if (backSlashIdx == -1) {
            return s;
        }
        int startIdx = 0;
        int sLength = s.length();
        StringBuilder sb = new StringBuilder(sLength);
        while (backSlashIdx != -1) {
            int codePoint;
            String xx;
            sb.append(s.substring(startIdx, backSlashIdx));
            if (backSlashIdx + 1 >= sLength) {
                throw new IllegalArgumentException("Unescaped backslash in: " + s);
            }
            char c = s.charAt(backSlashIdx + 1);
            if (c == 't') {
                sb.append('\t');
                startIdx = backSlashIdx + 2;
            } else if (c == 'b') {
                sb.append('\b');
                startIdx = backSlashIdx + 2;
            } else if (c == 'n') {
                sb.append('\n');
                startIdx = backSlashIdx + 2;
            } else if (c == 'r') {
                sb.append('\r');
                startIdx = backSlashIdx + 2;
            } else if (c == 'f') {
                sb.append('\f');
                startIdx = backSlashIdx + 2;
            } else if (c == '\"') {
                sb.append('\"');
                startIdx = backSlashIdx + 2;
            } else if (c == '\'') {
                sb.append('\'');
                startIdx = backSlashIdx + 2;
            } else if (c == '\\') {
                sb.append('\\');
                startIdx = backSlashIdx + 2;
            } else if (c == 'u') {
                if (backSlashIdx + 5 >= sLength) {
                    throw new IllegalArgumentException("Incomplete Unicode escape sequence in: " + s);
                }
                xx = s.substring(backSlashIdx + 2, backSlashIdx + 6);
                try {
                    codePoint = Integer.parseInt(xx, 16);
                    sb.append(Character.toChars(codePoint));
                    startIdx = backSlashIdx + 6;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal Unicode escape sequence '\\u" + xx + "' in: " + s);
                }
            } else if (c == 'U') {
                if (backSlashIdx + 9 >= sLength) {
                    throw new IllegalArgumentException("Incomplete Unicode escape sequence in: " + s);
                }
                xx = s.substring(backSlashIdx + 2, backSlashIdx + 10);
                try {
                    codePoint = Integer.parseInt(xx, 16);
                    sb.append(Character.toChars(codePoint));
                    startIdx = backSlashIdx + 10;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal Unicode escape sequence '\\U" + xx + "' in: " + s);
                }
            } else {
                throw new IllegalArgumentException("Unescaped backslash in: " + s);
            }
            backSlashIdx = s.indexOf(92, startIdx);
        }
        sb.append(s.substring(startIdx));
        return sb.toString();
    }

    public static String toHexString(int decimal, int stringLength) {
        StringBuilder sb = new StringBuilder(stringLength);
        String hexVal = Integer.toHexString(decimal).toUpperCase();
        int nofZeros = stringLength - hexVal.length();
        for (int i = 0; i < nofZeros; ++i) {
            sb.append('0');
        }
        sb.append(hexVal);
        return sb.toString();
    }

    static class TripleMatch {
        Triple triple;
        int length;

        TripleMatch(Triple triple, int length) {
            this.triple = triple;
            this.length = length;
        }
    }
}

