/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation;

import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.federated.FederationContext;
import org.eclipse.rdf4j.federated.algebra.CheckStatementPattern;
import org.eclipse.rdf4j.federated.algebra.ExclusiveGroup;
import org.eclipse.rdf4j.federated.algebra.FilterTuple;
import org.eclipse.rdf4j.federated.algebra.FilterValueExpr;
import org.eclipse.rdf4j.federated.algebra.StatementTupleExpr;
import org.eclipse.rdf4j.federated.evaluation.FederationEvalStrategy;
import org.eclipse.rdf4j.federated.evaluation.TripleSource;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ControlledWorkerScheduler;
import org.eclipse.rdf4j.federated.evaluation.iterator.BoundJoinConversionIteration;
import org.eclipse.rdf4j.federated.evaluation.iterator.FilteringIteration;
import org.eclipse.rdf4j.federated.evaluation.iterator.GroupedCheckConversionIteration;
import org.eclipse.rdf4j.federated.evaluation.join.ControlledWorkerJoin;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.federated.util.QueryAlgebraUtil;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.repository.RepositoryException;

public class SailFederationEvalStrategy
extends FederationEvalStrategy {
    public SailFederationEvalStrategy(FederationContext federationContext) {
        super(federationContext);
    }

    @Override
    public CloseableIteration<BindingSet> evaluateBoundJoinStatementPattern(StatementTupleExpr stmt, List<BindingSet> bindings) throws QueryEvaluationException {
        if (bindings.size() == 1) {
            return this.evaluate(stmt, bindings.get(0));
        }
        FilterValueExpr filterExpr = null;
        if (stmt instanceof FilterTuple) {
            filterExpr = ((FilterTuple)((Object)stmt)).getFilterExpr();
        }
        Boolean isEvaluated = false;
        TupleExpr preparedQuery = QueryAlgebraUtil.selectQueryBoundUnion((StatementPattern)((Object)stmt), bindings, filterExpr, isEvaluated);
        CloseableIteration<BindingSet> result = this.evaluateAtStatementSources(preparedQuery, stmt.getStatementSources(), stmt.getQueryInfo());
        if (filterExpr != null && !isEvaluated.booleanValue()) {
            result = new BoundJoinConversionIteration(result, bindings);
            if (!(result = new FilteringIteration(filterExpr, result, this)).hasNext()) {
                return new EmptyIteration<BindingSet>();
            }
        } else {
            result = new BoundJoinConversionIteration(result, bindings);
        }
        return result;
    }

    @Override
    public CloseableIteration<BindingSet> evaluateGroupedCheck(CheckStatementPattern stmt, List<BindingSet> bindings) throws QueryEvaluationException {
        if (bindings.size() == 1) {
            return stmt.evaluate(bindings.get(0));
        }
        TupleExpr preparedQuery = QueryAlgebraUtil.selectQueryStringBoundCheck(stmt.getStatementPattern(), bindings);
        CloseableIteration<BindingSet> result = this.evaluateAtStatementSources(preparedQuery, stmt.getStatementSources(), stmt.getQueryInfo());
        return new GroupedCheckConversionIteration(result, bindings);
    }

    @Override
    public CloseableIteration<BindingSet> executeJoin(ControlledWorkerScheduler<BindingSet> joinScheduler, CloseableIteration<BindingSet> leftIter, TupleExpr rightArg, Set<String> joinVars, BindingSet bindings, QueryInfo queryInfo) throws QueryEvaluationException {
        ControlledWorkerJoin join = new ControlledWorkerJoin(joinScheduler, this, leftIter, rightArg, bindings, queryInfo);
        join.setJoinVars(joinVars);
        this.executor.execute(join);
        return join;
    }

    @Override
    public CloseableIteration<BindingSet> evaluateExclusiveGroup(ExclusiveGroup group, BindingSet bindings) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        TripleSource tripleSource = group.getOwnedEndpoint().getTripleSource();
        AtomicBoolean isEvaluated = new AtomicBoolean(false);
        TupleExpr preparedQuery = QueryAlgebraUtil.selectQuery(group, bindings, group.getFilterExpr(), isEvaluated);
        return tripleSource.getStatements(preparedQuery, bindings, isEvaluated.get() ? null : group.getFilterExpr(), group.getQueryInfo());
    }
}

