/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb.model;

import java.io.ObjectStreamException;
import java.util.Optional;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.base.AbstractLiteral;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.sail.lmdb.ValueStoreRevision;
import org.eclipse.rdf4j.sail.lmdb.model.LmdbValue;

public class LmdbLiteral
extends AbstractLiteral
implements LmdbValue {
    private static final long serialVersionUID = 5198968663650168819L;
    private String label;
    private String language;
    private IRI datatype;
    private CoreDatatype coreDatatype;
    private volatile ValueStoreRevision revision;
    private volatile long internalID;
    private volatile boolean initialized = false;

    public LmdbLiteral(ValueStoreRevision revision, long internalID) {
        this.setInternalID(internalID, revision);
        this.coreDatatype = null;
    }

    public LmdbLiteral(ValueStoreRevision revision, String label, long internalID) {
        this.label = label;
        this.coreDatatype = CoreDatatype.XSD.STRING;
        this.datatype = CoreDatatype.XSD.STRING.getIri();
        this.setInternalID(internalID, revision);
        this.initialized = true;
    }

    public LmdbLiteral(ValueStoreRevision revision, String label, String lang) {
        this(revision, label, lang, -1L);
    }

    public LmdbLiteral(ValueStoreRevision revision, String label, String lang, long internalID) {
        this.label = label;
        this.language = lang;
        this.coreDatatype = CoreDatatype.RDF.LANGSTRING;
        this.datatype = CoreDatatype.RDF.LANGSTRING.getIri();
        this.setInternalID(internalID, revision);
        this.initialized = true;
    }

    public LmdbLiteral(ValueStoreRevision revision, String label, IRI datatype) {
        this(revision, label, datatype, -1L);
    }

    public LmdbLiteral(ValueStoreRevision revision, String label, IRI datatype, CoreDatatype coreDatatype) {
        this(revision, label, datatype, coreDatatype, -1L);
    }

    public LmdbLiteral(ValueStoreRevision revision, String label, CoreDatatype datatype) {
        this(revision, label, datatype, -1L);
    }

    public LmdbLiteral(ValueStoreRevision revision, String label, IRI datatype, long internalID) {
        this.label = label;
        this.datatype = datatype;
        this.coreDatatype = null;
        this.setInternalID(internalID, revision);
        this.initialized = true;
    }

    public LmdbLiteral(ValueStoreRevision revision, String label, IRI datatype, CoreDatatype coreDatatype, long internalID) {
        this.label = label;
        assert (datatype != null);
        assert (coreDatatype != null);
        assert (coreDatatype == CoreDatatype.NONE || coreDatatype.getIri() == datatype);
        this.datatype = datatype;
        this.coreDatatype = coreDatatype;
        this.setInternalID(internalID, revision);
        this.initialized = true;
    }

    public LmdbLiteral(ValueStoreRevision revision, String label, CoreDatatype coreDatatype, long internalID) {
        this.label = label;
        this.coreDatatype = coreDatatype;
        this.datatype = coreDatatype.getIri();
        this.setInternalID(internalID, revision);
        this.initialized = true;
    }

    @Override
    public void setInternalID(long internalID, ValueStoreRevision revision) {
        this.internalID = internalID;
        this.revision = revision;
    }

    @Override
    public ValueStoreRevision getValueStoreRevision() {
        return this.revision;
    }

    @Override
    public long getInternalID() {
        return this.internalID;
    }

    public IRI getDatatype() {
        this.init();
        return this.datatype;
    }

    public CoreDatatype getCoreDatatype() {
        this.init();
        if (this.coreDatatype == null) {
            this.coreDatatype = CoreDatatype.from((IRI)this.datatype);
        }
        return this.coreDatatype;
    }

    public void setDatatype(IRI datatype) {
        this.datatype = datatype;
        this.coreDatatype = null;
    }

    public void setDatatype(CoreDatatype coreDatatype) {
        this.coreDatatype = coreDatatype;
        this.datatype = coreDatatype.getIri();
    }

    public String getLabel() {
        this.init();
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Optional<String> getLanguage() {
        this.init();
        return Optional.ofNullable(this.language);
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (!this.initialized) {
            LmdbLiteral lmdbLiteral = this;
            synchronized (lmdbLiteral) {
                if (!this.initialized) {
                    this.revision.resolveValue(this.internalID, this);
                }
                this.initialized = true;
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LmdbLiteral && this.internalID != -1L) {
            LmdbLiteral otherLmdbLiteral = (LmdbLiteral)o;
            if (otherLmdbLiteral.internalID != -1L && this.revision.equals(otherLmdbLiteral.revision)) {
                return this.internalID == otherLmdbLiteral.internalID;
            }
        }
        this.init();
        return super.equals(o);
    }

    public int hashCode() {
        this.init();
        return super.hashCode();
    }

    public String toString() {
        this.init();
        return super.toString();
    }

    protected Object writeReplace() throws ObjectStreamException {
        this.init();
        return this;
    }
}

