/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.QueryRoot;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryContext;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.AbstractFederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.EvaluationStatistics;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.TupleFunctionEvaluationStatistics;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.TupleFunctionEvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.QueryContextIteration;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.BindingAssignerOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.CompareOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.ConjunctiveConstraintSplitterOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.ConstantOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.DisjunctiveConstraintOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.FilterOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.IterativeEvaluationOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.OrderLimitOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.QueryJoinOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.QueryModelNormalizerOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.SameTermFilterOptimizer;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailConnectionListener;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.evaluation.SailTripleSource;
import org.eclipse.rdf4j.sail.evaluation.TupleFunctionEvaluationMode;
import org.eclipse.rdf4j.sail.helpers.NotifyingSailConnectionWrapper;
import org.eclipse.rdf4j.sail.lucene.BindingSetCollection;
import org.eclipse.rdf4j.sail.lucene.LuceneSail;
import org.eclipse.rdf4j.sail.lucene.LuceneSailBuffer;
import org.eclipse.rdf4j.sail.lucene.SearchIndex;
import org.eclipse.rdf4j.sail.lucene.SearchIndexQueryContextInitializer;
import org.eclipse.rdf4j.sail.lucene.SearchQueryEvaluator;
import org.eclipse.rdf4j.sail.lucene.SearchQueryInterpreter;
import org.eclipse.rdf4j.sail.lucene.TypeBacktraceMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneSailConnection
extends NotifyingSailConnectionWrapper {
    private final Logger logger = LoggerFactory.getLogger(LuceneSailConnection.class);
    private final SearchIndex luceneIndex;
    private final AbstractFederatedServiceResolver tupleFunctionServiceResolver;
    private final LuceneSail sail;
    private final LuceneSailBuffer buffer;
    protected final SailConnectionListener connectionListener = new SailConnectionListener(){

        @Override
        public void statementAdded(Statement statement) {
            if (statement.getObject() instanceof Literal) {
                if ((statement = LuceneSailConnection.this.sail.mapStatement(statement)) == null) {
                    return;
                }
                Literal literal = (Literal)statement.getObject();
                if (LuceneSailConnection.this.luceneIndex.accept(literal)) {
                    LuceneSailConnection.this.buffer.add(statement);
                }
            } else if (LuceneSailConnection.this.luceneIndex.isTypeStatement(statement)) {
                LuceneSailConnection.this.buffer.addTypeStatement(statement, LuceneSailConnection.this.luceneIndex.isIndexedTypeStatement(statement));
            }
        }

        @Override
        public void statementRemoved(Statement statement) {
            if (statement.getObject() instanceof Literal) {
                if ((statement = LuceneSailConnection.this.sail.mapStatement(statement)) == null) {
                    return;
                }
                Literal literal = (Literal)statement.getObject();
                if (LuceneSailConnection.this.luceneIndex.accept(literal)) {
                    LuceneSailConnection.this.buffer.remove(statement);
                }
            } else if (LuceneSailConnection.this.luceneIndex.isTypeStatement(statement)) {
                LuceneSailConnection.this.buffer.removeTypeStatement(statement);
            }
        }
    };
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public LuceneSailConnection(NotifyingSailConnection wrappedConnection, SearchIndex luceneIndex, LuceneSail sail) {
        super(wrappedConnection);
        this.luceneIndex = luceneIndex;
        this.sail = sail;
        this.buffer = new LuceneSailBuffer(luceneIndex.isTypeFilteringEnabled());
        if (sail.getEvaluationMode() == TupleFunctionEvaluationMode.SERVICE) {
            FederatedServiceResolver resolver = sail.getFederatedServiceResolver();
            if (!(resolver instanceof AbstractFederatedServiceResolver)) {
                throw new IllegalArgumentException("SERVICE EvaluationMode requires a FederatedServiceResolver that is an instance of " + AbstractFederatedServiceResolver.class.getName());
            }
            this.tupleFunctionServiceResolver = (AbstractFederatedServiceResolver)resolver;
        } else {
            this.tupleFunctionServiceResolver = null;
        }
        wrappedConnection.addConnectionListener(this.connectionListener);
    }

    @Override
    public synchronized void addStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        super.addStatement(subj, pred, obj, contexts);
    }

    @Override
    public void close() throws SailException {
        if (this.closed.compareAndSet(false, true)) {
            super.close();
        }
    }

    @Override
    public synchronized void clear(Resource ... contexts) throws SailException {
        this.getWrappedConnection().removeConnectionListener(this.connectionListener);
        try {
            super.clear(contexts);
            this.buffer.clear(contexts);
        }
        finally {
            this.getWrappedConnection().addConnectionListener(this.connectionListener);
        }
    }

    @Override
    public void begin() throws SailException {
        super.begin();
        this.buffer.reset();
        try {
            this.luceneIndex.begin();
        }
        catch (IOException e) {
            throw new SailException(e);
        }
    }

    @Override
    public void commit() throws SailException {
        super.commit();
        this.logger.debug("Committing Lucene transaction with {} operations.", (Object)this.buffer.operations().size());
        try {
            this.buffer.optimize();
            Iterator<LuceneSailBuffer.Operation> i = this.buffer.operations().iterator();
            while (i.hasNext()) {
                LuceneSailBuffer.Operation op = i.next();
                if (op instanceof LuceneSailBuffer.AddRemoveOperation) {
                    LuceneSailBuffer.AddRemoveOperation addremove = (LuceneSailBuffer.AddRemoveOperation)op;
                    this.addRemoveStatements(addremove);
                } else if (op instanceof LuceneSailBuffer.ClearContextOperation) {
                    this.clearContexts(((LuceneSailBuffer.ClearContextOperation)op).getContexts());
                } else if (op instanceof LuceneSailBuffer.ClearOperation) {
                    this.logger.debug("clearing index...");
                    this.luceneIndex.clear();
                } else {
                    throw new SailException("Cannot interpret operation " + op + " of type " + op.getClass().getName());
                }
                i.remove();
            }
        }
        catch (Exception e) {
            this.logger.error("Committing operations in lucenesail, encountered exception " + e + ". Only some operations were stored, " + this.buffer.operations().size() + " operations are discarded. Lucene Index is now corrupt.", (Throwable)e);
            throw new SailException(e);
        }
        finally {
            this.buffer.reset();
        }
    }

    private void addRemoveStatements(LuceneSailBuffer.AddRemoveOperation op) throws IOException, SailException {
        this.luceneIndex.begin();
        try {
            this.completeAddRemoveOperationWithType(op);
            HashSet<Statement> toAdd = op.getAdded();
            HashSet<Statement> toRemove = op.getRemoved();
            this.logger.debug("indexing {}/removing {} statements...", (Object)toAdd.size(), (Object)toRemove.size());
            this.luceneIndex.addRemoveStatements(toAdd, toRemove);
            this.luceneIndex.commit();
        }
        catch (IOException | SailException e) {
            this.logger.error("Rolling back", (Throwable)e);
            this.luceneIndex.rollback();
            throw e;
        }
    }

    private void completeAddRemoveOperationWithType(LuceneSailBuffer.AddRemoveOperation op) throws SailException {
        if (!this.luceneIndex.isTypeFilteringEnabled()) {
            return;
        }
        TypeBacktraceMode backtraceMode = this.sail.getIndexBacktraceMode();
        HashSet<Statement> toAdd = op.getAdded();
        HashSet<Statement> toRemove = op.getRemoved();
        Map<Resource, Boolean> typeAdd = op.getTypeAdded();
        Set<Resource> typeRemove = op.getTypeRemoved();
        HashMap<Resource, Boolean> typeValue = new HashMap<Resource, Boolean>(typeAdd);
        Map<IRI, Set<IRI>> mapping = this.luceneIndex.getIndexedTypeMapping();
        Iterator it = toAdd.iterator();
        while (it.hasNext()) {
            Statement statement = (Statement)it.next();
            Boolean addValue = (Boolean)typeValue.get(statement.getSubject());
            if (addValue == null) {
                addValue = typeAdd.get(statement.getSubject());
                if (addValue != null) {
                    typeValue.put(statement.getSubject(), addValue);
                } else {
                    for (IRI predicate : mapping.keySet()) {
                        Set<IRI> objects = mapping.get(predicate);
                        CloseableIteration<? extends Statement> statements = this.getStatements(statement.getSubject(), predicate, null, false, statement.getContext());
                        try {
                            if (!statements.hasNext()) continue;
                            Value object = ((Statement)statements.next()).getObject();
                            addValue = object.isIRI() && objects.contains((IRI)object);
                            typeValue.put(statement.getSubject(), addValue);
                            break;
                        }
                        finally {
                            if (statements == null) continue;
                            statements.close();
                        }
                    }
                }
            }
            if (addValue != null && addValue.booleanValue()) continue;
            it.remove();
        }
        if (backtraceMode.shouldBackTraceInsert()) {
            for (Map.Entry entry : typeAdd.entrySet()) {
                if (!((Boolean)entry.getValue()).booleanValue()) continue;
                Resource subject = (Resource)entry.getKey();
                try (CloseableIteration<? extends Statement> statements = this.getStatements(subject, null, null, false, new Resource[0]);){
                    while (statements.hasNext()) {
                        Statement statement = (Statement)statements.next();
                        if ((statement = this.sail.mapStatement(statement)) == null) continue;
                        toAdd.add(statement);
                    }
                }
            }
        }
        if (backtraceMode.shouldBackTraceDelete()) {
            for (Resource resource : typeRemove) {
                try (CloseableIteration<? extends Statement> statements = this.getStatements(resource, null, null, false, new Resource[0]);){
                    while (statements.hasNext()) {
                        Statement statement = (Statement)statements.next();
                        if ((statement = this.sail.mapStatement(statement)) == null) continue;
                        toRemove.add(statement);
                    }
                }
            }
        }
    }

    private void clearContexts(Resource ... contexts) throws IOException {
        this.logger.debug("clearing contexts...");
        this.luceneIndex.begin();
        try {
            this.luceneIndex.clearContexts(contexts);
            this.luceneIndex.commit();
        }
        catch (IOException e) {
            this.logger.error("Rolling back", (Throwable)e);
            this.luceneIndex.rollback();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CloseableIteration<? extends BindingSet> evaluate(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        CloseableIteration<? extends BindingSet> iter;
        QueryContext qctx = new QueryContext();
        SearchIndexQueryContextInitializer.init(qctx, this.luceneIndex);
        qctx.begin();
        try {
            iter = this.evaluateInternal(tupleExpr, dataset, bindings, includeInferred);
        }
        finally {
            qctx.end();
        }
        return new QueryContextIteration(iter, qctx);
    }

    private CloseableIteration<? extends BindingSet> evaluateInternal(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        if (!((tupleExpr = tupleExpr.clone()) instanceof QueryRoot)) {
            tupleExpr = new QueryRoot(tupleExpr);
        }
        new BindingAssignerOptimizer().optimize(tupleExpr, dataset, bindings);
        ArrayList<SearchQueryEvaluator> queries = new ArrayList<SearchQueryEvaluator>();
        for (SearchQueryInterpreter interpreter : this.sail.getSearchQueryInterpreters()) {
            interpreter.process(tupleExpr, bindings, queries);
        }
        if (!queries.isEmpty()) {
            this.evaluateLuceneQueries(queries);
        }
        if (this.sail.getEvaluationMode() == TupleFunctionEvaluationMode.TRIPLE_SOURCE) {
            ValueFactory vf = this.sail.getValueFactory();
            SailTripleSource tripleSource = new SailTripleSource(this, includeInferred, vf);
            TupleFunctionEvaluationStrategy strategy = new TupleFunctionEvaluationStrategy((TripleSource)tripleSource, dataset, this.sail.getFederatedServiceResolver(), this.sail.getTupleFunctionRegistry());
            new BindingAssignerOptimizer().optimize(tupleExpr, dataset, bindings);
            new ConstantOptimizer(strategy).optimize(tupleExpr, dataset, bindings);
            new CompareOptimizer().optimize(tupleExpr, dataset, bindings);
            new ConjunctiveConstraintSplitterOptimizer().optimize(tupleExpr, dataset, bindings);
            new DisjunctiveConstraintOptimizer().optimize(tupleExpr, dataset, bindings);
            new SameTermFilterOptimizer().optimize(tupleExpr, dataset, bindings);
            new QueryModelNormalizerOptimizer().optimize(tupleExpr, dataset, bindings);
            new QueryJoinOptimizer((EvaluationStatistics)new TupleFunctionEvaluationStatistics(), tripleSource).optimize(tupleExpr, dataset, bindings);
            new IterativeEvaluationOptimizer().optimize(tupleExpr, dataset, bindings);
            new FilterOptimizer().optimize(tupleExpr, dataset, bindings);
            new OrderLimitOptimizer().optimize(tupleExpr, dataset, bindings);
            this.logger.trace("Optimized query model:\n{}", (Object)tupleExpr);
            try {
                return strategy.evaluate(tupleExpr, bindings);
            }
            catch (QueryEvaluationException e) {
                throw new SailException(e);
            }
        }
        return super.evaluate(tupleExpr, dataset, bindings, includeInferred);
    }

    private void evaluateLuceneQueries(Collection<SearchQueryEvaluator> queries) throws SailException {
        if (this.closed.get()) {
            throw new SailException("Sail has been closed already");
        }
        for (SearchQueryEvaluator query : queries) {
            Collection<BindingSet> bindingSets = this.luceneIndex.evaluate(query);
            BindingSetAssignment bsa = new BindingSetAssignment();
            if (bindingSets != null && !bindingSets.isEmpty()) {
                bsa.setBindingSets(bindingSets);
                if (bindingSets instanceof BindingSetCollection) {
                    bsa.setBindingNames(((BindingSetCollection)bindingSets).getBindingNames());
                }
            }
            query.replaceQueryPatternsWithResults(bsa);
        }
    }

    @Override
    public synchronized void removeStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        super.removeStatements(subj, pred, obj, contexts);
    }

    @Override
    public void rollback() throws SailException {
        super.rollback();
        this.buffer.reset();
        try {
            this.luceneIndex.rollback();
        }
        catch (IOException e) {
            throw new SailException(e);
        }
    }
}

