/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.impl.SimpleBinding;

public class SingletonBindingSet
implements BindingSet {
    private static final long serialVersionUID = 6083219124988052038L;
    private final String name;
    private final Value value;
    private Binding cachedBinding;
    private int cachedHashCode = 0;

    public SingletonBindingSet(String bindingName, Value value) {
        this.name = bindingName;
        this.value = value;
    }

    public Iterator<Binding> iterator() {
        if (this.cachedBinding == null) {
            this.cachedBinding = new SimpleBinding(this.name, this.value);
        }
        return new SingleIterator(this.cachedBinding);
    }

    public Set<String> getBindingNames() {
        return Set.of(this.name);
    }

    public Binding getBinding(String bindingName) {
        if (this.name.equals(bindingName)) {
            if (this.cachedBinding == null) {
                this.cachedBinding = new SimpleBinding(this.name, this.value);
            }
            return this.cachedBinding;
        }
        return null;
    }

    public boolean hasBinding(String bindingName) {
        return this.name.equals(bindingName);
    }

    public Value getValue(String bindingName) {
        if (this.name.equals(bindingName)) {
            return this.value;
        }
        return null;
    }

    public int size() {
        return 1;
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            this.cachedHashCode = this.name.hashCode() ^ this.value.hashCode();
        }
        return this.cachedHashCode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BindingSet)) {
            return false;
        }
        BindingSet that = (BindingSet)other;
        if (this.size() != that.size()) {
            return false;
        }
        if (this.size() == 1) {
            Binding binding = this.iterator().next();
            Binding thatBinding = (Binding)that.iterator().next();
            return binding.getName().equals(thatBinding.getName()) && binding.getValue().equals(thatBinding.getValue());
        }
        for (Binding binding : that) {
            Value ownValue = this.getValue(binding.getName());
            if (binding.getValue().equals(ownValue)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32 * this.size());
        sb.append('[');
        Iterator<Binding> iter = this.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().toString());
            if (!iter.hasNext()) continue;
            sb.append(';');
        }
        sb.append(']');
        return sb.toString();
    }

    public boolean isEmpty() {
        return false;
    }

    private static class SingleIterator
    implements Iterator<Binding> {
        private Binding next;

        public SingleIterator(Binding next) {
            this.next = next;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Binding next() {
            Binding temp = this.next;
            this.next = null;
            return temp;
        }
    }
}

