/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.iterator;

import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.federated.algebra.FilterValueExpr;
import org.eclipse.rdf4j.federated.evaluation.FederationEvalStrategy;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilteringInsertBindingsIteration
implements CloseableIteration<BindingSet> {
    private static final Logger log = LoggerFactory.getLogger(FilteringInsertBindingsIteration.class);
    private final BindingSet bindings;
    private final FilterValueExpr filterExpr;
    private final FederationEvalStrategy strategy;
    private final CloseableIteration<? extends BindingSet> wrappedIter;
    private BindingSet nextElement;
    private boolean closed = false;

    public FilteringInsertBindingsIteration(FilterValueExpr filterExpr, BindingSet bindings, CloseableIteration<BindingSet> iter, FederationEvalStrategy strategy) throws QueryEvaluationException {
        assert (iter != null);
        this.wrappedIter = iter;
        this.filterExpr = filterExpr;
        this.strategy = strategy;
        this.bindings = bindings;
    }

    @Override
    public BindingSet next() throws QueryEvaluationException {
        if (this.isClosed()) {
            throw new NoSuchElementException("The iteration has been closed.");
        }
        this.findNextElement();
        BindingSet result = this.nextElement;
        if (result == null) {
            this.close();
            throw new NoSuchElementException("The iteration has been closed.");
        }
        this.nextElement = null;
        BindingSet res1 = result;
        BindingSet next = res1;
        QueryBindingSet res = new QueryBindingSet(this.bindings.size() + next.size());
        res.addAll(this.bindings);
        res.addAll(next);
        return res;
    }

    protected boolean accept(BindingSet bindings) throws QueryEvaluationException {
        try {
            return this.strategy.isTrue(this.filterExpr, bindings);
        }
        catch (ValueExprEvaluationException e) {
            log.warn("Failed to evaluate filter expr: " + e.getMessage());
            return false;
        }
    }

    @Override
    public boolean hasNext() {
        boolean result;
        if (this.isClosed()) {
            return false;
        }
        this.findNextElement();
        boolean bl = result = this.nextElement != null;
        if (!result) {
            this.close();
        }
        return result;
    }

    private void findNextElement() {
        if (this.nextElement != null) {
            return;
        }
        try {
            if (!this.isClosed()) {
                if (Thread.currentThread().isInterrupted()) {
                    this.close();
                    return;
                }
                boolean result = this.wrappedIter.hasNext();
                if (!result) {
                    this.close();
                    return;
                }
            }
            while (this.nextElement == null && this.wrappedIter.hasNext()) {
                BindingSet result;
                if (Thread.currentThread().isInterrupted()) {
                    this.close();
                    return;
                }
                try {
                    result = (BindingSet)this.wrappedIter.next();
                }
                catch (NoSuchElementException e) {
                    this.close();
                    throw e;
                }
                BindingSet candidate = result;
                if (!this.accept(candidate)) continue;
                this.nextElement = candidate;
            }
        }
        finally {
            if (this.isClosed()) {
                this.nextElement = null;
            }
        }
    }

    @Override
    public void remove() {
        if (this.isClosed()) {
            throw new IllegalStateException("The iteration has been closed.");
        }
        if (Thread.currentThread().isInterrupted()) {
            this.close();
            throw new IllegalStateException("The iteration has been interrupted.");
        }
        try {
            this.wrappedIter.remove();
        }
        catch (IllegalStateException e) {
            this.close();
            throw e;
        }
    }

    private boolean isClosed() {
        return this.closed;
    }

    @Override
    public final void close() {
        if (!this.closed) {
            this.closed = true;
            this.wrappedIter.close();
        }
    }
}

