/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld.uri;

public class PartiallyImplementedUriValidator {
    private static final String ALPHA_STRING = "abcdefghijklmnopqrstuvwxyz";
    private static final String ALPHA_STRING_UPPER_CASE = "abcdefghijklmnopqrstuvwxyz".toUpperCase();
    private static final String DIGIT_STRING = "0123456789";
    private static final String PCHAR_EXCEPT_PCT_ENDODED_STRING = ALPHA_STRING_UPPER_CASE + "abcdefghijklmnopqrstuvwxyz0123456789-._~!$&'()*+,;=:@";
    private static final boolean[] ALPHA = PartiallyImplementedUriValidator.toBooleanArray("abcdefghijklmnopqrstuvwxyz");
    private static final boolean[] COLON = PartiallyImplementedUriValidator.toBooleanArray(":");
    private static final boolean[] SLASH = PartiallyImplementedUriValidator.toBooleanArray("/");
    private static final boolean[] QUERY_START = PartiallyImplementedUriValidator.toBooleanArray("?");
    private static final boolean[] FRAGMENT_START = PartiallyImplementedUriValidator.toBooleanArray("#");
    private static final boolean[] PCT_ENCODED_START = PartiallyImplementedUriValidator.toBooleanArray("%");
    private static final boolean[] HEXDIG = PartiallyImplementedUriValidator.toBooleanArray("0123456789abcdefABCDEF");
    private static final boolean[] PCHAR_EXCEPT_PCT_ENCODED = PartiallyImplementedUriValidator.toBooleanArray(PCHAR_EXCEPT_PCT_ENDODED_STRING);
    private static final boolean[] FRAGMENT = PartiallyImplementedUriValidator.toBooleanArray(PCHAR_EXCEPT_PCT_ENDODED_STRING + "/?");
    private static final boolean[] QUERY = PartiallyImplementedUriValidator.toBooleanArray(PCHAR_EXCEPT_PCT_ENDODED_STRING + "/?");
    private static final boolean[] SCHEME = PartiallyImplementedUriValidator.toBooleanArray("abcdefghijklmnopqrstuvwxyz0123456789+-.");
    private static final boolean[] UNRESERVED = PartiallyImplementedUriValidator.toBooleanArray("abcdefghijklmnopqrstuvwxyz0123456789-._~");

    private static boolean[] toBooleanArray(String s) {
        boolean[] result = new boolean[256];
        s.codePoints().forEach(c -> {
            result[c] = true;
        });
        return result;
    }

    public static boolean isDefinitivelyValidAbsoluteUri(String uri) {
        int index;
        int codePointCount;
        block20: {
            boolean doubleHex;
            block19: {
                block18: {
                    boolean valid;
                    if (uri == null || uri.length() == 0) {
                        return false;
                    }
                    codePointCount = uri.codePointCount(0, uri.length());
                    index = 0;
                    if (!(valid = PartiallyImplementedUriValidator.matches(uri, codePointCount, index++, ALPHA))) {
                        return false;
                    }
                    while (PartiallyImplementedUriValidator.matches(uri, codePointCount, index, SCHEME)) {
                        ++index;
                    }
                    if (!(valid = PartiallyImplementedUriValidator.matches(uri, codePointCount, index++, COLON))) {
                        return false;
                    }
                    if (PartiallyImplementedUriValidator.matches(uri, codePointCount, index, SLASH) && PartiallyImplementedUriValidator.matches(uri, codePointCount, index + 1, SLASH)) {
                        index += 2;
                        if (!(valid = PartiallyImplementedUriValidator.matches(uri, codePointCount, index++, UNRESERVED))) {
                            return false;
                        }
                        while (PartiallyImplementedUriValidator.matches(uri, codePointCount, index, UNRESERVED)) {
                            ++index;
                        }
                    }
                    if (!PartiallyImplementedUriValidator.matches(uri, codePointCount, index, PCHAR_EXCEPT_PCT_ENCODED) && !PartiallyImplementedUriValidator.matches(uri, codePointCount, index, SLASH)) {
                        return false;
                    }
                    if (PartiallyImplementedUriValidator.matches(uri, codePointCount, ++index, SLASH)) {
                        return false;
                    }
                    while (true) {
                        if (PartiallyImplementedUriValidator.matches(uri, codePointCount, index, PCHAR_EXCEPT_PCT_ENCODED)) {
                            ++index;
                            continue;
                        }
                        if (PartiallyImplementedUriValidator.matches(uri, codePointCount, index, SLASH)) {
                            ++index;
                            continue;
                        }
                        if (!PartiallyImplementedUriValidator.matches(uri, codePointCount, index, PCT_ENCODED_START)) break block18;
                        int n = ++index;
                        ++index;
                        doubleHex = PartiallyImplementedUriValidator.matches(uri, codePointCount, n, HEXDIG) && PartiallyImplementedUriValidator.matches(uri, codePointCount, index++, HEXDIG);
                        if (!doubleHex) break;
                    }
                    return false;
                }
                if (PartiallyImplementedUriValidator.matches(uri, codePointCount, index, QUERY_START)) {
                    ++index;
                    while (true) {
                        if (PartiallyImplementedUriValidator.matches(uri, codePointCount, index, QUERY)) {
                            ++index;
                            continue;
                        }
                        if (!PartiallyImplementedUriValidator.matches(uri, codePointCount, index, PCT_ENCODED_START)) break block19;
                        int n = ++index;
                        ++index;
                        doubleHex = PartiallyImplementedUriValidator.matches(uri, codePointCount, n, HEXDIG) && PartiallyImplementedUriValidator.matches(uri, codePointCount, index++, HEXDIG);
                        if (!doubleHex) break;
                    }
                    return false;
                }
            }
            if (PartiallyImplementedUriValidator.matches(uri, codePointCount, index, FRAGMENT_START)) {
                ++index;
                while (true) {
                    if (PartiallyImplementedUriValidator.matches(uri, codePointCount, index, FRAGMENT)) {
                        ++index;
                        continue;
                    }
                    if (!PartiallyImplementedUriValidator.matches(uri, codePointCount, index, PCT_ENCODED_START)) break block20;
                    int n = ++index;
                    ++index;
                    doubleHex = PartiallyImplementedUriValidator.matches(uri, codePointCount, n, HEXDIG) && PartiallyImplementedUriValidator.matches(uri, codePointCount, index++, HEXDIG);
                    if (!doubleHex) break;
                }
                return false;
            }
        }
        return PartiallyImplementedUriValidator.noMoreCodepoints(codePointCount, index);
    }

    private static boolean noMoreCodepoints(int codePointCount, int index) {
        return index == codePointCount;
    }

    private static boolean matches(String s, int codePointCount, int i, boolean[] lookupArray) {
        if (i >= codePointCount) {
            return false;
        }
        if (s.codePointAt(i) >= lookupArray.length) {
            return false;
        }
        boolean valid = lookupArray[s.codePointAt(i)];
        return valid;
    }
}

