/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractSimpleQueryModelVisitor;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlQueryParserCache;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.SingletonBindingSet;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

public abstract class AbstractBulkJoinPlanNode
implements PlanNode {
    public static final String BINDING_NAME = "a";
    protected static final int BULK_SIZE = 1000;
    private StackTraceElement[] stackTrace;
    protected Function<BindingSet, ValidationTuple> mapper;
    ValidationExecutionLogger validationExecutionLogger;

    TupleExpr parseQuery(String query) {
        query = query.replace("#VALUES_INJECTION_POINT#", "\nVALUES (?a) {}\n");
        String completeQuery = "select * where {\nVALUES (?a) {}\n" + query + "\n}";
        return SparqlQueryParserCache.get(completeQuery);
    }

    void runQuery(Collection<ValidationTuple> left, ArrayDeque<ValidationTuple> right, SailConnection connection, TupleExpr parsedQuery, Dataset dataset, Resource[] dataGraph, boolean skipBasedOnPreviousConnection, SailConnection previousStateConnection) {
        List<BindingSet> newBindindingSet = this.buildBindingSets(left, connection, skipBasedOnPreviousConnection, previousStateConnection, dataGraph);
        if (!newBindindingSet.isEmpty()) {
            this.updateQuery(parsedQuery, newBindindingSet);
            this.executeQuery(right, connection, dataset, parsedQuery);
        }
    }

    private void executeQuery(ArrayDeque<ValidationTuple> right, SailConnection connection, Dataset dataset, TupleExpr parsedQuery) {
        try (Stream<? extends BindingSet> stream = connection.evaluate(parsedQuery, dataset, EmptyBindingSet.getInstance(), true).stream();){
            stream.map(this.mapper).sorted(ValidationTuple::compareActiveTarget).forEachOrdered(right::addFirst);
        }
    }

    private void updateQuery(TupleExpr parsedQuery, final List<BindingSet> newBindindingSet) {
        parsedQuery.visit(new AbstractSimpleQueryModelVisitor<RuntimeException>(false){

            @Override
            public void meet(BindingSetAssignment node) {
                Set<String> bindingNames = node.getBindingNames();
                if (bindingNames.size() == 1 && bindingNames.contains(AbstractBulkJoinPlanNode.BINDING_NAME)) {
                    node.setBindingSets(newBindindingSet);
                }
                super.meet(node);
            }
        });
    }

    private List<BindingSet> buildBindingSets(Collection<ValidationTuple> left, SailConnection connection, boolean skipBasedOnPreviousConnection, SailConnection previousStateConnection, Resource[] dataGraph) {
        return left.stream().filter(tuple -> {
            boolean hasStatement;
            if (!skipBasedOnPreviousConnection) {
                return true;
            }
            if (!tuple.getActiveTarget().isResource()) {
                hasStatement = previousStateConnection.hasStatement(null, null, tuple.getActiveTarget(), true, dataGraph);
            } else {
                boolean bl = hasStatement = previousStateConnection.hasStatement((Resource)tuple.getActiveTarget(), null, null, true, dataGraph) || previousStateConnection.hasStatement(null, null, tuple.getActiveTarget(), true, dataGraph);
            }
            if (!hasStatement && this.validationExecutionLogger.isEnabled()) {
                this.validationExecutionLogger.log(this.depth(), this.getClass().getSimpleName() + ":IgnoredDueToPreviousStateConnection", (ValidationTuple)tuple, this, this.getId(), null);
            }
            return hasStatement;
        }).map(ValidationTuple::getActiveTarget).map(r -> new SingletonBindingSet(BINDING_NAME, (Value)r)).collect(Collectors.toList());
    }

    @Override
    public boolean producesSorted() {
        return true;
    }

    @Override
    public boolean requiresSorted() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractBulkJoinPlanNode that = (AbstractBulkJoinPlanNode)o;
        return this.mapper.equals(that.mapper);
    }

    public int hashCode() {
        return Objects.hash(this.mapper);
    }
}

