/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryValueEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryEvaluationContext;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtility;

public class LeftJoinIterator
extends LookAheadIteration<BindingSet> {
    private final Set<String> scopeBindingNames;
    private final CloseableIteration<BindingSet> leftIter;
    private CloseableIteration<BindingSet> rightIter;
    private final QueryEvaluationStep prepareRightArg;
    private final QueryValueEvaluationStep joinCondition;

    public LeftJoinIterator(EvaluationStrategy strategy, LeftJoin join, BindingSet bindings, QueryEvaluationContext context) throws QueryEvaluationException {
        this.scopeBindingNames = join.getBindingNames();
        this.leftIter = strategy.evaluate(join.getLeftArg(), bindings);
        this.rightIter = null;
        this.prepareRightArg = strategy.precompile(join.getRightArg(), context);
        join.setAlgorithm((CloseableIteration)this);
        ValueExpr condition = join.getCondition();
        this.joinCondition = condition == null ? null : strategy.precompile(condition, context);
    }

    public LeftJoinIterator(QueryEvaluationStep left, QueryEvaluationStep right, QueryValueEvaluationStep joinCondition, BindingSet bindings, Set<String> scopeBindingNamse) throws QueryEvaluationException {
        this.scopeBindingNames = scopeBindingNamse;
        this.leftIter = left.evaluate(bindings);
        this.rightIter = null;
        this.prepareRightArg = right;
        this.joinCondition = joinCondition;
    }

    public LeftJoinIterator(CloseableIteration<BindingSet> leftIter, QueryEvaluationStep prepareRightArg, QueryValueEvaluationStep joinCondition, Set<String> scopeBindingNamse) {
        this.scopeBindingNames = scopeBindingNamse;
        this.leftIter = leftIter;
        this.rightIter = null;
        this.prepareRightArg = prepareRightArg;
        this.joinCondition = joinCondition;
    }

    public static CloseableIteration<BindingSet> getInstance(QueryEvaluationStep left, QueryEvaluationStep prepareRightArg, QueryValueEvaluationStep joinCondition, BindingSet bindings, Set<String> scopeBindingNamse) {
        CloseableIteration<BindingSet> leftIter = left.evaluate(bindings);
        if (leftIter == QueryEvaluationStep.EMPTY_ITERATION) {
            return leftIter;
        }
        return new LeftJoinIterator(leftIter, prepareRightArg, joinCondition, scopeBindingNamse);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected BindingSet getNextElement() throws QueryEvaluationException {
        try {
            CloseableIteration<BindingSet> nextRightIter = this.rightIter;
            if (nextRightIter != null && !nextRightIter.hasNext() && !this.leftIter.hasNext()) return null;
            BindingSet leftBindings = null;
            if (nextRightIter == null) {
                if (!this.leftIter.hasNext()) return null;
                leftBindings = (BindingSet)this.leftIter.next();
                nextRightIter = this.rightIter = this.prepareRightArg.evaluate(leftBindings);
            } else if (!nextRightIter.hasNext()) {
                leftBindings = (BindingSet)this.leftIter.next();
                nextRightIter.close();
                nextRightIter = this.rightIter = this.prepareRightArg.evaluate(leftBindings);
            }
            if (nextRightIter == QueryEvaluationStep.EMPTY_ITERATION) {
                this.rightIter = null;
                return leftBindings;
            }
            while (nextRightIter.hasNext()) {
                BindingSet rightBindings = (BindingSet)nextRightIter.next();
                try {
                    if (this.joinCondition == null) {
                        return rightBindings;
                    }
                    QueryBindingSet scopeBindings = new QueryBindingSet(this.scopeBindingNames.size());
                    for (String scopeBindingName : this.scopeBindingNames) {
                        Binding binding = rightBindings.getBinding(scopeBindingName);
                        if (binding == null) continue;
                        scopeBindings.addBinding(binding);
                    }
                    if (!this.isTrue(this.joinCondition, scopeBindings)) continue;
                    return rightBindings;
                }
                catch (ValueExprEvaluationException valueExprEvaluationException) {
                }
            }
            if (leftBindings == null) return null;
            this.rightIter = null;
            return leftBindings;
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return null;
    }

    private boolean isTrue(QueryValueEvaluationStep expr, QueryBindingSet bindings) {
        Value value = expr.evaluate((BindingSet)bindings);
        return QueryEvaluationUtility.getEffectiveBooleanValue(value).orElse(false);
    }

    protected void handleClose() throws QueryEvaluationException {
        try {
            this.leftIter.close();
        }
        finally {
            if (this.rightIter != null) {
                this.rightIter.close();
            }
        }
    }
}

