/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld.api;

import jakarta.json.JsonObject;
import jakarta.json.JsonStructure;
import java.net.URI;
import no.hasmac.jsonld.JsonLdEmbed;
import no.hasmac.jsonld.JsonLdError;
import no.hasmac.jsonld.JsonLdOptions;
import no.hasmac.jsonld.JsonLdVersion;
import no.hasmac.jsonld.api.CommonApi;
import no.hasmac.jsonld.api.ContextApi;
import no.hasmac.jsonld.api.LoaderApi;
import no.hasmac.jsonld.document.Document;
import no.hasmac.jsonld.document.JsonDocument;
import no.hasmac.jsonld.loader.DocumentLoader;
import no.hasmac.jsonld.processor.FramingProcessor;
import no.hasmac.jsonld.uri.UriUtils;

public final class FramingApi
implements CommonApi<FramingApi>,
LoaderApi<FramingApi>,
ContextApi<FramingApi> {
    private final Document document;
    private final URI documentUri;
    private final Document frame;
    private final URI frameUri;
    private JsonLdOptions options;

    public FramingApi(URI documentUri, URI frameUri) {
        this.document = null;
        this.documentUri = documentUri;
        this.frame = null;
        this.frameUri = frameUri;
        this.options = new JsonLdOptions();
    }

    public FramingApi(Document document, Document frame) {
        this.document = document;
        this.documentUri = null;
        this.frame = frame;
        this.frameUri = null;
        this.options = new JsonLdOptions();
    }

    public FramingApi(Document document, URI frameUri) {
        this.document = document;
        this.documentUri = null;
        this.frame = null;
        this.frameUri = frameUri;
        this.options = new JsonLdOptions();
    }

    public FramingApi(URI documentUri, Document frame) {
        this.document = null;
        this.documentUri = documentUri;
        this.frame = frame;
        this.frameUri = null;
        this.options = new JsonLdOptions();
    }

    @Override
    public FramingApi options(JsonLdOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("Parameter 'options' is null.");
        }
        this.options = options;
        return this;
    }

    @Override
    public FramingApi context(URI contextUri) {
        this.options.setExpandContext(contextUri);
        return this;
    }

    @Override
    public FramingApi context(String contextLocation) {
        URI contextUri = null;
        if (contextLocation != null && (contextUri = UriUtils.create(contextLocation)) == null) {
            throw new IllegalArgumentException("Context location must be valid URI or null but is [" + contextLocation + ".");
        }
        return this.context(contextUri);
    }

    @Override
    public FramingApi context(JsonStructure context) {
        this.options.setExpandContext(context != null ? JsonDocument.of(context) : null);
        return this;
    }

    @Override
    public FramingApi context(Document context) {
        this.options.setExpandContext(context);
        return this;
    }

    @Override
    public FramingApi mode(JsonLdVersion processingMode) {
        this.options.setProcessingMode(processingMode);
        return this;
    }

    @Override
    public FramingApi base(URI baseUri) {
        this.options.setBase(baseUri);
        return this;
    }

    @Override
    public FramingApi loader(DocumentLoader loader) {
        this.options.setDocumentLoader(loader);
        return this;
    }

    @Override
    public FramingApi ordered(boolean enable) {
        this.options.setOrdered(enable);
        return this;
    }

    public FramingApi embed(JsonLdEmbed value) {
        this.options.setEmbed(value);
        return this;
    }

    public FramingApi explicit(boolean enable) {
        this.options.setExplicit(enable);
        return this;
    }

    public FramingApi explicit() {
        return this.explicit(true);
    }

    public FramingApi omitDefault(boolean enable) {
        this.options.setOmitDefault(enable);
        return this;
    }

    public FramingApi omitDefault() {
        return this.omitDefault(true);
    }

    public FramingApi omitGraph(boolean enable) {
        this.options.setOmitGraph(enable);
        return this;
    }

    public FramingApi omitGraph() {
        return this.omitGraph(true);
    }

    public FramingApi requiredAll(boolean enable) {
        this.options.setRequiredAll(enable);
        return this;
    }

    public FramingApi requiredAll() {
        return this.requiredAll(true);
    }

    public JsonObject get() throws JsonLdError {
        if (this.document != null) {
            if (this.frame != null) {
                return FramingProcessor.frame(this.document, this.frame, this.options);
            }
            if (this.frameUri != null) {
                return FramingProcessor.frame(this.document, this.frameUri, this.options);
            }
        }
        if (this.documentUri != null) {
            if (this.frame != null) {
                return FramingProcessor.frame(this.documentUri, this.frame, this.options);
            }
            if (this.frameUri != null) {
                return FramingProcessor.frame(this.documentUri, this.frameUri, this.options);
            }
        }
        throw new IllegalStateException();
    }
}

