/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra;

import java.util.Objects;
import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.UpdateExpr;
import org.eclipse.rdf4j.query.algebra.ValueConstant;

public class Copy
extends AbstractQueryModelNode
implements UpdateExpr {
    private ValueConstant sourceGraph;
    private ValueConstant destinationGraph;
    private boolean silent;

    public Copy() {
    }

    public Copy(ValueConstant graph) {
        this.setSourceGraph(graph);
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        if (this.sourceGraph != null) {
            this.sourceGraph.visit(visitor);
        }
        if (this.destinationGraph != null) {
            this.destinationGraph.visit(visitor);
        }
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        if (this.sourceGraph == current) {
            this.setSourceGraph((ValueConstant)replacement);
        } else if (this.destinationGraph == current) {
            this.setDestinationGraph((ValueConstant)replacement);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Copy) {
            Copy o = (Copy)other;
            return this.silent == o.silent && Objects.equals(this.sourceGraph, o.sourceGraph) && Objects.equals(this.destinationGraph, o.destinationGraph);
        }
        return false;
    }

    public int hashCode() {
        int result;
        int n = result = this.silent ? 1 : 0;
        if (this.sourceGraph != null) {
            result ^= this.sourceGraph.hashCode();
        }
        if (this.destinationGraph != null) {
            result ^= this.destinationGraph.hashCode();
        }
        return result;
    }

    @Override
    public Copy clone() {
        Copy clone = new Copy();
        clone.setSilent(this.isSilent());
        if (this.getSourceGraph() != null) {
            clone.setSourceGraph(this.getSourceGraph().clone());
        }
        return clone;
    }

    public void setSourceGraph(ValueConstant graph) {
        this.sourceGraph = graph;
    }

    public ValueConstant getSourceGraph() {
        return this.sourceGraph;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    @Override
    public boolean isSilent() {
        return this.silent;
    }

    public void setDestinationGraph(ValueConstant destinationGraph) {
        this.destinationGraph = destinationGraph;
    }

    public ValueConstant getDestinationGraph() {
        return this.destinationGraph;
    }
}

