/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.util.Collections;
import java.util.Map;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.CollectionApiMapping;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.util.Utils;

public class CoreApiMapping {

    public static enum EndPoint implements CollectionApiMapping.V2EndPoint
    {
        CORES_STATUS("cores.Status"),
        CORES_COMMANDS("cores.Commands"),
        PER_CORE_COMMANDS("cores.core.Commands"),
        NODEINVOKE("node.invoke"),
        NODEAPIS("node.Commands");

        final String specName;

        private EndPoint(String specName) {
            this.specName = specName;
        }

        @Override
        public String getSpecName() {
            return this.specName;
        }
    }

    public static enum Meta implements CollectionApiMapping.CommandMeta
    {
        CREATE(EndPoint.CORES_COMMANDS, SolrRequest.METHOD.POST, CoreAdminParams.CoreAdminAction.CREATE, "create", Utils.makeMap("config", "configSet")),
        UNLOAD(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminParams.CoreAdminAction.UNLOAD, "unload", null),
        RELOAD(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminParams.CoreAdminAction.RELOAD, "reload", null),
        STATUS(EndPoint.CORES_STATUS, SolrRequest.METHOD.GET, CoreAdminParams.CoreAdminAction.STATUS, "status", null),
        SWAP(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminParams.CoreAdminAction.SWAP, "swap", Utils.makeMap("other", "with")),
        RENAME(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminParams.CoreAdminAction.RENAME, "rename", Utils.makeMap("other", "to")),
        MERGEINDEXES(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminParams.CoreAdminAction.MERGEINDEXES, "merge-indexes", null),
        SPLIT(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminParams.CoreAdminAction.SPLIT, "split", Utils.makeMap("split.key", "splitKey")),
        PREPRECOVERY(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminParams.CoreAdminAction.PREPRECOVERY, "prep-recovery", null),
        REQUESTRECOVERY(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminParams.CoreAdminAction.REQUESTRECOVERY, "request-recovery", null),
        REQUESTSYNCSHARD(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminParams.CoreAdminAction.REQUESTSYNCSHARD, "request-sync-shard", null),
        REQUESTBUFFERUPDATES(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminParams.CoreAdminAction.REQUESTBUFFERUPDATES, "request-buffer-updates", null),
        REQUESTAPPLYUPDATES(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminParams.CoreAdminAction.REQUESTAPPLYUPDATES, "request-apply-updates", null),
        REQUESTSTATUS(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.GET, CoreAdminParams.CoreAdminAction.REQUESTSTATUS, "request-status", null),
        OVERSEEROP(EndPoint.NODEAPIS, SolrRequest.METHOD.POST, CoreAdminParams.CoreAdminAction.OVERSEEROP, "overseer-op", null),
        REJOINLEADERELECTION(EndPoint.NODEAPIS, SolrRequest.METHOD.POST, CoreAdminParams.CoreAdminAction.REJOINLEADERELECTION, "rejoin-leader-election", null),
        INVOKE(EndPoint.NODEINVOKE, SolrRequest.METHOD.GET, CoreAdminParams.CoreAdminAction.INVOKE, "invoke", null);

        public final String commandName;
        public final EndPoint endPoint;
        public final SolrRequest.METHOD method;
        public final CoreAdminParams.CoreAdminAction action;
        public final Map<String, String> paramstoAttr;

        private Meta(EndPoint endPoint, SolrRequest.METHOD method, CoreAdminParams.CoreAdminAction action, String commandName, Map paramstoAttr) {
            this.commandName = commandName;
            this.endPoint = endPoint;
            this.method = method;
            this.paramstoAttr = paramstoAttr == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(paramstoAttr);
            this.action = action;
        }

        @Override
        public String getName() {
            return this.commandName;
        }

        @Override
        public SolrRequest.METHOD getHttpMethod() {
            return this.method;
        }

        @Override
        public CollectionApiMapping.V2EndPoint getEndPoint() {
            return this.endPoint;
        }

        @Override
        public String getParamSubstitute(String param) {
            return this.paramstoAttr.containsKey(param) ? this.paramstoAttr.get(param) : param;
        }
    }
}

