/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console;

import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.ParseErrorListener;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFHandler;

public class VerificationListener
extends AbstractRDFHandler
implements ParseErrorListener {
    private final ConsoleIO consoleIO;
    private int warnings;
    private int errors;
    private int statements;

    public VerificationListener(ConsoleIO consoleIO) {
        this.consoleIO = consoleIO;
    }

    public int getWarnings() {
        return this.warnings;
    }

    public int getErrors() {
        return this.errors;
    }

    public int getStatements() {
        return this.statements;
    }

    @Override
    public void handleStatement(Statement statement) throws RDFHandlerException {
        ++this.statements;
    }

    @Override
    public void warning(String msg, long lineNo, long colNo) {
        ++this.warnings;
        this.consoleIO.writeParseError("WARNING", lineNo, colNo, msg);
    }

    @Override
    public void error(String msg, long lineNo, long colNo) {
        ++this.errors;
        this.consoleIO.writeParseError("ERROR", lineNo, colNo, msg);
    }

    @Override
    public void fatalError(String msg, long lineNo, long colNo) {
        ++this.errors;
        this.consoleIO.writeParseError("FATAL ERROR", lineNo, colNo, msg);
    }
}

