/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.summaryrow;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.nattable.command.ILayerCommand;
import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.layer.AbstractLayerTransform;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.layer.IUniqueIndexLayer;
import net.sourceforge.nattable.layer.LabelStack;
import net.sourceforge.nattable.layer.LayerUtil;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.layer.event.ILayerEvent;
import net.sourceforge.nattable.layer.event.PropertyUpdateEvent;
import net.sourceforge.nattable.layer.event.RowUpdateEvent;
import net.sourceforge.nattable.layer.event.RowVisualChangeEvent;
import net.sourceforge.nattable.resize.command.RowResizeCommand;
import net.sourceforge.nattable.summaryrow.DefaultSummaryRowConfiguration;
import net.sourceforge.nattable.summaryrow.ISummaryProvider;
import net.sourceforge.nattable.summaryrow.SummaryRowConfigAttributes;
import net.sourceforge.nattable.util.ArrayUtil;

public class SummaryRowLayer
extends AbstractLayerTransform
implements IUniqueIndexLayer {
    public static final String DEFAULT_SUMMARY_ROW_CONFIG_LABEL = "SummaryRow";
    public static final String DEFAULT_SUMMARY_COLUMN_CONFIG_LABEL_PREFIX = "SummaryColumn_";
    private final IConfigRegistry configRegistry;
    private int summaryRowHeight = 20;
    protected Map<Integer, Object> summaryCache = new HashMap<Integer, Object>();

    public SummaryRowLayer(IUniqueIndexLayer underlyingDataLayer, IConfigRegistry configRegistry) {
        this(underlyingDataLayer, configRegistry, true);
    }

    public SummaryRowLayer(IUniqueIndexLayer underlyingDataLayer, IConfigRegistry configRegistry, boolean autoConfigure) {
        super(underlyingDataLayer);
        this.configRegistry = configRegistry;
        if (autoConfigure) {
            this.addConfiguration(new DefaultSummaryRowConfiguration());
        }
    }

    public Object getDataValueByPosition(final int columnPosition, final int rowPosition) {
        if (this.isSummaryRowPosition(rowPosition)) {
            if (this.getSummaryFromCache(columnPosition) != null) {
                return this.getSummaryFromCache(columnPosition);
            }
            LabelStack labelStack = this.getConfigLabelsByPosition(columnPosition, rowPosition);
            String[] configLabels = labelStack.getLabels().toArray(ArrayUtil.STRING_TYPE_ARRAY);
            final ISummaryProvider summaryProvider = this.configRegistry.getConfigAttribute(SummaryRowConfigAttributes.SUMMARY_PROVIDER, "NORMAL", configLabels);
            if (summaryProvider == ISummaryProvider.NONE) {
                return ISummaryProvider.DEFAULT_SUMMARY_VALUE;
            }
            new Thread(){

                public void run() {
                    Object summaryValue = SummaryRowLayer.this.calculateColumnSummary(columnPosition, summaryProvider);
                    SummaryRowLayer.this.addToCache(columnPosition, summaryValue);
                    SummaryRowLayer.this.fireLayerEvent(new RowUpdateEvent((ILayer)SummaryRowLayer.this, rowPosition));
                }
            }.start();
            return ISummaryProvider.DEFAULT_SUMMARY_VALUE;
        }
        return super.getDataValueByPosition(columnPosition, rowPosition);
    }

    private Object calculateColumnSummary(int columnIndex, ISummaryProvider summaryProvider) {
        Object summaryValue = null;
        if (summaryProvider != null) {
            summaryValue = summaryProvider.summarize(columnIndex);
        }
        return summaryValue;
    }

    public Object getSummaryFromCache(Integer columnIndex) {
        return this.summaryCache.get(columnIndex);
    }

    protected void addToCache(Integer columnIndex, Object summaryValue) {
        this.summaryCache.put(columnIndex, summaryValue);
    }

    protected void clearSummaryCache() {
        this.summaryCache.clear();
    }

    public boolean doCommand(ILayerCommand command) {
        RowResizeCommand rowResizeCommand;
        if (command instanceof RowResizeCommand && this.isSummaryRowPosition((rowResizeCommand = (RowResizeCommand)command).getRowPosition())) {
            this.summaryRowHeight = rowResizeCommand.getNewHeight();
            return true;
        }
        return super.doCommand(command);
    }

    public void handleLayerEvent(ILayerEvent event) {
        if (event instanceof RowVisualChangeEvent || event instanceof PropertyUpdateEvent) {
            this.clearSummaryCache();
        }
        super.handleLayerEvent(event);
    }

    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        if (this.isSummaryRowPosition(rowPosition)) {
            return new LabelStack(DEFAULT_SUMMARY_COLUMN_CONFIG_LABEL_PREFIX + columnPosition, DEFAULT_SUMMARY_ROW_CONFIG_LABEL);
        }
        return super.getConfigLabelsByPosition(columnPosition, rowPosition);
    }

    public LayerCell getCellByPosition(int columnPosition, int rowPosition) {
        if (this.isSummaryRowPosition(rowPosition)) {
            return new LayerCell(this, columnPosition, rowPosition);
        }
        return super.getCellByPosition(columnPosition, rowPosition);
    }

    public int getHeight() {
        return super.getHeight() + this.getRowHeightByPosition(this.getRowCount() - 1);
    }

    public int getRowCount() {
        return super.getRowCount() + 1;
    }

    public int getRowIndexByPosition(int rowPosition) {
        if (this.isSummaryRowPosition(rowPosition)) {
            return rowPosition;
        }
        return super.getRowIndexByPosition(rowPosition);
    }

    public int getRowPositionByY(int y) {
        return LayerUtil.getRowPositionByY(this, y);
    }

    private boolean isSummaryRowPosition(int rowPosition) {
        return rowPosition == super.getRowCount();
    }

    public int getRowHeightByPosition(int rowPosition) {
        if (this.isSummaryRowPosition(rowPosition)) {
            return this.summaryRowHeight;
        }
        return super.getRowHeightByPosition(rowPosition);
    }

    public int getPreferredRowCount() {
        return this.getRowCount();
    }

    public int getRowPositionByIndex(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.getRowCount()) {
            return rowIndex;
        }
        return -1;
    }

    public int getColumnPositionByIndex(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.getColumnCount()) {
            return columnIndex;
        }
        return -1;
    }
}

