/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.ui.menu;

import net.sourceforge.nattable.NatTable;
import net.sourceforge.nattable.ui.menu.IMenuItemProvider;
import net.sourceforge.nattable.ui.menu.MenuItemProviders;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class PopupMenuBuilder {
    NatTable natTable;
    Menu popupMenu;

    public PopupMenuBuilder(NatTable parent) {
        this.natTable = parent;
        this.popupMenu = new Menu((Control)parent.getShell());
    }

    public PopupMenuBuilder withMenuItemProvider(IMenuItemProvider meuItemProvider) {
        meuItemProvider.addMenuItem(this.natTable, this.popupMenu);
        return this;
    }

    public PopupMenuBuilder withHideColumnMenuItem() {
        return this.withMenuItemProvider(MenuItemProviders.hideColumnMenuItemProvider());
    }

    public PopupMenuBuilder withShowAllColumnsMenuItem() {
        return this.withMenuItemProvider(MenuItemProviders.showAllColumnMenuItemProvider());
    }

    public PopupMenuBuilder withAutoResizeSelectedColumnsMenuItem() {
        return this.withMenuItemProvider(MenuItemProviders.autoResizeColumnMenuItemProvider());
    }

    public PopupMenuBuilder withAutoResizeSelectedRowsMenuItem() {
        return this.withMenuItemProvider(MenuItemProviders.autoResizeRowMenuItemProvider());
    }

    public PopupMenuBuilder withColumnChooserMenuItem() {
        return this.withMenuItemProvider(MenuItemProviders.columnChooserMenuItemProvider());
    }

    public PopupMenuBuilder withColumnChooserMenuItem(String menuLabel) {
        return this.withMenuItemProvider(MenuItemProviders.columnChooserMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withColumnStyleEditor(String menuLabel) {
        return this.withMenuItemProvider(MenuItemProviders.columnStyleEditorMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withColumnRenameDialog(String menuLabel) {
        return this.withMenuItemProvider(MenuItemProviders.renameColumnMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withCreateColumnGroupsMenuItem() {
        return this.withMenuItemProvider(MenuItemProviders.createColumnGroupMenuItemProvider());
    }

    public PopupMenuBuilder withUngroupColumnsMenuItem() {
        return this.withMenuItemProvider(MenuItemProviders.ungroupColumnsMenuItemProvider());
    }

    public PopupMenuBuilder withInspectLabelsMenuItem() {
        return this.withMenuItemProvider(MenuItemProviders.inspectLabelsMenuItemProvider());
    }

    public PopupMenuBuilder withCategoriesBasesColumnChooser(String menuLabel) {
        return this.withMenuItemProvider(MenuItemProviders.categoriesBasedColumnChooserMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withClearAllFilters(String menuLabel) {
        return this.withMenuItemProvider(MenuItemProviders.clearAllFiltersMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withToggleFilterRow(String menuLabel) {
        return this.withMenuItemProvider(MenuItemProviders.clearToggleFilterRowMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withSeparator() {
        return this.withMenuItemProvider(MenuItemProviders.separatorMenuItemProvider());
    }

    public Menu build() {
        return this.popupMenu;
    }
}

