/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.layout;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.core.preference.PreferenceChangeEvent;
import org.eclipse.birt.report.designer.core.mediator.IMediatorColleague;
import org.eclipse.birt.report.designer.core.mediator.IMediatorRequest;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.ColumnHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.model.schematic.ListBandProxy;
import org.eclipse.birt.report.designer.core.model.schematic.RowHandleAdapter;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.command.WrapperCommandStack;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.ReportViewerKeyHandler;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IModelEventManager;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IModelEventProcessor;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.ModelEventManager;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.AddGroupAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.AddStyleAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.ChangeDataColumnPartAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.CopyCellContentsContextAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.CopyPartAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.CreateChartAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.CreatePlaceHolderPartAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.CutPartAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.DeleteColumnAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.DeleteListGroupAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.DeleteRowAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.DeleteTableGroupAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.EditBindingAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.ExportElementToLibraryPartAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.ImportCSSStylePartAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.IncludeDetailAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.IncludeFooterAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.IncludeHeaderAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertColumnLeftAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertColumnRightAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertListGroupAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertRowAboveAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertRowBelowAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertTableGroupAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.MergeAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.PastePartAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.ResetImageSizeAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.RevertToReportItemPartAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.RevertToTemplatePartAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.SelectColumnAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.SelectRowAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.SplitAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.UseLibraryPartAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.GraphicalPartFactory;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportRootEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.providers.SchematicContextMenuProvider;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedElementUIPoint;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtensionPointManager;
import org.eclipse.birt.report.designer.internal.ui.extension.experimental.EditpartExtensionManager;
import org.eclipse.birt.report.designer.internal.ui.extension.experimental.PaletteEntryExtension;
import org.eclipse.birt.report.designer.internal.ui.palette.ReportFlyoutPalettePreferences;
import org.eclipse.birt.report.designer.internal.ui.palette.ReportTemplateTransferDropTargetListener;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.actions.CopyFormatAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.PasteFormatAction;
import org.eclipse.birt.report.designer.internal.ui.views.data.DataViewTreeViewerPage;
import org.eclipse.birt.report.designer.internal.ui.views.outline.DesignerOutlinePage;
import org.eclipse.birt.report.designer.internal.ui.views.property.ReportPropertySheetPage;
import org.eclipse.birt.report.designer.ui.actions.ApplyStyleMenuAction;
import org.eclipse.birt.report.designer.ui.actions.ApplyThemeMenuAction;
import org.eclipse.birt.report.designer.ui.actions.DeleteStyleMenuAction;
import org.eclipse.birt.report.designer.ui.actions.EditGroupMenuAction;
import org.eclipse.birt.report.designer.ui.actions.EditStyleMenuAction;
import org.eclipse.birt.report.designer.ui.actions.GeneralInsertMenuAction;
import org.eclipse.birt.report.designer.ui.actions.InsertAggregationAction;
import org.eclipse.birt.report.designer.ui.actions.InsertExpressionMenuAction;
import org.eclipse.birt.report.designer.ui.actions.InsertGroupMenuAction;
import org.eclipse.birt.report.designer.ui.actions.InsertRelativeTimePeriodAction;
import org.eclipse.birt.report.designer.ui.editors.IReportProvider;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.views.attributes.AttributeViewPage;
import org.eclipse.birt.report.designer.ui.views.attributes.IAttributeViewPage;
import org.eclipse.birt.report.designer.ui.views.data.IDataViewPage;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public abstract class ReportEditorWithPalette
extends GraphicalEditorWithFlyoutPalette
implements IMediatorColleague {
    protected PaletteRoot paletteRoot;
    private EditPartFactory editPartFactoy;
    private ModuleHandle model;
    private IModelEventManager manager = this.createModelEventManager();
    private static final String DLG_ERROR_OPEN_ERROR_MSG = "Can't open file";
    private Object fLastSentPostElement = null;

    public ReportEditorWithPalette() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    public ReportEditorWithPalette(IEditorPart parent) {
        this();
    }

    protected IModelEventManager createModelEventManager() {
        return new ModelEventManager();
    }

    protected IModelEventManager getModelEventManager() {
        return this.manager;
    }

    protected abstract PaletteRoot getPaletteRoot();

    protected FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return new ReportFlyoutPalettePreferences();
    }

    protected void createActions() {
        super.createActions();
        MergeAction action = new MergeAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new SplitAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new CreateChartAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new DeleteRowAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new DeleteColumnAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new DeleteTableGroupAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new InsertRowAboveAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new InsertRowBelowAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new InsertTableGroupAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new InsertColumnRightAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new InsertColumnLeftAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new CutPartAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new CopyPartAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new PastePartAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new InsertListGroupAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new DeleteListGroupAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AddStyleAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new ImportCSSStylePartAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AddGroupAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new InsertGroupMenuAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new ChangeDataColumnPartAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new CreatePlaceHolderPartAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new RevertToReportItemPartAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new RevertToTemplatePartAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new ExportElementToLibraryPartAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new ApplyStyleMenuAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new ApplyThemeMenuAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new EditStyleMenuAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new DeleteStyleMenuAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new EditGroupMenuAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new EditBindingAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new GeneralInsertMenuAction((IWorkbenchPart)this, "Insert Text", "Text");
        this.getSelectionActions().add(action.getId());
        this.addEditPartAction((SelectionAction)action);
        action = new GeneralInsertMenuAction((IWorkbenchPart)this, "Insert Label", "Label");
        this.getSelectionActions().add(action.getId());
        this.addEditPartAction((SelectionAction)action);
        action = new GeneralInsertMenuAction((IWorkbenchPart)this, "Insert Data", "Data");
        this.getSelectionActions().add(action.getId());
        this.addEditPartAction((SelectionAction)action);
        action = new GeneralInsertMenuAction((IWorkbenchPart)this, "Insert Grid", "Grid");
        this.getSelectionActions().add(action.getId());
        this.addEditPartAction((SelectionAction)action);
        action = new GeneralInsertMenuAction((IWorkbenchPart)this, "Insert List", "List");
        this.getSelectionActions().add(action.getId());
        this.addEditPartAction((SelectionAction)action);
        action = new GeneralInsertMenuAction((IWorkbenchPart)this, "Insert Table", "Table");
        this.getSelectionActions().add(action.getId());
        this.addEditPartAction((SelectionAction)action);
        action = new GeneralInsertMenuAction((IWorkbenchPart)this, "Insert Image", "Image");
        this.getSelectionActions().add(action.getId());
        this.addEditPartAction((SelectionAction)action);
        action = new GeneralInsertMenuAction((IWorkbenchPart)this, "Insert Dynamic Text", "TextData");
        this.getSelectionActions().add(action.getId());
        this.addEditPartAction((SelectionAction)action);
        action = new InsertAggregationAction((IWorkbenchPart)this);
        this.getSelectionActions().add(action.getId());
        this.addEditPartAction((SelectionAction)action);
        action = new InsertRelativeTimePeriodAction((IWorkbenchPart)this);
        this.getSelectionActions().add(action.getId());
        this.addEditPartAction((SelectionAction)action);
        action = new InsertExpressionMenuAction((IWorkbenchPart)this);
        this.getSelectionActions().add(action.getId());
        this.addEditPartAction((SelectionAction)action);
        action = new DirectEditAction((IWorkbenchPart)this);
        ((DirectEditAction)action).setDirectEditRequest(new Request((Object)"open"));
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new IncludeHeaderAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new IncludeDetailAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new IncludeFooterAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new UseLibraryPartAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new SelectRowAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new SelectColumnAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new CopyCellContentsContextAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new CopyFormatAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new PasteFormatAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new ResetImageSizeAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        this.registerInsertExtElementActions();
    }

    private void registerInsertExtElementActions() {
        GeneralInsertMenuAction action;
        List points = ExtensionPointManager.getInstance().getExtendedElementPoints();
        for (ExtendedElementUIPoint point : points) {
            action = new GeneralInsertMenuAction((IWorkbenchPart)this, point.getExtensionName(), point.getExtensionName(), point.getExtensionName());
            this.getSelectionActions().remove(action.getId());
            this.removeEditPartAction((SelectionAction)action);
            if (!UIUtil.isVisibleExtensionElement((ExtendedElementUIPoint)point)) continue;
            this.getSelectionActions().add(action.getId());
            this.addEditPartAction((SelectionAction)action);
        }
        PaletteEntryExtension[] entries = EditpartExtensionManager.getPaletteEntries();
        int i = 0;
        while (i < entries.length) {
            action = new GeneralInsertMenuAction((IWorkbenchPart)this, entries[i].getItemName(), entries[i].getItemName(), entries[i].getLabel());
            this.getSelectionActions().remove(action.getId());
            this.removeEditPartAction((SelectionAction)action);
            this.getSelectionActions().add(action.getId());
            this.addEditPartAction((SelectionAction)action);
            ++i;
        }
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        if (this.getModel() != null) {
            this.setContents();
            this.hookModelEventManager(this.getModel());
        }
        viewer.addDropTargetListener((TransferDropTargetListener)this.createTemplateTransferDropTargetListener((EditPartViewer)viewer));
    }

    protected void setContents() {
        this.getGraphicalViewer().setContents((Object)this.getModel());
    }

    protected void hookModelEventManager(Object model) {
        this.manager.hookRoot(model);
        Object processor = this.getGraphicalViewer().getRootEditPart().getAdapter(IModelEventProcessor.class);
        if (processor instanceof IModelEventProcessor) {
            this.manager.addModelEventProcessor((IModelEventProcessor)processor);
        }
        if (this.getCommandStack() instanceof WrapperCommandStack) {
            this.manager.hookCommandStack((WrapperCommandStack)this.getCommandStack());
        }
    }

    protected void unhookModelEventManager(Object model) {
        this.manager.unhookRoot(model);
        if (this.getCommandStack() instanceof WrapperCommandStack) {
            this.manager.unhookCommandStack((WrapperCommandStack)this.getCommandStack());
        }
    }

    protected TemplateTransferDropTargetListener createTemplateTransferDropTargetListener(EditPartViewer viewer) {
        return new ReportTemplateTransferDropTargetListener(viewer);
    }

    protected void createGraphicalViewer(Composite parent) {
        super.createGraphicalViewer(parent);
        SessionHandleAdapter.getInstance().getMediator(this.getModel()).addColleague((IMediatorColleague)this);
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        ActionRegistry actionRegistry = this.getActionRegistry();
        ReportRootEditPart root = new ReportRootEditPart();
        viewer.setRootEditPart((RootEditPart)root);
        this.hookZoom((ScalableFreeformRootEditPart)root);
        viewer.setKeyHandler((KeyHandler)new ReportViewerKeyHandler(viewer, actionRegistry));
        SchematicContextMenuProvider provider = new SchematicContextMenuProvider((EditPartViewer)viewer, actionRegistry);
        viewer.setContextMenu((MenuManager)provider);
        this.getEditDomain().addViewer((EditPartViewer)viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)viewer);
        viewer.setEditPartFactory(this.getEditPartFactory());
        ModuleHandle model = this.getModel();
        WrapperCommandStack commandStack = new WrapperCommandStack(model == null ? null : model.getCommandStack());
        viewer.getEditDomain().setCommandStack((CommandStack)commandStack);
    }

    public boolean isInterested(IMediatorRequest request) {
        return request instanceof ReportRequest;
    }

    public void performRequest(IMediatorRequest request) {
        if ("selection".equals(request.getType())) {
            this.handleSelectionChange((ReportRequest)request);
            this.performBreadcrumbRequest((ReportRequest)request);
        } else if ("create element".equals(request.getType())) {
            this.handleCreateElement((ReportRequest)request);
            this.performBreadcrumbRequest((ReportRequest)request);
        }
    }

    protected void performBreadcrumbRequest(ReportRequest request) {
        final List list = request.getSelectionModelList();
        this.fLastSentPostElement = list.size() != 1 ? null : DEUtil.getInputFirstElement((Object)list);
        Display.getDefault().timerExec(100, new Runnable(){

            @Override
            public void run() {
                if (ReportEditorWithPalette.this.fLastSentPostElement == null && DEUtil.getInputSize((Object)list) <= 0) {
                    ReportEditorWithPalette.this.setBreadcrumbInput(null);
                } else if (list != null && list.size() > 0 && DEUtil.getInputFirstElement((Object)list) == ReportEditorWithPalette.this.fLastSentPostElement) {
                    ReportEditorWithPalette.this.setBreadcrumbInput(ReportEditorWithPalette.this.fLastSentPostElement);
                    ReportEditorWithPalette.this.fLastSentPostElement = null;
                }
            }
        });
    }

    protected void handleCreateElement(final ReportRequest request) {
        final GraphicalViewer viewer = this.getGraphicalViewer();
        if (!viewer.getControl().isVisible()) {
            return;
        }
        final List list = request.getSelectionModelList();
        if (list.size() != 1) {
            return;
        }
        if (request.getSource() instanceof ParameterHandle && list.get(0) instanceof DataItemHandle) {
            return;
        }
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                Object part = viewer.getEditPartRegistry().get(list.get(0));
                if (part instanceof EditPart) {
                    Request directEditRequest = new Request((Object)"create element");
                    directEditRequest.getExtendedData().putAll(request.getExtendedData());
                    if (((EditPart)part).understandsRequest(directEditRequest)) {
                        ((EditPart)part).performRequest(directEditRequest);
                    }
                }
            }
        });
    }

    protected void handleSelectionChange(ReportRequest request) {
        List select = this.convertEventToGFE(request);
        if (select == null) {
            return;
        }
        this.getGraphicalViewer().setSelection((ISelection)new StructuredSelection(select));
        if (select.size() > 0) {
            this.getGraphicalViewer().reveal((EditPart)select.get(select.size() - 1));
        }
    }

    private List convertEventToGFE(ReportRequest event) {
        if (event.getSource() == this.getGraphicalViewer()) {
            return null;
        }
        ArrayList tempList = new ArrayList();
        List list = event.getSelectionModelList();
        int size = list.size();
        if (size != 0 && list.get(0) instanceof RowHandle) {
            RowHandle handle = (RowHandle)list.get(0);
            RowHandleAdapter adapter = HandleAdapterFactory.getInstance().getRowHandleAdapter((Object)handle);
            Object tableParent = adapter.getTableParent();
            if (tableParent == null) {
                return null;
            }
            Object object = this.getGraphicalViewer().getEditPartRegistry().get(tableParent);
            if (!(object instanceof TableEditPart)) {
                return null;
            }
            TableEditPart part = (TableEditPart)object;
            int[] selectRows = new int[]{adapter.getRowNumber()};
            int i = 1;
            while (i < size) {
                Object o = list.get(i);
                if (o instanceof RowHandle) {
                    handle = (RowHandle)o;
                    adapter = HandleAdapterFactory.getInstance().getRowHandleAdapter((Object)handle);
                    if (tableParent != adapter.getTableParent()) {
                        return null;
                    }
                } else {
                    return null;
                }
                int len = selectRows.length;
                int[] temp = new int[len + 1];
                System.arraycopy(selectRows, 0, temp, 0, len);
                temp[len] = adapter.getRowNumber();
                selectRows = temp;
                ++i;
            }
            if (handle.getRoot() == null) {
                return null;
            }
            if (part != null) {
                Arrays.sort(selectRows);
                int len = selectRows.length;
                if (len > 1) {
                    int i2 = 0;
                    while (i2 < len - 1) {
                        if (selectRows[i2 + 1] - selectRows[i2] != 1) {
                            return null;
                        }
                        ++i2;
                    }
                }
                part.selectRow(selectRows);
            }
            return null;
        }
        if (size != 0 && list.get(0) instanceof ColumnHandle) {
            ColumnHandle handle = (ColumnHandle)list.get(0);
            ColumnHandleAdapter adapter = HandleAdapterFactory.getInstance().getColumnHandleAdapter((Object)handle);
            Object tableParent = adapter.getTableParent();
            if (tableParent == null) {
                return null;
            }
            TableEditPart part = (TableEditPart)this.getGraphicalViewer().getEditPartRegistry().get(tableParent);
            int[] selectColumns = new int[]{adapter.getColumnNumber()};
            int i = 1;
            while (i < size) {
                Object o = list.get(i);
                if (o instanceof ColumnHandle) {
                    handle = (ColumnHandle)o;
                    adapter = HandleAdapterFactory.getInstance().getColumnHandleAdapter((Object)handle);
                    if (tableParent != adapter.getTableParent()) {
                        return null;
                    }
                } else {
                    return null;
                }
                int len = selectColumns.length;
                int[] temp = new int[len + 1];
                System.arraycopy(selectColumns, 0, temp, 0, len);
                temp[len] = adapter.getColumnNumber();
                selectColumns = temp;
                ++i;
            }
            if (handle.getRoot() == null) {
                return null;
            }
            if (part != null) {
                Arrays.sort(selectColumns);
                int len = selectColumns.length;
                if (len > 1) {
                    int i3 = 0;
                    while (i3 < len - 1) {
                        if (selectColumns[i3 + 1] - selectColumns[i3] != 1) {
                            return null;
                        }
                        ++i3;
                    }
                }
                part.selectColumn(selectColumns);
            }
            return null;
        }
        int i = 0;
        while (i < size) {
            Object obj = list.get(i);
            if (obj instanceof EditPart) {
                tempList.add(obj);
            } else {
                EditPart part = null;
                if (obj instanceof SlotHandle) {
                    obj = (SlotHandle)obj;
                    part = (EditPart)this.getGraphicalViewer().getEditPartRegistry().get(new ListBandProxy((SlotHandle)obj));
                } else {
                    part = (EditPart)this.getGraphicalViewer().getEditPartRegistry().get(obj);
                    if (part == null) {
                        part = this.getInterestEditPart((EditPart)this.getGraphicalViewer().getRootEditPart(), obj);
                    }
                }
                if (part instanceof EditPart) {
                    tempList.add(part);
                }
            }
            ++i;
        }
        if (tempList.isEmpty()) {
            return null;
        }
        return tempList;
    }

    private EditPart getInterestEditPart(EditPart part, Object obj) {
        List chList = part.getChildren();
        int i = 0;
        while (i < chList.size()) {
            ReportElementEditPart reportEditPart = (ReportElementEditPart)chList.get(i);
            if (reportEditPart.isinterestSelection(obj)) {
                return reportEditPart;
            }
            EditPart retValue = this.getInterestEditPart((EditPart)reportEditPart, obj);
            if (retValue != null) {
                return retValue;
            }
            ++i;
        }
        return null;
    }

    protected EditPartFactory getEditPartFactory() {
        if (this.editPartFactoy == null) {
            this.editPartFactoy = new GraphicalPartFactory();
        }
        return this.editPartFactoy;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (this.getModel() == null) {
            throw new PartInitException(DLG_ERROR_OPEN_ERROR_MSG);
        }
    }

    protected final ModuleHandle getModel() {
        if (this.model == null) {
            IReportProvider reportProvider = this.getProvider();
            this.model = reportProvider.queryReportModuleHandle();
        }
        return this.model;
    }

    protected void setModel(ModuleHandle model) {
        this.model = model;
    }

    public boolean isDirty() {
        ModuleHandle newModel = this.getProvider().queryReportModuleHandle();
        if (newModel != null && newModel != this.model) {
            return newModel.needsSave();
        }
        if (this.model == null) {
            return false;
        }
        return this.model.needsSave();
    }

    public void doSave(IProgressMonitor monitor) {
        IReportProvider provider = this.getProvider();
        if (provider != null) {
            provider.saveReport(this.getModel(), (Object)this.getEditorInput(), monitor);
            this.firePropertyChange(257);
        }
    }

    protected abstract IReportProvider getProvider();

    public void doSaveAs() {
        IReportProvider provider = this.getProvider();
        if (provider != null) {
            IPath path = provider.getSaveAsPath((Object)this.getEditorInput());
            if (path == null) {
                return;
            }
            final IPath origReportPath = provider.getInputPath(this.getEditorInput());
            final IEditorInput input = provider.createNewEditorInput(path);
            this.setInput(input);
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public final synchronized void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    final InvocationTargetException[] iteHolder = new InvocationTargetException[1];
                    try {
                        IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(){

                            public void run(IProgressMonitor pm) throws CoreException {
                                try {
                                    this.execute(pm);
                                }
                                catch (InvocationTargetException e) {
                                    iteHolder[0] = e;
                                }
                                catch (InterruptedException e) {
                                    throw new OperationCanceledException(e.getMessage());
                                }
                            }
                        };
                        ResourcesPlugin.getWorkspace().run(workspaceRunnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 0, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCanceledException e) {
                        throw new InterruptedException(e.getMessage());
                    }
                    if (iteHolder[0] != null) {
                        throw iteHolder[0];
                    }
                }

                public void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    try {
                        input.exists();
                        IReportProvider provider = ReportEditorWithPalette.this.getProvider();
                        if (provider != null) {
                            provider.saveReport(ReportEditorWithPalette.this.getModel(), (Object)ReportEditorWithPalette.this.getEditorInput(), origReportPath, monitor);
                            ReportEditorWithPalette.this.firePropertyChange(257);
                        }
                    }
                    catch (Exception e) {
                        ExceptionUtil.handle((Throwable)e);
                    }
                }
            };
            try {
                new ProgressMonitorDialog(this.getSite().getWorkbenchWindow().getShell()).run(false, true, op);
            }
            catch (Exception e) {
                ExceptionUtil.handle((Throwable)e);
            }
        }
    }

    protected void rebuildEditor() {
    }

    public Object getAdapter(Class type) {
        if (type == IContentOutlinePage.class) {
            DesignerOutlinePage outlinePage = new DesignerOutlinePage(this.getModel());
            this.manager.addModelEventProcessor(outlinePage.getModelProcessor());
            return outlinePage;
        }
        if (type == IPropertySheetPage.class) {
            ReportPropertySheetPage sheetPage = new ReportPropertySheetPage(this.getModel());
            return sheetPage;
        }
        if (type == IDataViewPage.class) {
            DataViewTreeViewerPage page = new DataViewTreeViewerPage(this.getModel());
            this.manager.addModelEventProcessor(page.getModelProcessor());
            return page;
        }
        if (type == IAttributeViewPage.class) {
            AttributeViewPage page = new AttributeViewPage(this.getModel());
            return page;
        }
        if (type == IModelEventManager.class) {
            return this.manager;
        }
        return super.getAdapter(type);
    }

    public void dispose() {
        if (this.getCommandStack() != null) {
            this.getCommandStack().flush();
        }
        this.unhookModelEventManager(this.getModel());
        SessionHandleAdapter.getInstance().getMediator(this.getModel()).removeColleague((IMediatorColleague)this);
        super.dispose();
        this.manager = null;
    }

    public void preferenceChange(PreferenceChangeEvent event) {
        this.paletteRoot = null;
        this.getEditDomain().setPaletteRoot(this.getPaletteRoot());
        this.registerInsertExtElementActions();
        this.updateStackActions();
    }
}

