/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.dialogs;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.eclipse.bpel.model.BPELFactory;
import org.eclipse.bpel.model.Invoke;
import org.eclipse.bpel.model.OnEvent;
import org.eclipse.bpel.model.OnMessage;
import org.eclipse.bpel.model.PartnerLink;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.Receive;
import org.eclipse.bpel.model.Reply;
import org.eclipse.bpel.model.partnerlinktype.PartnerLinkType;
import org.eclipse.bpel.model.partnerlinktype.PartnerlinktypeFactory;
import org.eclipse.bpel.model.partnerlinktype.Role;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.commands.CompoundCommand;
import org.eclipse.bpel.ui.commands.InsertInContainerCommand;
import org.eclipse.bpel.ui.commands.SetNameCommand;
import org.eclipse.bpel.ui.dialogs.SelectionAndCreationDialog;
import org.eclipse.bpel.ui.properties.PropertiesLabelProvider;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.bpel.ui.util.NameDialog;
import org.eclipse.bpel.ui.util.NamespaceUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.PortType;

public class PartnerLinkSelectorDialog
extends SelectionAndCreationDialog {
    protected EObject modelObject;
    protected Text filterText;

    public PartnerLinkSelectorDialog(Shell parent, EObject modelObject) {
        super(parent, (ILabelProvider)new PropertiesLabelProvider(), (ILabelProvider)new PortTypeLabelProvider());
        this.modelObject = modelObject;
        this.setTitle(Messages.PartnerLinkSelectorDialog_1);
        this.setMessage(Messages.PartnerLinkSelectorDialog_2);
        this.setUpperListLabel(Messages.PartnerLinkSelectorDialog_3);
        this.setLowerListLabel(Messages.PartnerLinkSelectorDialog_4);
        this.refreshPartners();
    }

    protected void refreshPartners() {
        Object[] partners = this.getPartnerLinks(this.modelObject);
        this.setElements(partners);
        if (this.fFilteredList != null) {
            this.setListElements(partners);
        }
    }

    protected PartnerLink[] getPartnerLinks(EObject target) {
        PartnerLink[] partners = BPELUtil.getVisiblePartnerLinks(target);
        ArrayList<PartnerLink> result = new ArrayList<PartnerLink>();
        int i = 0;
        while (i < partners.length) {
            if (this.isCompatible(target, partners[i])) {
                result.add(partners[i]);
            }
            ++i;
        }
        return result.toArray(new PartnerLink[result.size()]);
    }

    protected boolean isCompatible(EObject target, PartnerLink partner) {
        if (partner.getMyRole() == null && partner.getPartnerRole() == null) {
            return true;
        }
        if (target instanceof Invoke && partner.getPartnerRole() != null) {
            return true;
        }
        return (target instanceof Receive || target instanceof OnEvent || target instanceof OnMessage || target instanceof Reply) && partner.getMyRole() != null;
    }

    public PartnerLink getPartnerLink() {
        if (this.getResult().length > 0) {
            return (PartnerLink)this.getResult()[0];
        }
        return null;
    }

    @Override
    protected void handleNewButtonPushed() {
        PartnerLink partner = BPELFactory.eINSTANCE.createPartnerLink();
        Process process = BPELUtils.getProcess((Object)this.modelObject);
        String newName = this.filterText.getText();
        newName = BPELUtil.generateUniqueModelName((EObject)process, newName, (EObject)partner);
        NameDialog nameDialog = new NameDialog(this.getShell(), Messages.PartnerLinkSelectorDialog_5, Messages.PartnerLinkSelectorDialog_6, newName, BPELUtil.getNCNameValidator());
        if (nameDialog.open() == 0) {
            String newPartnerName = nameDialog.getValue();
            PartnerLinkType plt = PartnerlinktypeFactory.eINSTANCE.createPartnerLinkType();
            Definition artifactsDefinition = ModelHelper.getBPELEditor(process).getArtifactsDefinition();
            CompoundCommand command = new CompoundCommand();
            command.add((Command)new InsertInContainerCommand((EObject)process, (EObject)partner, null));
            command.add((Command)ModelHelper.getCreatePartnerLinkTypeCommand(process, partner, plt, artifactsDefinition, this.getRoleKind()));
            command.add((Command)new SetNameCommand((EObject)partner, newPartnerName));
            ModelHelper.getBPELEditor(process).getCommandStack().execute((Command)command);
            this.refreshPartners();
            this.setFilter(partner.getName());
            this.setLowerSelectedElement(partner);
            this.getOkButton().setFocus();
        }
    }

    @Override
    protected Text createFilterText(Composite parent) {
        this.filterText = super.createFilterText(parent);
        return this.filterText;
    }

    protected int getRoleKind() {
        if (this.modelObject instanceof Invoke) {
            return 1;
        }
        return 0;
    }

    protected static class PortTypeLabelProvider
    extends LabelProvider {
        protected PortTypeLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof PartnerLink) {
                PortType portType;
                Role role;
                PartnerLink partner = (PartnerLink)element;
                Role role2 = role = partner.getMyRole() != null ? partner.getMyRole() : partner.getPartnerRole();
                if (role != null && (portType = ModelHelper.getPortType(role)) != null) {
                    QName qname = portType.getQName();
                    String uri = NamespaceUtils.convertUriToNamespace(qname.getNamespaceURI());
                    return String.valueOf(uri) + " - " + qname.getLocalPart();
                }
            }
            return Messages.PartnerLinkSelectorDialog_0;
        }
    }
}

