/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import java.util.Map;
import java.util.Set;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.Filters;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.NodeNameFilter;
import org.eclipse.bpel.validator.rules.CValidator;
import org.eclipse.bpel.validator.rules.FlowValidator;

public class SourceValidator
extends CValidator {
    public static IFilter<INode> PARENTS = new NodeNameFilter(ND_SOURCES);
    String ncName;
    INode fFlowNode;
    protected Set<String> fSet;
    protected Map<String, INode> fSourceMap;
    protected INode fRepeatableConstructNode;
    protected INode fFaultHandlerNode;
    protected INode fActivityNode;
    protected Map<String, INode> fTargetMap;
    protected INode fTargetActivity;

    @Override
    protected void start() {
        super.start();
        this.ncName = this.mNode.getAttribute(AT_LINK_NAME);
        this.fActivityNode = this.fParentNode.parentNode();
    }

    @ARule(date="9/14/2006", desc="Check the source variable NCName", author="michal.chmielewski@oracle.com", errors="BPELC__UNSET_ATTRIBUTE,General.NCName_Bad")
    public void rule_CheckName_1() {
        this.checkNCName(this.mNode, this.ncName, AT_LINK_NAME);
    }

    @ARule(sa=1200, desc="Check if we are within a flow, if not disable rest of rules", author="michal.chmielewski@oracle.com", date="02/17/2007")
    public void rule_CheckIfInFlow_2() {
        this.fFlowNode = mSelector.selectParent(this.fActivityNode, Filters.FLOW);
        if (this.isUndefined(this.fFlowNode)) {
            this.disableRules(10, 1000);
            return;
        }
        this.fSet = this.getValue(this.fFlowNode, FlowValidator.LINKS_SET, null);
    }

    @ARule(sa=65, desc="The value of the linkName attribute of <source> MUST be the name of a <link> declared in an enclosing <flow> activity.", author="michal.chmielewski@oracle.com", date="02/16/2007", errors="BPELC_LINK__UNDEFINED")
    public void rule_CheckAgainstDeclaredLink_11() {
        if (this.fSet == null) {
            return;
        }
        if (!this.fSet.contains(this.ncName)) {
            IProblem problem = this.createError();
            problem.fill("BPELC_LINK__UNDEFINED", this.toString(this.mNode.nodeName()), this.ncName);
        }
    }

    @ARule(sa=66, desc="Every link must have exactly one activity as source and one as target", author="michal.chmielewski@oracle.com", date="02/17/2007", errors="BPELC_LINK__NAME_USED")
    public void rule_CheckIfSourceAlreadyUsed_12() {
        this.fSourceMap = this.getValue(this.fFlowNode, FlowValidator.SOURCE_MAP, null);
        if (this.fSourceMap.containsKey(this.ncName)) {
            IProblem problem = this.createError();
            problem.fill("BPELC_LINK__NAME_USED", this.toString(this.mNode.nodeName()), this.ncName);
            return;
        }
        this.fSourceMap.put(this.ncName, this.fActivityNode);
    }

    @ARule(sa=70, desc="Link must not cross repeatable constructs", author="michal.chmielewski@oracle.com", date="02/17/2007", errors="BPELC_LINK__CROSS_REPEATABLE")
    public void rule_CheckRepeatableConstruct_15() {
        this.fRepeatableConstructNode = mSelector.selectParent(this.fActivityNode.parentNode(), Filters.REPEATABLE_CONSTRUCT);
        if (this.isUndefined(this.fRepeatableConstructNode)) {
            return;
        }
        INode aFlowNode = mSelector.selectParent(this.fRepeatableConstructNode, new IFilter<INode>(){

            @Override
            public boolean select(INode node) {
                return node.equals(SourceValidator.this.fFlowNode);
            }
        });
        if (this.mModelQuery.check(0, aFlowNode, this.fFlowNode)) {
            IProblem problem = this.createError();
            problem.fill("BPELC_LINK__CROSS_REPEATABLE", this.toString(this.mNode.nodeName()), this.ncName, this.toString(this.fRepeatableConstructNode.nodeName()), this.fRepeatableConstructNode.getAttribute(AT_NAME));
        }
    }

    @ARule(sa=71, desc="Check for links crossing event handlers boundaries", author="michal.chmielewski@oracle.com", date="02/17/2007", tag="pass2", errors="BPELC_LINK__OUTBOUND_ONLY")
    public void rule_CheckEventHandlersBoundary_20() {
        this.fFaultHandlerNode = mSelector.selectParent(this.fActivityNode.parentNode(), Filters.FAULT_HANDLER_BOUNDARY);
        if (this.isUndefined(this.fFaultHandlerNode)) {
            return;
        }
        this.fTargetMap = this.getValue(this.fFlowNode, FlowValidator.TARGET_MAP, null);
        this.fTargetActivity = this.fTargetMap.get(this.ncName);
        if (this.isUndefined(this.fTargetActivity)) {
            return;
        }
        INode scope = mSelector.selectParent(this.fFaultHandlerNode, Filters.SCOPE);
        if (this.isUndefined(scope)) {
            return;
        }
        INode target = this.fTargetActivity;
        while (target != null) {
            if (this.mModelQuery.check(0, target, scope)) {
                IProblem problem = this.createError();
                problem.fill("BPELC_LINK__OUTBOUND_ONLY", this.toString(this.mNode.nodeName()), this.ncName, this.toString(this.fFaultHandlerNode.nodeName()));
                break;
            }
            target = target.parentNode();
        }
    }
}

