/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.execution;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeTraverser;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.buildship.core.console.ProcessDescription;
import org.eclipse.buildship.ui.external.viewer.FilteredTree;
import org.eclipse.buildship.ui.external.viewer.PatternFilter;
import org.eclipse.buildship.ui.util.nodeselection.ActionShowingContextMenuListener;
import org.eclipse.buildship.ui.util.nodeselection.NodeSelection;
import org.eclipse.buildship.ui.util.nodeselection.NodeSelectionProvider;
import org.eclipse.buildship.ui.util.nodeselection.SelectionHistoryManager;
import org.eclipse.buildship.ui.util.nodeselection.SelectionSpecificAction;
import org.eclipse.buildship.ui.view.BasePage;
import org.eclipse.buildship.ui.view.CollapseAllTreeNodesAction;
import org.eclipse.buildship.ui.view.ExpandAllTreeNodesAction;
import org.eclipse.buildship.ui.view.PageSite;
import org.eclipse.buildship.ui.view.ShowFilterAction;
import org.eclipse.buildship.ui.view.execution.CancelBuildExecutionAction;
import org.eclipse.buildship.ui.view.execution.ExecutionPageContentProvider;
import org.eclipse.buildship.ui.view.execution.ExecutionPageDurationLabelProvider;
import org.eclipse.buildship.ui.view.execution.ExecutionPageNameLabelProvider;
import org.eclipse.buildship.ui.view.execution.ExecutionProgressListener;
import org.eclipse.buildship.ui.view.execution.ExecutionViewMessages;
import org.eclipse.buildship.ui.view.execution.ExecutionViewState;
import org.eclipse.buildship.ui.view.execution.ExecutionsView;
import org.eclipse.buildship.ui.view.execution.OpenBuildScanAction;
import org.eclipse.buildship.ui.view.execution.OpenTestSourceFileAction;
import org.eclipse.buildship.ui.view.execution.OperationItem;
import org.eclipse.buildship.ui.view.execution.RemoveAllTerminatedExecutionPagesAction;
import org.eclipse.buildship.ui.view.execution.RemoveTerminatedExecutionPageAction;
import org.eclipse.buildship.ui.view.execution.RerunBuildExecutionAction;
import org.eclipse.buildship.ui.view.execution.RerunFailedTestsAction;
import org.eclipse.buildship.ui.view.execution.RunTestAction;
import org.eclipse.buildship.ui.view.execution.ShowFailureAction;
import org.eclipse.buildship.ui.view.execution.SwitchToConsoleViewAction;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.events.FailureResult;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.ProgressListener;
import org.gradle.tooling.events.StartEvent;
import org.gradle.tooling.events.task.TaskOperationDescriptor;
import org.gradle.tooling.events.test.JvmTestKind;
import org.gradle.tooling.events.test.JvmTestOperationDescriptor;

public final class ExecutionPage
extends BasePage<FilteredTree>
implements NodeSelectionProvider {
    private final ProcessDescription processDescription;
    private final LongRunningOperation operation;
    private final ExecutionViewState state;
    private final Map<OperationDescriptor, OperationItem> allItems;
    private final Set<OperationItem> activeItems;
    private final Set<OperationItem> removedItems;
    private FilteredTree filteredTree;
    private SelectionHistoryManager selectionHistoryManager;
    private TreeViewerColumn nameColumn;
    private TreeViewerColumn durationColumn;
    private ExecutionProgressListener progressListener;
    private OpenBuildScanAction openBuildScanAction;

    public ExecutionPage(ProcessDescription processDescription, LongRunningOperation operation, ExecutionViewState state) {
        this.processDescription = processDescription;
        this.operation = operation;
        this.state = state;
        this.allItems = Maps.newHashMap();
        this.activeItems = Sets.newHashSet();
        this.removedItems = Sets.newHashSet();
    }

    public ProcessDescription getProcessDescription() {
        return this.processDescription;
    }

    @Override
    public String getDisplayName() {
        return this.processDescription.getName();
    }

    @Override
    public FilteredTree createPageWithResult(Composite parent) {
        this.filteredTree = new FilteredTree(parent, 770, new PatternFilter(true));
        this.filteredTree.setShowFilterControls(false);
        this.filteredTree.getViewer().getTree().setHeaderVisible(true);
        this.filteredTree.getViewer().setContentProvider((IContentProvider)new ExecutionPageContentProvider());
        this.filteredTree.getViewer().setUseHashlookup(true);
        this.nameColumn = new TreeViewerColumn(this.filteredTree.getViewer(), 0);
        this.nameColumn.getColumn().setText(ExecutionViewMessages.Tree_Column_Operation_Name_Text);
        this.nameColumn.getColumn().setWidth(this.state.getHeaderNameColumnWidth());
        this.nameColumn.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ExecutionPageNameLabelProvider()));
        this.durationColumn = new TreeViewerColumn(this.filteredTree.getViewer(), 131072);
        this.durationColumn.getColumn().setText(ExecutionViewMessages.Tree_Column_Operation_Duration_Text);
        this.durationColumn.getColumn().setWidth(this.state.getHeaderDurationColumnWidth());
        this.durationColumn.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ExecutionPageDurationLabelProvider()));
        this.nameColumn.getColumn().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int newWidth = ExecutionPage.this.nameColumn.getColumn().getWidth();
                ExecutionPage.this.state.setHeaderNameColumnWidth(newWidth);
                ExecutionsView view = (ExecutionsView)ExecutionPage.this.getSite().getViewSite().getPart();
                for (ExecutionPage page : FluentIterable.from(view.getPages()).filter(ExecutionPage.class)) {
                    TreeColumn column;
                    int columnWidth;
                    if (page == ExecutionPage.this || (columnWidth = (column = page.nameColumn.getColumn()).getWidth()) == newWidth) continue;
                    column.setWidth(newWidth);
                }
            }
        });
        this.durationColumn.getColumn().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int newWidth = ExecutionPage.this.durationColumn.getColumn().getWidth();
                ExecutionPage.this.state.setHeaderDurationColumnWidth(newWidth);
                ExecutionsView view = (ExecutionsView)ExecutionPage.this.getSite().getViewSite().getPart();
                for (ExecutionPage page : FluentIterable.from(view.getPages()).filter(ExecutionPage.class)) {
                    TreeColumn column;
                    int columnWidth;
                    if (page == ExecutionPage.this || (columnWidth = (column = page.durationColumn.getColumn()).getWidth()) == newWidth) continue;
                    column.setWidth(newWidth);
                }
            }
        });
        this.selectionHistoryManager = new SelectionHistoryManager(this.filteredTree.getViewer());
        OperationItem root = new OperationItem();
        this.filteredTree.getViewer().setInput((Object)root);
        this.allItems.put(null, root);
        this.progressListener = new ExecutionProgressListener(this, this.processDescription.getJob());
        this.operation.addProgressListener((ProgressListener)this.progressListener);
        return this.filteredTree;
    }

    public void onProgress(ProgressEvent progressEvent) {
        OperationDescriptor descriptor = progressEvent.getDescriptor();
        if (this.isExcluded(descriptor)) {
            return;
        }
        OperationItem operationItem = this.allItems.get(descriptor);
        if (null == operationItem) {
            operationItem = new OperationItem((StartEvent)progressEvent);
            this.allItems.put(descriptor, operationItem);
            this.activeItems.add(operationItem);
        } else {
            operationItem.setFinishEvent((FinishEvent)progressEvent);
            this.removedItems.add(operationItem);
            if (this.isJvmTestSuite(descriptor) && operationItem.getChildren().isEmpty()) {
                OperationItem parentOperationItem = this.allItems.get(this.findFirstNonExcludedParent(descriptor));
                parentOperationItem.removeChild(operationItem);
                return;
            }
        }
        OperationItem parentExecutionItem = this.allItems.get(this.findFirstNonExcludedParent(descriptor));
        parentExecutionItem.addChild(operationItem);
    }

    private boolean isExcluded(OperationDescriptor descriptor) {
        if (descriptor instanceof JvmTestOperationDescriptor) {
            JvmTestOperationDescriptor jvmTestOperationDescriptor = (JvmTestOperationDescriptor)descriptor;
            return jvmTestOperationDescriptor.getSuiteName() != null && jvmTestOperationDescriptor.getClassName() == null;
        }
        return false;
    }

    private OperationDescriptor findFirstNonExcludedParent(OperationDescriptor descriptor) {
        while (this.isExcluded(descriptor.getParent())) {
            descriptor = descriptor.getParent();
        }
        return descriptor.getParent();
    }

    public void refreshChangedItems() {
        TreeViewer viewer = this.filteredTree.getViewer();
        for (OperationItem item : Sets.union(this.activeItems, this.removedItems)) {
            viewer.update((Object)item, null);
            if (!this.shouldBeVisible(item)) continue;
            viewer.expandToLevel((Object)item, 0);
        }
        viewer.refresh(false);
        this.activeItems.removeAll(this.removedItems);
        this.removedItems.clear();
    }

    private boolean shouldBeVisible(OperationItem item) {
        return this.isOnMax2ndLevel(item) || this.isTaskOperation(item) || this.isFailedOperation(item);
    }

    private boolean isOnMax2ndLevel(OperationItem item) {
        int level = 2;
        while (level >= 0) {
            if (item.getParent() == null) {
                return true;
            }
            --level;
            item = item.getParent();
        }
        return false;
    }

    private boolean isTaskOperation(OperationItem item) {
        return item.getStartEvent().getDescriptor() instanceof TaskOperationDescriptor;
    }

    private boolean isFailedOperation(OperationItem item) {
        FinishEvent finishEvent = item.getFinishEvent();
        return finishEvent != null ? finishEvent.getResult() instanceof FailureResult : false;
    }

    private boolean isJvmTestSuite(OperationDescriptor descriptor) {
        JvmTestOperationDescriptor testOperationDescriptor;
        return descriptor instanceof JvmTestOperationDescriptor && (testOperationDescriptor = (JvmTestOperationDescriptor)descriptor).getJvmTestKind() == JvmTestKind.SUITE;
    }

    @Override
    public void init(PageSite pageSite) {
        super.init(pageSite);
        this.populateToolBar();
        this.registerContextMenu(pageSite);
        this.registerListeners();
    }

    private void populateToolBar() {
        IActionBars actionBars = this.getSite().getActionBars();
        IToolBarManager toolbarManager = actionBars.getToolBarManager();
        toolbarManager.appendToGroup("pageGroup", (IAction)new ExpandAllTreeNodesAction((AbstractTreeViewer)((FilteredTree)((Object)this.getPageControl())).getViewer()));
        toolbarManager.appendToGroup("pageGroup", (IAction)new CollapseAllTreeNodesAction((AbstractTreeViewer)((FilteredTree)((Object)this.getPageControl())).getViewer()));
        toolbarManager.appendToGroup("pageGroup", (IAction)new ShowFilterAction((FilteredTree)((Object)this.getPageControl())));
        toolbarManager.appendToGroup("pageGroup", (IContributionItem)new Separator());
        toolbarManager.appendToGroup("pageGroup", (IAction)new SwitchToConsoleViewAction(this));
        toolbarManager.appendToGroup("pageGroup", (IContributionItem)new Separator());
        toolbarManager.appendToGroup("pageGroup", (IAction)new RerunFailedTestsAction(this));
        this.openBuildScanAction = new OpenBuildScanAction(this.getProcessDescription());
        toolbarManager.appendToGroup("pageGroup", (IAction)this.openBuildScanAction);
        toolbarManager.appendToGroup("pageGroup", (IContributionItem)new Separator());
        toolbarManager.appendToGroup("pageGroup", (IAction)new CancelBuildExecutionAction(this));
        toolbarManager.appendToGroup("pageGroup", (IAction)new RerunBuildExecutionAction(this));
        toolbarManager.appendToGroup("pageGroup", (IAction)new RemoveTerminatedExecutionPageAction(this));
        toolbarManager.appendToGroup("pageGroup", (IAction)new RemoveAllTerminatedExecutionPagesAction(this));
        toolbarManager.update(true);
    }

    private void registerContextMenu(PageSite pageSite) {
        TreeViewer treeViewer = ((FilteredTree)((Object)this.getPageControl())).getViewer();
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this.createContextMenuListener(treeViewer));
        Menu contextMenu = menuManager.createContextMenu((Control)treeViewer.getTree());
        treeViewer.getTree().setMenu(contextMenu);
        pageSite.getViewSite().registerContextMenu(menuManager, (ISelectionProvider)treeViewer);
    }

    private ActionShowingContextMenuListener createContextMenuListener(TreeViewer treeViewer) {
        RunTestAction runTestAction = new RunTestAction(this);
        ShowFailureAction showFailureAction = new ShowFailureAction(this);
        OpenTestSourceFileAction openTestSourceFileAction = new OpenTestSourceFileAction(this);
        ImmutableList contextMenuActions = ImmutableList.of((Object)runTestAction, (Object)showFailureAction, (Object)openTestSourceFileAction);
        ImmutableList contextMenuActionsPrecededBySeparator = ImmutableList.of((Object)openTestSourceFileAction);
        ImmutableList contextMenuActionsSucceededBySeparator = ImmutableList.of();
        return new ActionShowingContextMenuListener(this, (List<? extends SelectionSpecificAction>)contextMenuActions, (List<? extends SelectionSpecificAction>)contextMenuActionsPrecededBySeparator, (List<? extends SelectionSpecificAction>)contextMenuActionsSucceededBySeparator);
    }

    private void registerListeners() {
        ((FilteredTree)((Object)this.getPageControl())).getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                OpenTestSourceFileAction openTestSourceFileAction = new OpenTestSourceFileAction(ExecutionPage.this);
                NodeSelection nodeSelection = NodeSelection.from(event.getSelection());
                if (openTestSourceFileAction.isVisibleFor(nodeSelection) && openTestSourceFileAction.isEnabledFor(nodeSelection)) {
                    openTestSourceFileAction.run();
                } else if (nodeSelection.isSingleSelection()) {
                    Object selected = nodeSelection.toList().get(0);
                    TreeViewer viewer = ((FilteredTree)((Object)ExecutionPage.this.getPageControl())).getViewer();
                    IContentProvider provider = viewer.getContentProvider();
                    if (provider instanceof ITreeContentProvider && ((ITreeContentProvider)provider).hasChildren(selected)) {
                        if (viewer.getExpandedState(selected)) {
                            viewer.collapseToLevel(selected, -1);
                        } else {
                            viewer.expandToLevel(selected, 1);
                        }
                    }
                }
            }
        });
    }

    public FluentIterable<OperationItem> filterTreeNodes(Predicate<OperationItem> predicate) {
        OperationItem root = (OperationItem)((FilteredTree)((Object)this.getPageControl())).getViewer().getInput();
        if (root == null) {
            return FluentIterable.from((Iterable)ImmutableList.of());
        }
        return new TreeTraverser<OperationItem>(){

            public Iterable<OperationItem> children(OperationItem operationItem) {
                return operationItem.getChildren();
            }
        }.breadthFirstTraversal((Object)root).filter(predicate);
    }

    public Object getAdapter(Class adapter) {
        if (FilteredTree.class.equals((Object)adapter)) {
            return this.getPageControl();
        }
        if (adapter.isAssignableFrom(TreeViewer.class)) {
            return ((FilteredTree)((Object)this.getPageControl())).getViewer();
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Override
    public boolean isCloseable() {
        return this.processDescription.getJob().getState() == 0;
    }

    @Override
    public NodeSelection getSelection() {
        return this.selectionHistoryManager.getSelectionHistory();
    }

    @Override
    public void dispose() {
        if (this.openBuildScanAction != null) {
            this.openBuildScanAction.dispose();
        }
        if (this.selectionHistoryManager != null) {
            this.selectionHistoryManager.dispose();
        }
        super.dispose();
    }
}

