/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.ArrayList;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.ui.dialogs.IStatusChangeListener;
import org.eclipse.cdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.cdt.utils.ui.controls.TabFolderLayout;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class TabConfigurationBlock
extends OptionsConfigurationBlock {
    private final OptionsConfigurationBlock[] fTabs;
    private final String[] fTabLabels;
    private IStatus fStatus = Status.OK_STATUS;

    public TabConfigurationBlock(IStatusChangeListener context, IProject project, OptionsConfigurationBlock[] tabs, String[] tabLabels, IWorkbenchPreferenceContainer container) {
        super(context, project, TabConfigurationBlock.getAllKeys(tabs), container);
        if (tabLabels.length != tabs.length) {
            throw new IllegalArgumentException("Number of labels doesn't match the number of tabs");
        }
        this.fTabs = tabs;
        this.fTabLabels = tabLabels;
        IStatusChangeListener statusMerger = new IStatusChangeListener(){

            @Override
            public void statusChanged(IStatus status) {
                if (status.getSeverity() > TabConfigurationBlock.this.fStatus.getSeverity()) {
                    TabConfigurationBlock.this.fStatus = status;
                }
            }
        };
        OptionsConfigurationBlock[] optionsConfigurationBlockArray = tabs;
        int n = tabs.length;
        int n2 = 0;
        while (n2 < n) {
            OptionsConfigurationBlock tab = optionsConfigurationBlockArray[n2];
            tab.fContext = statusMerger;
            ++n2;
        }
    }

    private static OptionsConfigurationBlock.Key[] getAllKeys(OptionsConfigurationBlock[] tabs) {
        ArrayList keys = new ArrayList();
        OptionsConfigurationBlock[] optionsConfigurationBlockArray = tabs;
        int n = tabs.length;
        int n2 = 0;
        while (n2 < n) {
            OptionsConfigurationBlock tab = optionsConfigurationBlockArray[n2];
            ArrayUtil.addAll(keys, (Object[])tab.fAllKeys);
            ++n2;
        }
        return keys.toArray(new OptionsConfigurationBlock.Key[keys.size()]);
    }

    @Override
    protected Control createContents(Composite parent) {
        PixelConverter pixelConverter = new PixelConverter((Control)parent);
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(4, 4, false, false));
        int i = 0;
        while (i < this.fTabs.length) {
            TabItem item = new TabItem(folder, 0);
            item.setText(this.fTabLabels[i]);
            Composite composite = new Composite((Composite)folder, 0);
            FillLayout layout = new FillLayout();
            layout.marginHeight = pixelConverter.convertHorizontalDLUsToPixels(4);
            layout.marginWidth = pixelConverter.convertVerticalDLUsToPixels(4);
            composite.setLayout((Layout)layout);
            item.setControl((Control)composite);
            item.setData((Object)this.fTabs[i]);
            this.fTabs[i].createContents(composite);
            ++i;
        }
        Dialog.applyDialogFont((Control)folder);
        folder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                OptionsConfigurationBlock[] optionsConfigurationBlockArray = TabConfigurationBlock.this.fTabs;
                int n = optionsConfigurationBlockArray.length;
                int n2 = 0;
                while (n2 < n) {
                    OptionsConfigurationBlock tab = optionsConfigurationBlockArray[n2];
                    tab.updateControls();
                    ++n2;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return folder;
    }

    @Override
    protected void validateSettings(OptionsConfigurationBlock.Key changedKey, String oldValue, String newValue) {
        this.fStatus = Status.OK_STATUS;
        OptionsConfigurationBlock[] optionsConfigurationBlockArray = this.fTabs;
        int n = this.fTabs.length;
        int n2 = 0;
        while (n2 < n) {
            OptionsConfigurationBlock tab = optionsConfigurationBlockArray[n2];
            tab.validateSettings(changedKey, oldValue, newValue);
            if (this.fStatus.getSeverity() >= 4) break;
            ++n2;
        }
        this.fContext.statusChanged(this.fStatus);
    }

    @Override
    public boolean performOk() {
        OptionsConfigurationBlock[] optionsConfigurationBlockArray = this.fTabs;
        int n = this.fTabs.length;
        int n2 = 0;
        while (n2 < n) {
            OptionsConfigurationBlock tab = optionsConfigurationBlockArray[n2];
            tab.performOk();
            ++n2;
        }
        return super.performOk();
    }

    @Override
    public boolean performApply() {
        OptionsConfigurationBlock[] optionsConfigurationBlockArray = this.fTabs;
        int n = this.fTabs.length;
        int n2 = 0;
        while (n2 < n) {
            OptionsConfigurationBlock tab = optionsConfigurationBlockArray[n2];
            tab.performApply();
            ++n2;
        }
        return super.performApply();
    }

    @Override
    public void performDefaults() {
        super.performDefaults();
        OptionsConfigurationBlock[] optionsConfigurationBlockArray = this.fTabs;
        int n = this.fTabs.length;
        int n2 = 0;
        while (n2 < n) {
            OptionsConfigurationBlock tab = optionsConfigurationBlockArray[n2];
            tab.performDefaults();
            ++n2;
        }
    }

    @Override
    public void performRevert() {
        super.performRevert();
        OptionsConfigurationBlock[] optionsConfigurationBlockArray = this.fTabs;
        int n = this.fTabs.length;
        int n2 = 0;
        while (n2 < n) {
            OptionsConfigurationBlock tab = optionsConfigurationBlockArray[n2];
            tab.performRevert();
            ++n2;
        }
    }
}

