/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.util;

import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.StyledString;

public class Strings {
    private Strings() {
    }

    public static boolean startsWithIgnoreCase(String text, String prefix) {
        int prefixLength;
        int textLength = text.length();
        if (textLength < (prefixLength = prefix.length())) {
            return false;
        }
        int i = prefixLength - 1;
        while (i >= 0) {
            if (Character.toLowerCase(prefix.charAt(i)) != Character.toLowerCase(text.charAt(i))) {
                return false;
            }
            --i;
        }
        return true;
    }

    public static boolean isLowerCase(char ch) {
        return Character.toLowerCase(ch) == ch;
    }

    public static String removeMnemonicIndicator(String string) {
        return LegacyActionTools.removeMnemonics((String)string);
    }

    public static String[] convertIntoLines(String input) {
        try {
            DefaultLineTracker tracker = new DefaultLineTracker();
            tracker.set(input);
            int size = tracker.getNumberOfLines();
            String[] result = new String[size];
            int i = 0;
            while (i < size) {
                IRegion region = tracker.getLineInformation(i);
                int offset = region.getOffset();
                result[i] = input.substring(offset, offset + region.getLength());
                ++i;
            }
            return result;
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    public static String concatenate(String[] lines, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < lines.length) {
            if (i > 0) {
                buffer.append(delimiter);
            }
            buffer.append(lines[i]);
            ++i;
        }
        return buffer.toString();
    }

    public static boolean containsOnlyWhitespaces(String s) {
        int size = s.length();
        int i = 0;
        while (i < size) {
            if (!Character.isWhitespace(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void markMatchingRegions(StyledString styledString, int index, int[] matchingRegions, StyledString.Styler styler) {
        if (matchingRegions != null) {
            int offset = -1;
            int length = 0;
            int i = 0;
            while (i + 1 < matchingRegions.length) {
                if (offset == -1) {
                    offset = index + matchingRegions[i];
                }
                if (i + 2 < matchingRegions.length && matchingRegions[i] + matchingRegions[i + 1] == matchingRegions[i + 2]) {
                    length += matchingRegions[i + 1];
                } else {
                    styledString.setStyle(offset, length + matchingRegions[i + 1], styler);
                    offset = -1;
                    length = 0;
                }
                i += 2;
            }
        }
    }
}

