/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common;

import java.util.List;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractPickList
extends Composite {
    protected ComboViewer picker;
    protected TableViewer viewer;
    private final Group group;
    private final Composite toolBar;
    protected final Button tiRemove;
    protected final Button tiUp;
    protected final Button tiDown;
    protected final Button tiAdd;

    public AbstractPickList(Composite parent, int style, List<PickListFeatures> listFeatures, Messages messages, AbstractComponentEditor componentEditor) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.group = new Group((Composite)this, 0);
        this.group.setLayout((Layout)new GridLayout(1, false));
        Composite comp = new Composite((Composite)this.group, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(4, 128, true, false));
        this.picker = new ComboViewer(comp, 2060);
        Combo control = this.picker.getCombo();
        GridData gdpicker = new GridData(4, 0x1000000, true, false);
        gdpicker.minimumWidth = 180;
        gdpicker.grabExcessHorizontalSpace = true;
        control.setLayoutData((Object)gdpicker);
        this.toolBar = new Composite(comp, 0);
        layout = new GridLayout(5, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.toolBar.setLayout((Layout)layout);
        this.toolBar.setLayoutData((Object)new GridData(4, 128, true, false));
        this.toolBar.setFont(this.group.getFont());
        this.picker.addOpenListener(event -> this.addPressed());
        this.tiAdd = new Button(this.toolBar, 8);
        this.tiAdd.setToolTipText(messages.ModelTooling_Common_AddEllipsis);
        this.tiAdd.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.tiAdd.setImage(componentEditor.createImage("IMG_org.eclipse.e4.tools.emf.ui.obj16.table_add"));
        this.tiAdd.setFont(this.getButtonFont());
        this.tiAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractPickList.this.addPressed();
            }
        });
        this.tiRemove = new Button(this.toolBar, 8);
        this.tiRemove.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.tiRemove.setToolTipText(messages.ModelTooling_Common_Remove);
        this.tiRemove.setImage(componentEditor.createImage("IMG_org.eclipse.e4.tools.emf.ui.obj16.table_delete"));
        this.tiRemove.setFont(this.getButtonFont());
        this.tiRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractPickList.this.removePressed();
            }
        });
        this.tiDown = new Button(this.toolBar, 8);
        this.tiDown.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.tiDown.setToolTipText(messages.ModelTooling_Common_Down);
        this.tiDown.setImage(componentEditor.createImage("IMG_org.eclipse.e4.tools.emf.ui.obj16.arrow_down"));
        this.tiDown.setFont(this.getButtonFont());
        this.tiDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractPickList.this.moveDownPressed();
            }
        });
        this.tiUp = new Button(this.toolBar, 8);
        this.tiUp.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.tiUp.setToolTipText(messages.ModelTooling_Common_Up);
        this.tiUp.setImage(componentEditor.createImage("IMG_org.eclipse.e4.tools.emf.ui.obj16.arrow_up"));
        this.tiUp.setFont(this.getButtonFont());
        this.tiUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractPickList.this.moveUpPressed();
            }
        });
        this.viewer = new TableViewer((Composite)this.group);
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.addSelectionChangedListener(event -> this.updateUiState());
        this.updateUiState();
        if (listFeatures != null) {
            if (listFeatures.contains((Object)PickListFeatures.NO_ORDER)) {
                this.tiDown.dispose();
                this.tiUp.dispose();
            }
            if (listFeatures.contains((Object)PickListFeatures.NO_PICKER)) {
                ((GridData)this.picker.getControl().getLayoutData()).exclude = true;
                this.picker.getControl().setVisible(false);
                this.pack();
            }
        }
    }

    protected Font getButtonFont() {
        return this.group.getFont();
    }

    protected void addPressed() {
    }

    protected abstract int getItemCount();

    public TableViewer getList() {
        return this.viewer;
    }

    public void setInput(Object input) {
        this.getPicker().setInput(input);
    }

    public ISelection getSelection() {
        return this.getPicker().getSelection();
    }

    public void setSelection(ISelection selection) {
        this.getPicker().setSelection(selection);
    }

    public void setContentProvider(IContentProvider contentProvider) {
        this.getPicker().setContentProvider(contentProvider);
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.getPicker().setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    private ComboViewer getPicker() {
        return this.picker;
    }

    public void setComparator(ViewerComparator comparator) {
        this.getPicker().setComparator(comparator);
    }

    protected Composite getToolBar() {
        return this.toolBar;
    }

    protected void moveDownPressed() {
    }

    protected void moveUpPressed() {
    }

    protected void removePressed() {
    }

    public void setText(String text) {
        this.group.setText(text);
    }

    public void updateUiState() {
        IStructuredSelection selection = (IStructuredSelection)this.getList().getSelection();
        boolean selected = selection.size() > 0;
        int count = this.getItemCount();
        boolean tableIsFocused = this.getList().getTable().isFocusControl();
        if (!this.tiDown.isDisposed()) {
            this.tiDown.setEnabled(selected && count > 1 && tableIsFocused);
            this.tiUp.setEnabled(selected && count > 1 && tableIsFocused);
        }
        this.tiRemove.setEnabled(selected && tableIsFocused);
    }

    public static enum PickListFeatures {
        NO_ORDER,
        NO_PICKER;

    }
}

