/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.ui.stylizer;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.cdo.dawn.appearance.DawnElementStylizer;
import org.eclipse.emf.cdo.dawn.appearance.IDawnElementStylizerFactory;
import org.eclipse.emf.cdo.dawn.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.dawn.ui.stylizer.DawnDefaultElementStylizer;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DawnElementStylizerRegistry {
    private static final String ATTRIBUTE_PRIORITY = "priority";
    private static final String ATTRIIBUTE_FACTORY = "factory";
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, DawnElementStylizerRegistry.class);
    private static final String DAWN_STYLIZER_FACTORY_EXTENSION_POINT_ID = "org.eclipse.emf.cdo.dawn.elementstylizerfactory";
    public static DawnElementStylizerRegistry instance = new DawnElementStylizerRegistry();
    private Map<String, DawnElementStylizer> registeredStylizers = new HashMap<String, DawnElementStylizer>();
    private Map<String, FactoryContainer> stylizerFactories = new HashMap<String, FactoryContainer>();
    private DawnDefaultElementStylizer dawnDefaultElementStylizer;

    public DawnElementStylizer getStylizer(Object object) {
        DawnElementStylizer stylizer = this.registeredStylizers.get(object.getClass().getCanonicalName());
        if (stylizer == null) {
            stylizer = this.getStylizerFromExtensionPoint(object);
            this.registeredStylizers.put(object.getClass().getCanonicalName(), stylizer);
        }
        if (stylizer == null) {
            stylizer = this.getDefaultStylizer(object);
        }
        return stylizer;
    }

    private DawnElementStylizer getDefaultStylizer(Object object) {
        this.dawnDefaultElementStylizer = new DawnDefaultElementStylizer();
        return this.dawnDefaultElementStylizer;
    }

    private DawnElementStylizer getStylizerFromExtensionPoint(Object object) {
        Map<String, FactoryContainer> factories = this.getFactories();
        DawnElementStylizer elementStylizer = null;
        int lastPriority = -1;
        for (FactoryContainer factoryContainer : factories.values()) {
            int priority;
            DawnElementStylizer currentElementStylizer = factoryContainer.getFactory().getElementStylizer(object);
            if (currentElementStylizer == null || (priority = factoryContainer.getPriority()) <= lastPriority) continue;
            elementStylizer = currentElementStylizer;
            lastPriority = priority;
        }
        return elementStylizer;
    }

    private Map<String, FactoryContainer> getFactories() {
        try {
            IConfigurationElement[] config;
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(DAWN_STYLIZER_FACTORY_EXTENSION_POINT_ID);
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                String factoryClassName = e.getAttribute(ATTRIIBUTE_FACTORY);
                if (!this.stylizerFactories.containsKey(factoryClassName)) {
                    IDawnElementStylizerFactory stylizer = (IDawnElementStylizerFactory)e.createExecutableExtension(ATTRIIBUTE_FACTORY);
                    int priority = Integer.parseInt(e.getAttribute(ATTRIBUTE_PRIORITY).substring(0, 1));
                    FactoryContainer container = new FactoryContainer(priority, stylizer);
                    this.stylizerFactories.put(factoryClassName, container);
                    if (TRACER.isEnabled()) {
                        TRACER.format("Registered IDawnElementStylizerFactory {0} ", new Object[]{stylizer});
                    }
                }
                ++n2;
            }
        }
        catch (InvalidRegistryObjectException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return this.stylizerFactories;
    }

    private class FactoryContainer {
        private int priority;
        private IDawnElementStylizerFactory factory;

        public FactoryContainer(int priority, IDawnElementStylizerFactory factory) {
            this.priority = priority;
            this.factory = factory;
        }

        public IDawnElementStylizerFactory getFactory() {
            return this.factory;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

