/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.views.resource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ui.PlatformUI;

public class WorkspaceResourcesListener
implements IResourceChangeListener {
    private ResourceSet resourceSet;
    private static final Logger LOGGER = Logger.getLogger(WorkspaceResourcesListener.class);

    public WorkspaceResourcesListener(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                WorkspaceResourcesListener.this.manageEvent(event);
            }
        });
    }

    private void manageEvent(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
        try {
            delta.accept((IResourceDeltaVisitor)visitor);
        }
        catch (CoreException e) {
            LOGGER.error((Object)"manageEnvent", (Throwable)e);
        }
        ArrayList<String> changedObjectUris = new ArrayList<String>();
        if (!visitor.getChangedResources().isEmpty()) {
            for (Resource resource : visitor.getChangedResources()) {
                String resourceUri = EcoreUtil.getURI((EObject)((EObject)resource.getContents().get(0))).toString();
                changedObjectUris.add(resourceUri);
            }
        }
        this.aftertResourcesChanged(changedObjectUris);
    }

    public void removeWorkspaceListener() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    protected void aftertResourcesChanged(List<String> changedObjectUris) {
    }

    private class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private final Collection<Resource> changedResources = new ArrayList<Resource>();

        private ResourceDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) {
            String fullPath;
            int type = delta.getResource().getType();
            if (type == 1 && delta.getKind() == 4 && delta.getFlags() != 131072 && !(fullPath = delta.getFullPath().toString()).contains(".git") && !fullPath.endsWith(".project")) {
                Resource resource = WorkspaceResourcesListener.this.resourceSet.getResource(URI.createPlatformResourceURI((String)fullPath, (boolean)true), true);
                this.reload(resource);
                this.changedResources.add(resource);
                return true;
            }
            return true;
        }

        private void reload(Resource resource) {
            if (resource.isLoaded()) {
                resource.unload();
                try {
                    resource.load(Collections.emptyMap());
                }
                catch (IOException e) {
                    LOGGER.error((Object)"reload", (Throwable)e);
                }
            }
            WorkspaceResourcesListener.this.resourceSet.getResources().add((Object)resource);
        }

        public Collection<Resource> getChangedResources() {
            return this.changedResources;
        }
    }
}

